/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.testhelpers;

import eu.simuline.junit.Hierarchy;
import eu.simuline.junit.Logo;
import eu.simuline.junit.SmallLogo;
import eu.simuline.testhelpers.Actions;
import eu.simuline.testhelpers.Editor;
import eu.simuline.testhelpers.Quality;
import eu.simuline.testhelpers.TestCase;
import eu.simuline.util.JavaPath;
import eu.simuline.util.images.GifResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.junit.runner.Description;

class GUIRunner {
    private static final ImageIcon LOGO_ICON = GifResource.getIcon(Logo.class);
    private static final ImageIcon HIERARCHY_ICON = GifResource.getIcon(Hierarchy.class);
    private static final ImageIcon SMALL_LOGO_ICON = GifResource.getIcon(SmallLogo.class);
    private static final Component HORIZ_BOUNDARY = Box.createHorizontalStrut(10);
    private static final Component HORIZ_BOUNDARY2 = Box.createHorizontalStrut(20);
    private static final Component VERTI_BOUNDARY = Box.createVerticalStrut(10);
    private static final int HORIZ_FRAME = 800;
    private static final int VERTI_FRAME = 800;
    static final String CHOOSE_CLASSPATH = "chooseClasspath";
    private final String sourcePath;
    private final JFrame frame;
    private final ClassChooser classChooser;
    private final JLabel className;
    private final TestProgressBar progress;
    private final StatisticsTestState statisticsTestState;
    private TestCaseLister testCaseLister;
    private HierarchyWrapper testHierarchy;
    private JSplitPane splitPane;
    private final JLabel statusBar;

    String openClassChooser() {
        return this.classChooser.getChosenClass();
    }

    GUIRunner(Actions actions, Editor editor, String sourcePath) {
        assert (SwingUtilities.isEventDispatchThread());
        this.sourcePath = sourcePath;
        this.frame = new JFrame("JUnit GUI");
        this.frame.setIconImage(SMALL_LOGO_ICON.getImage());
        this.frame.setDefaultCloseOperation(3);
        this.classChooser = new ClassChooser();
        this.setMenuBar(actions);
        this.className = new JLabel("class name");
        this.statusBar = new JLabel("status bar");
        Container content = this.frame.getContentPane();
        content.setLayout(new BoxLayout(content, 1));
        this.statisticsTestState = new StatisticsTestState();
        this.setCenter(actions, editor);
        Box testClassName = Box.createHorizontalBox();
        testClassName.add(new JLabel("Test class name:    "));
        testClassName.add(this.className);
        testClassName.add(Box.createHorizontalGlue());
        this.frame.add(testClassName);
        Box logoVersion = Box.createVerticalBox();
        logoVersion.add(new JLabel(LOGO_ICON));
        logoVersion.add(new JLabel(Actions.versionOrNa(false)));
        Box progLogoVersion = Box.createHorizontalBox();
        this.progress = new TestProgressBar();
        progLogoVersion.add(this.progress);
        progLogoVersion.add(HORIZ_BOUNDARY2);
        progLogoVersion.add(logoVersion);
        progLogoVersion.add(HORIZ_BOUNDARY);
        this.frame.add(progLogoVersion);
        this.frame.add(this.statisticsTestState.getBox());
        this.frame.add(new JSeparator());
        this.frame.add(VERTI_BOUNDARY);
        this.frame.add(Box.createVerticalGlue());
        Box results = Box.createHorizontalBox();
        results.add(HORIZ_BOUNDARY);
        results.add(new JLabel("Results:"));
        results.add(Box.createGlue());
        this.frame.add(results);
        Box resRun2 = Box.createHorizontalBox();
        resRun2.add(HORIZ_BOUNDARY);
        resRun2.add(this.splitPane);
        resRun2.add(Box.createGlue());
        resRun2.add(new JButton(actions.getStartAction()));
        resRun2.add(HORIZ_BOUNDARY);
        this.frame.add(resRun2);
        Box statExit = Box.createHorizontalBox();
        statExit.add(HORIZ_BOUNDARY);
        statExit.add(this.statusBar);
        statExit.add(Box.createGlue());
        statExit.add(new JButton(actions.getExitAction()));
        statExit.add(HORIZ_BOUNDARY);
        this.frame.add(statExit);
        this.frame.setSize(800, 800);
        this.frame.setVisible(true);
    }

    final void setMenuBar(Actions actions) {
        JMenuBar menubar = new JMenuBar();
        menubar.add(new JMenuItem(actions.getOpenAction()));
        menubar.add(new JMenuItem(actions.getStartAction()));
        menubar.add(new JMenuItem(actions.getStopAction()));
        menubar.add(new JMenuItem(actions.getBreakAction()));
        menubar.add(new JMenuItem(actions.getExitAction()));
        menubar.add(new JLabel("                                           "));
        this.frame.setJMenuBar(menubar);
    }

    final void setCenter(Actions actions, Editor editor) {
        JTabbedPane tabbedPane = new JTabbedPane(3);
        this.testCaseLister = new TestCaseLister(editor, this.sourcePath);
        this.testHierarchy = new HierarchyWrapper(actions, this.testCaseLister);
        tabbedPane.addTab("Test Hierarchy", HIERARCHY_ICON, new JScrollPane(this.testHierarchy.getTree()));
        tabbedPane.addTab("Failures", Quality.Error.getIcon(), new JScrollPane(this.testCaseLister.getFailList()));
        tabbedPane.addChangeListener(new TabChangeListener(tabbedPane, this.testCaseLister, this.testHierarchy));
        this.splitPane = new JSplitPane(0);
        this.splitPane.setTopComponent(tabbedPane);
        this.splitPane.setBottomComponent(this.testCaseLister.getStackTraceBox());
    }

    private void updateG() {
        this.frame.update(this.frame.getGraphics());
    }

    void setStatus(String msg) {
        this.statusBar.setText(msg);
        this.updateG();
    }

    private void setStatus(TestCase testCase) {
        this.setStatus("Test " + testCase.getQuality().getMessage() + ": " + testCase.getDesc());
    }

    TestCase noteTestStartedI(Quality qual) {
        assert (qual == Quality.Started || qual == Quality.Ignored);
        TestCase testCase = this.testHierarchy.noteTestStartedI(qual);
        this.setStatus(testCase);
        return testCase;
    }

    void noteReportResult(TestCase testCase) {
        assert (testCase.getQuality() == Quality.Ignored || testCase.getQuality() == Quality.Invalidated || testCase.getQuality() == Quality.Success || testCase.getQuality() == Quality.Failure || testCase.getQuality() == Quality.Error);
        this.testHierarchy.noteReportResult(testCase);
        this.progress.noteReportResult(testCase);
        this.statisticsTestState.noteReportResult(testCase);
        this.testCaseLister.noteReportResult(testCase);
        this.setStatus(testCase);
    }

    void testClassStructureLoaded(Description desc) {
        this.setStatus("testClassLoaded(");
        this.className.setText(desc.getClassName());
        TestCase testCaseAll = new TestCase(desc);
        this.testHierarchy.initClassStructure(testCaseAll);
        this.testCaseLister.initClassStructure();
        this.progress.initClassStructure(desc);
        this.statisticsTestState.initClassStructure(desc);
    }

    void testRunStarted(Description desc) {
        this.setStatus("testRunStarted(");
        this.testHierarchy.getActions().setEnableForRun(true);
        TestCase root = this.testHierarchy.getRoot();
        this.testHierarchy.startTestRun(desc);
        this.testCaseLister.startTestRun();
        this.progress.startTestRun(root);
        this.statisticsTestState.startTestRun(root);
    }

    void testRunFinished(long runTime) {
        this.setStatus("testRunFinished(required: " + runTime + "ms. ");
        this.testHierarchy.getActions().setEnableForRun(false);
    }

    void testRunAborted() {
        this.setStatus("testRunAborted(");
        this.testHierarchy.getActions().setEnableForRun(false);
    }

    class ClassChooser {
        private final JFileChooser clsFileChooser;
        private final JavaPath clsPath;

        ClassChooser() {
            String classpath = System.getProperty(GUIRunner.CHOOSE_CLASSPATH);
            this.clsPath = new JavaPath(classpath);
            this.clsFileChooser = new JFileChooser(classpath);
            this.clsFileChooser.setMultiSelectionEnabled(false);
            this.clsFileChooser.setFileSelectionMode(0);
            this.clsFileChooser.setFileHidingEnabled(true);
            this.clsFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (!file.isFile()) {
                        return true;
                    }
                    String name = file.getName();
                    return name.endsWith(".class") && !name.contains("$");
                }

                @Override
                public String getDescription() {
                    return "Java class files ending with .class ";
                }
            });
            this.clsFileChooser.setDialogType(0);
            this.clsFileChooser.setDialogTitle("Testclasses");
        }

        String getChosenClass() {
            if (this.clsFileChooser.showOpenDialog(GUIRunner.this.frame) != 0) {
                System.out.println("selection not approved.");
                return null;
            }
            File clsFile = this.clsFileChooser.getSelectedFile();
            if (!clsFile.exists()) {
                System.out.println("Approved file '" + clsFile + "' does not exist.");
                return null;
            }
            return this.clsPath.absFile2cls(clsFile, JavaPath.ClsSrc.Class);
        }
    }

    static class StatisticsTestState
    extends JComponent {
        private static final long serialVersionUID = -2479143000061671589L;
        private final Map<Quality, JLabel> qual2label;
        private final Map<Quality, Integer> qual2num;
        private final JLabel runs = new JLabel();
        private int numRunsDone;
        private int numRuns;

        StatisticsTestState() {
            this.qual2label = new EnumMap<Quality, JLabel>(Quality.class);
            for (Quality qual : Quality.values()) {
                if (qual.isNeutral()) continue;
                this.qual2label.put(qual, new JLabel());
            }
            this.qual2num = new EnumMap<Quality, Integer>(Quality.class);
        }

        Box getBox() {
            Box res = Box.createHorizontalBox();
            res.add(this.runs);
            for (Quality qual : Quality.values()) {
                if (qual.isNeutral()) continue;
                res.add(new JLabel(qual.getIcon()));
                res.add(this.qual2label.get((Object)qual));
            }
            res.add(Box.createGlue());
            return res;
        }

        void initClassStructure(Description desc) {
            this.numRuns = desc.testCount();
            this.numRunsDone = 0;
            for (Quality qual : Quality.values()) {
                this.qual2num.put(qual, 0);
            }
            this.updateLabels();
        }

        void startTestRun(TestCase testCase) {
            this.numRunsDone = 0;
            this.detQual2NumRec(testCase);
            this.updateLabels();
        }

        private void detQual2NumRec(TestCase testCase) {
            if (testCase.isTest()) {
                Quality qual = testCase.getQuality();
                switch (qual) {
                    case Started: {
                        assert (false);
                        break;
                    }
                    case Scheduled: {
                        break;
                    }
                    default: {
                        ++this.numRunsDone;
                    }
                }
                int num = this.qual2num.get((Object)qual);
                this.qual2num.put(qual, ++num);
                return;
            }
            assert (!testCase.isTest());
            for (TestCase child : testCase.getChildren()) {
                this.detQual2NumRec(child);
            }
        }

        void noteReportResult(TestCase testCase) {
            ++this.numRunsDone;
            int num = this.qual2num.get((Object)testCase.getQuality());
            this.qual2num.put(testCase.getQuality(), ++num);
            this.updateLabels();
        }

        private void updateLabels() {
            this.runs.setText("Runs: " + this.numRunsDone + "/" + this.numRuns + "    ");
            for (Quality qual : Quality.values()) {
                if (qual.isNeutral()) continue;
                this.qual2label.get((Object)qual).setText(qual.toString() + "s: " + this.qual2num.get((Object)qual) + "    ");
            }
        }
    }

    static class TestProgressBar
    extends JProgressBar {
        private static final long serialVersionUID = -2479143000061671589L;
        private Quality qual;

        TestProgressBar() {
            super(new DefaultBoundedRangeModel());
            this.model.setValueIsAdjusting(true);
            this.qual = null;
        }

        void initClassStructure(Description desc) {
            this.setMinimum(0);
            this.setMaximum(desc.testCount());
            this.setValue(0);
            this.qual = Quality.Scheduled;
        }

        void startTestRun(TestCase testCase) {
            this.qual = Quality.Scheduled;
            this.setValue(0);
            this.detValQualRec(testCase);
            this.setForeground(this.qual.getColor());
        }

        private void detValQualRec(TestCase testCase) {
            if (testCase.isTest()) {
                Quality qual = testCase.getQuality();
                switch (qual) {
                    case Started: {
                        assert (false);
                        break;
                    }
                    case Scheduled: {
                        break;
                    }
                    default: {
                        this.setValue(this.getValue() + 1);
                        this.qual = this.qual.max(qual);
                    }
                }
                return;
            }
            for (TestCase child : testCase.getChildren()) {
                this.detValQualRec(child);
            }
        }

        void noteReportResult(TestCase testCase) {
            this.setValue(this.getValue() + 1);
            this.qual = this.qual.max(testCase.getQuality());
            this.setForeground(this.qual.getColor());
        }
    }

    static class TestCaseLister
    implements ListSelectionListener,
    Selector {
        private final ListSelectionModel failureSelection = new DefaultListSelectionModel();
        private final DefaultListModel<TestCase> failureListMod;
        private final StackTraceLister stackTraceLister;
        private Selector selector;

        TestCaseLister(Editor editor, String sourcePath) {
            this.failureSelection.setSelectionMode(0);
            this.failureSelection.setValueIsAdjusting(true);
            this.failureSelection.addListSelectionListener(this);
            this.failureListMod = new DefaultListModel();
            this.stackTraceLister = new StackTraceLister(editor, sourcePath);
        }

        JList<TestCase> getFailList() {
            JList<TestCase> jFailureList = new JList<TestCase>(this.failureListMod);
            jFailureList.setCellRenderer(new TestListCellRenderer());
            jFailureList.setSelectionModel(this.failureSelection);
            return jFailureList;
        }

        Component getStackTraceBox() {
            return this.stackTraceLister.getStackTraceBox();
        }

        void initClassStructure() {
            this.failureSelection.clearSelection();
            this.failureListMod.clear();
            this.stackTraceLister.clearStack();
        }

        void startTestRun() {
        }

        void noteReportResult(TestCase testCase) {
            if (testCase.hasFailed() && !this.failureListMod.contains(testCase)) {
                this.failureListMod.addElement(testCase);
                return;
            }
            assert (!testCase.hasFailed() || this.failureListMod.contains(testCase));
            int selIndex = this.failureSelection.getMinSelectionIndex();
            if (selIndex == -1 || testCase != this.failureListMod.getElementAt(selIndex)) {
                return;
            }
            if (testCase.hasFailed()) {
                this.stackTraceLister.setStack(testCase.getThrown());
            } else {
                this.stackTraceLister.clearStack();
            }
        }

        void addSelectedTestCaseByNeed(TestCase testCase) {
            assert (testCase.hasFailed());
            if (this.failureListMod.contains(testCase)) {
                int selIndex = this.failureSelection.getMinSelectionIndex();
                assert (this.failureListMod.get(selIndex) == testCase);
            } else {
                this.failureListMod.addElement(testCase);
                int selIndex = this.failureSelection.getMinSelectionIndex();
                assert (selIndex == -1);
                selIndex = this.failureListMod.size() - 1;
                assert (this.failureListMod.get(selIndex) == testCase);
                this.failureSelection.setSelectionInterval(selIndex, selIndex);
            }
        }

        @Override
        public void setSelection(int index) {
            for (int idx = 0; idx < this.failureListMod.getSize(); ++idx) {
                if (this.failureListMod.get(idx).getIdx() != index) continue;
                this.failureSelection.setSelectionInterval(idx, idx);
                return;
            }
            this.clearSelection();
        }

        @Override
        public void clearSelection() {
            this.failureSelection.clearSelection();
            this.stackTraceLister.clearStack();
        }

        @Override
        public void registerSelector(Selector selector) {
            assert (selector instanceof HierarchyWrapper || selector == TabChangeListener.EMPTY_SELECTOR);
            this.selector = selector;
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            int selIndex = this.failureSelection.getMinSelectionIndex();
            if (selIndex == -1) {
                this.stackTraceLister.clearStack();
                this.selector.clearSelection();
                return;
            }
            TestCase testCase = this.failureListMod.getElementAt(selIndex);
            this.stackTraceLister.setStack(testCase.getThrown());
            this.selector.setSelection(testCase.getIdx());
        }
    }

    static class HierarchyWrapper
    implements Selector,
    TreeSelectionListener {
        private final JTree hierarchyTree;
        private final TreeSelectionModel treeSelection;
        private final Actions actions;
        private final TestCaseLister testCaseLister;
        private DefaultMutableTreeNode singleSelectedNode;
        private TreePathIterator currPathIter;
        private Selector selector;

        HierarchyWrapper(Actions actions, TestCaseLister testCaseLister) {
            assert (SwingUtilities.isEventDispatchThread());
            this.hierarchyTree = new JTree();
            this.treeSelection = new DefaultTreeSelectionModel();
            this.treeSelection.setSelectionMode(1);
            this.hierarchyTree.setSelectionModel(this.treeSelection);
            this.hierarchyTree.addTreeSelectionListener(this);
            this.hierarchyTree.setRootVisible(true);
            TreeNode root = (TreeNode)this.hierarchyTree.getModel().getRoot();
            this.hierarchyTree.setModel(new DefaultTreeModel(root));
            assert (actions != null);
            this.actions = actions;
            assert (testCaseLister != null);
            this.testCaseLister = testCaseLister;
            this.singleSelectedNode = null;
            this.currPathIter = null;
            this.selector = null;
        }

        private static DefaultMutableTreeNode testCase2treeNode(TestCase testCase) {
            if (testCase.isTest()) {
                return new DefaultMutableTreeNode(testCase);
            }
            DefaultMutableTreeNode ret = new DefaultMutableTreeNode(testCase);
            List<TestCase> childrenIn = testCase.getChildren();
            for (TestCase childIn : childrenIn) {
                DefaultMutableTreeNode childOut = HierarchyWrapper.testCase2treeNode(childIn);
                ret.add(childOut);
            }
            return ret;
        }

        TestCase getRoot() {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.hierarchyTree.getModel().getRoot();
            return (TestCase)root.getUserObject();
        }

        Actions getActions() {
            return this.actions;
        }

        void initClassStructure(TestCase testCase) {
            this.singleSelectedNode = HierarchyWrapper.testCase2treeNode(testCase);
            DefaultTreeModel newModel = new DefaultTreeModel(this.singleSelectedNode);
            this.hierarchyTree.setModel(newModel);
            this.hierarchyTree.setCellRenderer(new TestTreeCellRenderer());
            this.currPathIter = null;
            this.setFilter();
        }

        private void setFilter() {
            TestCase testCase = (TestCase)this.singleSelectedNode.getUserObject();
            this.actions.setFilter(testCase.getDesc());
        }

        void startTestRun(Description desc) {
            TestCase testCase = (TestCase)this.singleSelectedNode.getUserObject();
            testCase.setScheduledRec();
            testCase = (TestCase)this.singleSelectedNode.getFirstLeaf().getUserObject();
            this.currPathIter = new TreePathIterator(this.hierarchyTree, testCase.getIdx());
        }

        void expandAlongPath() {
            this.hierarchyTree.expandPath(this.currPathIter.getPath().getParentPath());
        }

        void collapseAlongPath() {
            DefaultMutableTreeNode node;
            List<TreeNode> selPath = Arrays.asList(this.singleSelectedNode.getPath());
            TreePath treePath = this.currPathIter.getPath().getParentPath();
            Object[] pathArr = treePath.getPath();
            for (int idx = pathArr.length - 1; idx >= 0 && !selPath.contains(node = (DefaultMutableTreeNode)pathArr[idx]); --idx) {
                TestCase testCase = (TestCase)node.getUserObject();
                if (!testCase.fullSuccess()) continue;
                Object[] pathArrNew = new Object[idx + 1];
                System.arraycopy(pathArr, 0, pathArrNew, 0, pathArrNew.length);
                treePath = new TreePath(pathArrNew);
                assert (treePath.getLastPathComponent() == pathArr[idx]);
                this.hierarchyTree.collapsePath(treePath);
            }
        }

        JTree getTree() {
            return this.hierarchyTree;
        }

        TreePath getPath() {
            return this.currPathIter.getPath();
        }

        TestCase noteTestStartedI(Quality qual) {
            this.currPathIter.updatePathI();
            this.expandAlongPath();
            DefaultMutableTreeNode lastNode = (DefaultMutableTreeNode)this.currPathIter.getPath().getLastPathComponent();
            TestCase result = (TestCase)lastNode.getUserObject();
            result.setQualStartedIgnored(qual);
            ((DefaultTreeModel)this.hierarchyTree.getModel()).nodeChanged(lastNode);
            return result;
        }

        void noteReportResult(TestCase testCase) {
            this.collapseAlongPath();
            MutableTreeNode lastNode = (MutableTreeNode)this.currPathIter.getPath().getLastPathComponent();
            ((DefaultTreeModel)this.hierarchyTree.getModel()).nodeChanged(lastNode);
            if (testCase.hasFailed() && this.isSelected(testCase)) {
                this.testCaseLister.addSelectedTestCaseByNeed(testCase);
            }
        }

        private boolean isSelected(TestCase testCase) {
            int numSel = this.treeSelection.getSelectionCount();
            if (numSel == 0) {
                return false;
            }
            assert (numSel == 1);
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.treeSelection.getSelectionPath().getLastPathComponent();
            TestCase selTestCase = (TestCase)selNode.getUserObject();
            return selTestCase == testCase;
        }

        @Override
        public void setSelection(int index) {
            TreePathIterator currPathIter = new TreePathIterator(this.hierarchyTree, index + 1);
            this.treeSelection.addSelectionPath(currPathIter.getPath());
        }

        @Override
        public void clearSelection() {
            this.treeSelection.clearSelection();
        }

        @Override
        public void registerSelector(Selector selector) {
            assert (selector instanceof TestCaseLister || selector == TabChangeListener.EMPTY_SELECTOR);
            this.selector = selector;
        }

        @Override
        public void valueChanged(TreeSelectionEvent selEvent) {
            TreePath[] paths = selEvent.getPaths();
            assert (paths.length == 1 || paths.length == 2);
            for (TreePath path : paths) {
                if (selEvent.isAddedPath(path)) {
                    this.singleSelectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                } else {
                    if (paths.length == 2) continue;
                    assert (paths.length == 1);
                    this.singleSelectedNode = (DefaultMutableTreeNode)path.getPathComponent(0);
                }
                this.setFilter();
                if (this.singleSelectedNode.isLeaf()) {
                    TestCase testCase = (TestCase)this.singleSelectedNode.getUserObject();
                    this.selector.setSelection(testCase.getIdx());
                    continue;
                }
                this.selector.clearSelection();
            }
        }
    }

    static class TabChangeListener
    implements ChangeListener {
        private static final int SEL_IND1 = 0;
        private static final Selector EMPTY_SELECTOR = new Selector(){

            @Override
            public void setSelection(int index) {
            }

            @Override
            public void clearSelection() {
            }

            @Override
            public void registerSelector(Selector sel) {
                throw new IllegalStateException();
            }
        };
        private final JTabbedPane tabbedPane;
        private final Selector[] selectors;

        TabChangeListener(JTabbedPane tabbedPane, TestCaseLister testCaseLister, HierarchyWrapper testHierarchy) {
            this.tabbedPane = tabbedPane;
            this.selectors = new Selector[]{testHierarchy, testCaseLister};
            this.setSelUnSel(0);
        }

        private void setSelUnSel(int index) {
            assert (index == 0 || index == 1);
            Selector sel = this.selectors[index];
            Selector notSel = this.selectors[1 - index];
            sel.registerSelector(notSel);
            notSel.registerSelector(EMPTY_SELECTOR);
        }

        @Override
        public void stateChanged(ChangeEvent che) {
            assert (this.tabbedPane == che.getSource());
            this.setSelUnSel(this.tabbedPane.getSelectedIndex());
        }
    }

    static class StackTraceLister
    implements ListSelectionListener {
        private Throwable thrw;
        private final JLabel thrwMessager;
        private final DefaultListModel<String> stacktrace;
        private final ListSelectionModel stackElemSelection;
        private final Editor editor;
        private final String sourcePath;

        StackTraceLister(Editor editor, String sourcePath) {
            this.editor = editor;
            this.sourcePath = sourcePath;
            this.thrw = null;
            this.thrwMessager = new JLabel("", 10);
            this.stacktrace = new DefaultListModel();
            this.stackElemSelection = new DefaultListSelectionModel();
            this.stackElemSelection.setSelectionMode(0);
            this.stackElemSelection.setValueIsAdjusting(true);
            this.stackElemSelection.addListSelectionListener(this);
        }

        Component getStackTraceBox() {
            JList<String> stacktraceList = new JList<String>(this.stacktrace);
            stacktraceList.setSelectionModel(this.stackElemSelection);
            Box stackTraceBox = Box.createVerticalBox();
            stackTraceBox.add(this.thrwMessager);
            stackTraceBox.add(new JScrollPane(stacktraceList));
            return stackTraceBox;
        }

        void clearStack() {
            this.thrw = null;
            this.thrwMessager.setText("");
            this.stacktrace.clear();
            this.stackElemSelection.clearSelection();
        }

        void setStack(Throwable thrw) {
            StackTraceElement[] stack;
            this.clearStack();
            if (thrw == null) {
                return;
            }
            this.thrw = thrw;
            this.thrwMessager.setText(this.thrw.toString());
            for (StackTraceElement elem : stack = this.thrw.getStackTrace()) {
                this.stacktrace.addElement(elem.toString());
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            int selIndex = this.stackElemSelection.getMinSelectionIndex();
            if (selIndex == -1) {
                return;
            }
            StackTraceElement location = this.thrw.getStackTrace()[selIndex];
            System.out.println("location: " + location);
            JavaPath jPath = new JavaPath(this.sourcePath);
            File toBeLoaded = null;
            try {
                toBeLoaded = jPath.getFile(location.getClassName(), JavaPath.ClsSrc.Source);
                if (toBeLoaded == null) {
                    return;
                }
            }
            catch (IOException ioe) {
                System.out.println("Could not load source for class '" + location.getClassName() + "'. ");
            }
            assert (toBeLoaded != null);
            try {
                String[] cmdLine = this.editor.invocation(toBeLoaded.getPath(), location.getLineNumber());
                Runtime.getRuntime().exec(cmdLine, null, null);
            }
            catch (IOException ioe) {
                System.err.println("Failed to invoke " + this.editor + ". ");
                ioe.printStackTrace();
            }
        }
    }

    static class TestListCellRenderer
    implements ListCellRenderer<TestCase>,
    Serializable {
        private static final long serialVersionUID = -2479143000061671589L;
        private static final String BORDER_DESC = "List.focusCellHighlightBorder";
        protected static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);

        TestListCellRenderer() {
        }

        private String thrwToString(Throwable thrw) {
            return "null".equals(thrw.getMessage()) ? thrw.getClass().toString() : thrw.toString();
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends TestCase> list, TestCase testCase, int index, boolean isSelected, boolean cellHasFocus) {
            Box failureEntry = Box.createHorizontalBox();
            XLabel iconLabel = new XLabel(testCase.getQuality().getIcon());
            XLabel textLabel = new XLabel(testCase.hasFailed() ? this.thrwToString(testCase.getThrown()) : testCase.getQuality().getMessage());
            iconLabel.setDetails(list, isSelected, cellHasFocus);
            iconLabel.setDetails(list, isSelected, cellHasFocus);
            failureEntry.add(iconLabel);
            failureEntry.add(textLabel);
            return failureEntry;
        }

        static class XLabel
        extends JLabel {
            private static final long serialVersionUID = -2479143000061671589L;

            XLabel(Icon icon) {
                super(icon);
            }

            XLabel(String text) {
                super(text);
            }

            void setDetails(JList<?> list, boolean isSelected, boolean cellHasFocus) {
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setEnabled(list.isEnabled());
                this.setFont(list.getFont());
                this.setBorder(cellHasFocus ? UIManager.getBorder(TestListCellRenderer.BORDER_DESC) : NO_FOCUS_BORDER);
                this.setOpaque(true);
            }

            @Override
            public boolean isOpaque() {
                Color back = this.getBackground();
                Container comp = this.getParent();
                if (comp != null) {
                    comp = comp.getParent();
                }
                boolean colorMatch = back != null && comp != null && back.equals(comp.getBackground()) && comp.isOpaque();
                return !colorMatch && super.isOpaque();
            }

            @Override
            public void validate() {
            }

            @Override
            public void invalidate() {
            }

            @Override
            public void repaint() {
            }

            @Override
            public void revalidate() {
            }

            @Override
            public void repaint(long timm, int xCoord, int yCoord, int width, int height) {
            }

            @Override
            public void repaint(Rectangle rect) {
            }

            @Override
            protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, char oldValue, char newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, short oldValue, short newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, int oldValue, int newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, long oldValue, long newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, float oldValue, float newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, double oldValue, double newValue) {
            }

            @Override
            public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
            }
        }
    }

    static class TreePathIterator {
        private final TreeModel treeModel;
        private TreePath currPath;
        private TreePathUpdater treePathUpdater;

        TreePathIterator(JTree tree, int index) {
            this.treeModel = tree.getModel();
            this.currPath = null;
            this.treePathUpdater = TreePathUpdater.First;
            for (int i = 0; i < index; ++i) {
                this.updatePathI();
            }
        }

        void updatePathI() {
            this.treePathUpdater.updatePath(this);
        }

        void setFirstPath() {
            TreeNode lastNode = (TreeNode)this.treeModel.getRoot();
            this.currPath = TreePathIterator.prolonguePath(new TreePath(lastNode));
        }

        static TreePath prolonguePath(TreePath path) {
            TreeNode lastNode = (TreeNode)path.getLastPathComponent();
            while (!lastNode.isLeaf()) {
                lastNode = lastNode.getChildAt(0);
                path = path.pathByAddingChild(lastNode);
            }
            assert (lastNode.isLeaf());
            return path;
        }

        private int shortenPath() {
            TreeNode lastNode = (TreeNode)this.currPath.getLastPathComponent();
            TreePath prefix = this.currPath.getParentPath();
            TreeNode lastButOneNode = (TreeNode)prefix.getLastPathComponent();
            int index = lastButOneNode.getIndex(lastNode);
            while (index == lastButOneNode.getChildCount() - 1) {
                this.currPath = prefix;
                lastNode = lastButOneNode;
                prefix = this.currPath.getParentPath();
                assert (prefix != null) : "tried to ";
                lastButOneNode = (TreeNode)prefix.getLastPathComponent();
                index = lastButOneNode.getIndex(lastNode);
            }
            return index;
        }

        TreePath incPath() {
            int index = this.shortenPath();
            TreePath prefix = this.currPath.getParentPath();
            TreeNode lastButOneNode = (TreeNode)prefix.getLastPathComponent();
            TreeNode lastNode = lastButOneNode.getChildAt(index + 1);
            this.currPath = prefix.pathByAddingChild(lastNode);
            this.currPath = TreePathIterator.prolonguePath(this.currPath);
            return this.currPath;
        }

        TreePath getPath() {
            return this.currPath;
        }

        static enum TreePathUpdater {
            First{

                @Override
                void updatePath(TreePathIterator treePathIter) {
                    treePathIter.treePathUpdater = Generic;
                    treePathIter.setFirstPath();
                }
            }
            ,
            Generic{

                @Override
                void updatePath(TreePathIterator treePathIter) {
                    treePathIter.incPath();
                }
            };


            abstract void updatePath(TreePathIterator var1);
        }
    }

    static interface Selector {
        public void setSelection(int var1);

        public void clearSelection();

        public void registerSelector(Selector var1);
    }

    static class TestTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -2479143000061671589L;

        TestTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            TestCase userObj = (TestCase)node.getUserObject();
            assert (userObj != null);
            if (userObj.getQuality() != null) {
                this.setLeafIcon(userObj.getQuality().getIcon());
            }
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }
    }
}

