/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.testhelpers;

import eu.simuline.testhelpers.ExtRunListener;
import eu.simuline.testhelpers.GUIRunner;
import eu.simuline.testhelpers.Quality;
import eu.simuline.testhelpers.TestCase;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public final class GUIRunListener
extends ExtRunListener {
    private final GUIRunner guiRunner;
    private TestCase testCase;

    public GUIRunListener(GUIRunner guiRunner) {
        this.guiRunner = guiRunner;
    }

    public void testRunStarted(final Description desc) throws Exception {
        assert (!SwingUtilities.isEventDispatchThread());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GUIRunListener.this.guiRunner.testRunStarted(desc);
            }
        };
        SwingUtilities.invokeAndWait(runnable);
        System.out.println("..testRunStarted");
    }

    public void testRunFinished(final Result result) throws Exception {
        assert (!SwingUtilities.isEventDispatchThread());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GUIRunListener.this.guiRunner.testRunFinished(result.getRunTime());
            }
        };
        SwingUtilities.invokeAndWait(runnable);
        System.out.println("..testRunFinished");
    }

    @Override
    public void testSuiteStarted(Description desc) throws Exception {
        assert (!SwingUtilities.isEventDispatchThread());
    }

    @Override
    public void testSuiteFinished(Description desc) throws Exception {
        assert (!SwingUtilities.isEventDispatchThread());
    }

    public void testStarted(Description desc) throws Exception {
        assert (!SwingUtilities.isEventDispatchThread());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GUIRunListener.this.testCase = GUIRunListener.this.guiRunner.noteTestStartedI(Quality.Started);
            }
        };
        SwingUtilities.invokeAndWait(runnable);
        System.out.println("..testStarted");
    }

    public void testFinished(Description desc) throws Exception {
        assert (!SwingUtilities.isEventDispatchThread());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GUIRunListener.this.testCase.setFinished();
                GUIRunListener.this.guiRunner.noteReportResult(GUIRunListener.this.testCase);
            }
        };
        SwingUtilities.invokeAndWait(runnable);
        System.out.println("..testFinished");
    }

    public void testFailure(final Failure failure) throws Exception {
        assert (!SwingUtilities.isEventDispatchThread());
        if (failure.getDescription().equals((Object)Description.TEST_MECHANISM)) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GUIRunListener.this.testCase.setFailure(failure);
                GUIRunListener.this.guiRunner.setStatus("testFailure: " + failure.getException());
            }
        };
        SwingUtilities.invokeAndWait(runnable);
        System.out.println("..testFailure");
    }

    public void testAssumptionFailure(final Failure failure) {
        assert (!SwingUtilities.isEventDispatchThread());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GUIRunListener.this.testCase.setAssumptionFailure(failure);
                GUIRunListener.this.guiRunner.setStatus("testAssumptionFailure: " + failure.getException());
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        System.out.println("..testAssumptionFailure");
    }

    public void testIgnored(Description desc) throws Exception {
        assert (!SwingUtilities.isEventDispatchThread());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GUIRunListener.this.testCase = GUIRunListener.this.guiRunner.noteTestStartedI(Quality.Ignored);
                GUIRunListener.this.guiRunner.noteReportResult(GUIRunListener.this.testCase);
            }
        };
        SwingUtilities.invokeAndWait(runnable);
        System.out.println("...testIgnored");
    }

    @Override
    public void testRunAborted() {
        assert (!SwingUtilities.isEventDispatchThread());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GUIRunListener.this.guiRunner.testRunAborted();
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        System.out.println("..testRunAborted(");
    }

    @Override
    public void testClassStructureLoaded(final Description desc) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GUIRunListener.this.guiRunner.testClassStructureLoaded(desc);
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        System.out.println("..testClassStructureLoaded(");
    }
}

