/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.testhelpers;

import eu.simuline.testhelpers.Quality;
import eu.simuline.util.Benchmarker;
import java.util.ArrayList;
import java.util.List;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

class TestCase {
    private final Description desc;
    private final List<TestCase> children;
    private final int idxTest;
    private Quality qual;
    private Failure failure;
    static final long TIME_SCHEDULED = -1L;
    long time2;

    TestCase(Description desc) {
        this(desc, 0);
    }

    private TestCase(Description desc, int idxTest) {
        this.desc = desc;
        if (desc.isTest()) {
            this.children = null;
            this.idxTest = idxTest;
            this.qual = Quality.Scheduled;
            this.failure = null;
            assert (this.qual.hasFailure() == (this.failure != null));
        } else {
            this.children = new ArrayList<TestCase>();
            for (Description descChild : desc.getChildren()) {
                this.children.add(new TestCase(descChild, idxTest));
                idxTest += descChild.testCount();
            }
            this.idxTest = -1;
            this.qual = null;
            this.failure = null;
        }
    }

    Description getDesc() {
        return this.desc;
    }

    boolean isTest() {
        return this.desc.isTest();
    }

    int testCount() {
        return this.desc.testCount();
    }

    List<TestCase> getChildren() {
        return this.children;
    }

    int getIdx() {
        return this.idxTest;
    }

    Quality getQuality() {
        return this.qual;
    }

    boolean hasFailed() {
        assert (this.isTest());
        assert (this.qual.hasFailure() == (this.getThrown() != null));
        return this.getThrown() != null;
    }

    Throwable getThrown() {
        assert (this.qual.hasFailure() == (this.failure != null));
        return this.failure == null ? null : this.failure.getException();
    }

    boolean fullSuccess() {
        if (this.isTest()) {
            return this.getQuality() == Quality.Success;
        }
        assert (!this.isTest());
        for (TestCase child : this.children) {
            if (child.fullSuccess()) continue;
            return false;
        }
        return true;
    }

    void setScheduledRec() {
        if (this.isTest()) {
            assert (this.qual != null);
            this.qual = this.qual.setScheduled();
            this.failure = null;
            assert (this.qual.hasFailure() == (this.failure != null));
            return;
        }
        assert (this.children != null);
        for (TestCase child : this.children) {
            child.setScheduledRec();
        }
    }

    void setQualStartedIgnored(Quality qual) {
        switch (qual) {
            case Started: {
                this.qual = this.qual.setStarted();
                assert (Benchmarker.isStarted());
                break;
            }
            case Ignored: {
                this.qual = this.qual.setIgnored();
                assert (!Benchmarker.isStarted());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected phase transition to " + qual + ". ");
            }
        }
        assert (this.qual == qual);
        this.failure = null;
        assert (this.qual.hasFailure() == (this.failure != null));
    }

    void setFailure(Failure failure) {
        assert (failure != null);
        this.failure = failure;
        Throwable thrw = failure.getException();
        if (thrw instanceof AssumptionViolatedException) {
            throw new IllegalStateException("Found unexpected AssumptionViolatedException. ");
        }
        this.qual = this.qual.setFailure(thrw);
        assert (!Benchmarker.isStarted());
        this.time2 = Benchmarker.getTimeMs();
        assert (this.qual.hasFailure());
        assert (this.qual.hasFailure() == (this.failure != null));
    }

    void setAssumptionFailure(Failure failure) {
        assert (failure != null);
        if (!(failure.getException() instanceof AssumptionViolatedException)) {
            throw new IllegalStateException("Expected AssumptionViolatedException but found " + failure.getException() + ". ");
        }
        this.failure = failure;
        this.qual = this.qual.setAssumptionFailure();
        assert (Benchmarker.isStarted());
        this.time2 = Benchmarker.getTimeMs();
        assert (this.qual.hasFailure());
        assert (this.qual.hasFailure() == (this.failure != null));
    }

    void setFinished() {
        assert (this.qual.hasFailure() == (this.failure != null));
        this.qual = this.qual.setFinished();
        this.time2 = Benchmarker.getTimeMs();
        assert (this.qual.hasFailure() == (this.failure != null));
    }

    public String toString() {
        assert (this.isTest() == (this.qual != null));
        if (!this.isTest()) {
            return this.desc.toString();
        }
        System.out.println(" time benchmarker: " + this.time2);
        String timeStr = this.qual.lifePhase().timeString(this.time2);
        return this.qual + " " + timeStr + ": " + this.desc.toString();
    }
}

