/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.testhelpers;

import eu.simuline.util.JavaPath;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public final class TestCaseClassLoader
extends ClassLoader {
    private static final String PROP_KEY_TB_TESTED_CLSPATH = "tbTestedClasspath";
    private static final String PROP_KEY_NO_CLS_RELOAD = "noClsReload";
    static final String EXCLUDED_FILE = "noClsReload.properties";
    private static final int LEN_CLS_STREAM = 1000;
    private JavaPath jPath;
    private List<String> excluded;

    public TestCaseClassLoader() {
        String clsPath = System.getProperty(PROP_KEY_TB_TESTED_CLSPATH);
        String tstClsPath = System.getProperty("chooseClasspath");
        if (clsPath == null || tstClsPath == null) {
            throw new IllegalArgumentException("Classpaths for tested code '" + clsPath + " 'and for testing code '" + tstClsPath + "' are not both given. ");
        }
        this.jPath = new JavaPath(String.valueOf(clsPath) + ":" + tstClsPath);
        this.readExcludedPackages();
    }

    @Override
    public URL getResource(String name) {
        return ClassLoader.getSystemResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return ClassLoader.getSystemResourceAsStream(name);
    }

    private boolean isIncluded(String name) {
        int i = 0;
        while (i < this.excluded.size()) {
            if (name.startsWith(this.excluded.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> cls = this.findLoadedClass(name);
            if (cls == null) {
                if (this.isIncluded(name)) {
                    cls = this.findClass(name);
                    if (cls == null) {
                        cls = this.findSystemClass(name);
                    }
                } else {
                    cls = this.findSystemClass(name);
                }
            }
            if (resolve) {
                this.resolveClass(cls);
            }
            return cls;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] clsData = this.loadClassData(name);
        if (clsData == null) {
            return null;
        }
        return this.defineClass(name, clsData, 0, clsData.length);
    }

    /*
     * Exception decompiling
     */
    private byte[] loadClassData(String className) throws ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void readExcludedPackages() {
        Object excludeProp;
        this.excluded = new ArrayList<String>();
        String excludesPathProp = System.getProperty(PROP_KEY_NO_CLS_RELOAD);
        if (excludesPathProp != null) {
            String[] excludesProps;
            String[] stringArray = excludesProps = excludesPathProp.split(":");
            int n = excludesProps.length;
            int n2 = 0;
            while (n2 < n) {
                excludeProp = stringArray[n2];
                this.excluded.add((String)excludeProp);
                ++n2;
            }
        }
        System.out.println("URL of excluded-file: " + this.getClass().getResource(EXCLUDED_FILE));
        try {
            excludeProp = null;
            Object var4_7 = null;
            try (InputStream inStream = this.getClass().getResourceAsStream(EXCLUDED_FILE);){
                if (inStream == null) {
                    return;
                }
                Properties prop = new Properties();
                prop.load(inStream);
                Enumeration<?> e = prop.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (!key.startsWith("excluded.")) continue;
                    String path = prop.getProperty(key);
                    if ((path = path.trim()).endsWith("*")) {
                        path = path.substring(0, path.length() - 1);
                    }
                    if (path.length() <= 0) continue;
                    this.excluded.add(path);
                }
            }
            catch (Throwable throwable) {
                if (excludeProp == null) {
                    excludeProp = throwable;
                } else if (excludeProp != throwable) {
                    ((Throwable)excludeProp).addSuppressed(throwable);
                }
                throw excludeProp;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read excludes from file. ", e);
        }
    }
}

