/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.testhelpers;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import eu.simuline.testhelpers.Accessor;
import eu.simuline.util.NotYetImplementedException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Comparator;
import junit.framework.AssertionFailedError;

public abstract class Assert<E>
extends org.junit.Assert {
    private static final String STR_OBJECT = "Object ";
    private static final String STR_DN_PROV = " does not provide a method \"";
    private static final String STR_RAISED = " raised ";
    private static final String STR_BUTWAS = "> but was: <";
    private static final String STR_ASTOP = ">. ";
    private static final String STR_IN_ABS_VAL = " in absolute value. ";

    private static void thrwAccessible(Method method) {
        throw new IllegalStateException("Method " + method + " is not accessible although it should. ");
    }

    private static void thrwWrongArgs(Method method) {
        throw new IllegalStateException("Method " + method + " is provided with illegal arguments " + "although this should not be possible. ");
    }

    private static double computeNorm2(String norm, Object expected, Object actual) {
        Method mNorm2 = Accessor.getToBeInvoked(expected.getClass(), norm, expected.getClass());
        if (mNorm2 == null) {
            throw new IllegalArgumentException(STR_OBJECT + expected + STR_DN_PROV + "public ... " + norm + "(" + expected.getClass() + ") as expected. ");
        }
        if (!Double.TYPE.equals(mNorm2.getReturnType())) {
            throw new IllegalArgumentException(STR_OBJECT + expected + STR_DN_PROV + "public double " + norm + "(" + expected.getClass() + ") as expected (have a look at the return type). ");
        }
        if (Modifier.isStatic(mNorm2.getModifiers())) {
            throw new IllegalArgumentException(STR_OBJECT + expected + " provides a static method " + "\"public static double " + norm + "(" + expected.getClass() + ") not a member method as expected. ");
        }
        try {
            return (Double)mNorm2.invoke(expected, actual);
        }
        catch (IllegalAccessException iace) {
            Assert.thrwAccessible(mNorm2);
        }
        catch (InvocationTargetException ite) {
            ite.getTargetException().printStackTrace();
            throw new IllegalArgumentException("Could not test deviation, because method " + mNorm2 + STR_RAISED + ite.getTargetException() + ". ");
        }
        throw new IllegalStateException("Reached unreachable statement. ");
    }

    public static void assertNormAbsEquals(String message, Object expected, Object actual, String norm, double delta) {
        Assert.checkNullsB(norm, expected, actual);
        double diff = Assert.computeNorm2(norm, expected, actual);
        if (diff > delta) {
            Assert.fail((String)message);
        }
    }

    public static void assertNormAbsEquals(Object expected, Object actual, String norm, double delta) {
        Assert.assertNormAbsEquals(String.valueOf(Assert.expectedActual(expected, actual)) + ":  deviation " + Assert.computeNorm2(norm, expected, actual) + " exceeds " + delta + STR_IN_ABS_VAL, expected, actual, norm, delta);
    }

    private static double computeNorm1(String norm, Object expected) {
        Method mNorm1 = Accessor.getToBeInvoked(expected.getClass(), norm, new Class[0]);
        if (mNorm1 == null) {
            throw new IllegalArgumentException(STR_OBJECT + expected + STR_DN_PROV + "public ... " + norm + "(" + expected.getClass() + ") as expected. ");
        }
        if (!Double.TYPE.equals(mNorm1.getReturnType())) {
            throw new IllegalArgumentException(STR_OBJECT + expected + STR_DN_PROV + "public double " + norm + "() as expected (have a look at the return type). ");
        }
        if (Modifier.isStatic(mNorm1.getModifiers())) {
            throw new IllegalArgumentException(STR_OBJECT + expected + " provides a static method " + "\"public static double " + norm + "() not a member method as expected. ");
        }
        try {
            return (Double)mNorm1.invoke(expected, new Object[0]);
        }
        catch (IllegalAccessException iace) {
            Assert.thrwAccessible(mNorm1);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalArgumentException("Could not test deviation, because method " + mNorm1 + STR_RAISED + ite.getTargetException() + ". ");
        }
        throw new IllegalStateException("Reached unreachable statement. ");
    }

    public static void assertNormRelEquals(Object expected, Object actual, String norm, double reldev) {
        Assert.assertNormRelEquals(String.valueOf(Assert.expectedActual(expected, actual)) + ":  relative deviation " + Assert.computeNorm2(norm, expected, actual) / Assert.computeNorm1(norm, expected) + " exceeds " + reldev + STR_IN_ABS_VAL, expected, actual, norm, reldev);
    }

    public static void assertNormRelEquals(String message, Object expected, Object actual, String norm, double reldev) {
        Assert.checkNullsB(norm, expected, actual);
        double diff = Assert.computeNorm2(norm, expected, actual);
        double dNorm = Assert.computeNorm1(norm, expected);
        if (diff / dNorm > reldev) {
            Assert.fail((String)message);
        }
    }

    private static String expectedActual(Object expected, Object actual) {
        return "expected: <" + expected + STR_BUTWAS + actual + ">";
    }

    @SuppressWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"}, justification="expected is null and acutal is null are both ok. ")
    private static void checkNullsB(String norm, Object expected, Object actual) {
        if (norm == null) {
            throw new IllegalArgumentException("Norm is " + norm + "; could not prove whether deviation exceeds some threshold. ");
        }
        if (expected == null) {
            throw new IllegalArgumentException(String.valueOf(Assert.expectedActual(expected, actual)) + "; " + "could not prove whether deviation exceeds some threshold. ");
        }
        if (actual == null) {
            Assert.fail((String)(String.valueOf(Assert.expectedActual(expected, actual)) + "; " + "could not prove whether deviation exceeds some threshold. "));
        }
    }

    @SuppressWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"}, justification="expected is null is ok. ")
    public static void assertEquals(Object expected, Object actual) {
        Method equals;
        if (expected == null) {
            throw new IllegalArgumentException("Found expected value " + expected + " -- Use method assertNull instead. ");
        }
        try {
            equals = expected.getClass().getMethod("equals", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(STR_OBJECT + expected + STR_DN_PROV + "public boolean equals(Object)\" - " + "impossible because this is inherited from class Object. ");
        }
        equals.setAccessible(true);
        try {
            Boolean result = (Boolean)equals.invoke(expected, actual);
            if (!Boolean.TRUE.equals(result)) {
                Assert.fail((String)(String.valueOf(Assert.expectedActual(expected, actual)) + ". "));
            }
        }
        catch (IllegalAccessException iace) {
            Assert.thrwAccessible(equals);
        }
        catch (IllegalArgumentException iage) {
            Assert.thrwWrongArgs(equals);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalArgumentException("Could not test equality because method " + equals + STR_RAISED + ite.getTargetException() + ". ");
        }
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        try {
            Assert.assertEquals(expected, actual);
        }
        catch (AssertionFailedError e) {
            Assert.fail((String)message);
        }
    }

    public static <E> void assertIsIn(Collection<E> expectedContainer, Object actualElement) {
        if (actualElement == null || !expectedContainer.contains(actualElement)) {
            Assert.fail((String)("Expected an element of <" + expectedContainer + "> but found <" + actualElement + STR_ASTOP));
        }
    }

    public static <E> void assertIsContainedAll(Collection<E> expected, Collection<E> actual) {
        if (expected == null) {
            Assert.fail((String)"Found expected set value null; use assertNull instead. ");
        }
        if (actual == null) {
            Assert.fail((String)"Tried to perform containment check on null-collection. ");
        }
        Assert.assertTrue((String)("Expected <" + actual + "> to be a subset of <" + expected + STR_ASTOP), (boolean)expected.containsAll(actual));
    }

    public static <E> void assertIs(CmpObj cmpObj, String message, Comparable<E> expected, E actual) {
        if (!cmpObj.invokeCompareTo(expected, actual)) {
            Assert.fail((String)message);
        }
    }

    public static <E> void assertIs(CmpObj cmpObj, String message, E expected, E actual, Comparator<E> cmp) {
        if (!cmpObj.isValid(Assert.invokeCompare(expected, actual, cmp))) {
            Assert.fail((String)message);
        }
    }

    public static <E> void assertIs(CmpObj cmpObj, Comparable<E> expected, E actual) {
        Assert.assertIs(cmpObj, "expected: <" + expected + "> to be" + cmpObj.message + ": <" + actual + STR_ASTOP, expected, actual);
    }

    public static <E> void assertIs(CmpObj cmpObj, E expected, E actual, Comparator<E> cmp) {
        Assert.assertIs(cmpObj, "expected: <" + expected + "> to be" + cmpObj.message + ": <" + actual + "> with respect to the comparator <" + cmp + STR_ASTOP, expected, actual, cmp);
    }

    private static <E> int invokeCompare(E obj1, E obj2, Comparator<E> cmp) {
        Method compare;
        if (cmp == null) {
            throw new IllegalArgumentException("Found null-comparator . ");
        }
        try {
            compare = cmp.getClass().getMethod("compare", Object.class, Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Comparator " + cmp + STR_DN_PROV + "public int compare(Object, Object)\" - impossible. ");
        }
        compare.setAccessible(true);
        try {
            return (Integer)compare.invoke(cmp, obj1, obj2);
        }
        catch (IllegalAccessException iace) {
            Assert.thrwAccessible(compare);
        }
        catch (IllegalArgumentException iage) {
            Assert.thrwWrongArgs(compare);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalArgumentException("Could not test ordering because method " + compare + STR_RAISED + ite.getTargetException() + ". ");
        }
        throw new IllegalStateException();
    }

    private static boolean checkNulls(String message, Object expected, Object actual) {
        if (expected == null ^ actual == null) {
            Assert.fail((String)message);
        }
        return expected == null;
    }

    public static void assertArraysEquals(String message, Object expected, Object actual) {
        try {
            Assert.assertArraysEquals(expected, actual);
        }
        catch (AssertionFailedError e) {
            Assert.fail((String)message);
        }
    }

    public static void assertArraysEquals(Object expected, Object actual) {
        if (Assert.checkNulls(String.valueOf(Assert.expectedActual(expected, actual)) + ". ", expected, actual)) {
            return;
        }
        Assert.checkArraysSameClass(expected, actual);
        Assert.assertRecArraysEquals(expected, actual, new int[0]);
    }

    private static void checkArraysSameClass(Object expected, Object actual) {
        if (!expected.getClass().isArray()) {
            throw new IllegalArgumentException("Array expected; found type " + expected.getClass() + ". ");
        }
        if (!expected.getClass().equals(actual.getClass())) {
            Assert.fail((String)("expected class: <" + expected.getClass() + STR_BUTWAS + actual.getClass() + STR_ASTOP));
        }
    }

    private static void assertRecArraysEquals(Object expected, Object actual, int[] indices) {
        if (Array.getLength(expected) != Array.getLength(actual)) {
            Assert.fail((String)Assert.failLengthMessage(expected, actual, indices));
        }
        int i = 0;
        while (i < Array.getLength(expected)) {
            Object expectedEntry = Array.get(expected, i);
            Object actualEntry = Array.get(actual, i);
            int[] newInd = new int[indices.length + 1];
            System.arraycopy(indices, 0, newInd, 0, indices.length);
            newInd[newInd.length - 1] = i;
            if (Assert.checkNulls(Assert.failMessage(expectedEntry, actualEntry, newInd), expectedEntry, actualEntry)) {
                return;
            }
            if (expectedEntry.getClass().isArray()) {
                Assert.assertRecArraysEquals(expectedEntry, actualEntry, newInd);
            } else {
                Assert.assertEquals(Assert.failMessage(expectedEntry, actualEntry, newInd), expectedEntry, actualEntry);
            }
            ++i;
        }
    }

    private static String failInd(int[] indices) {
        StringBuffer message = new StringBuffer();
        if (indices.length > 0) {
            message.append("In entry [");
            int j = 0;
            while (j < indices.length - 1) {
                message.append(indices[j] + ", ");
                ++j;
            }
            message.append(indices[indices.length - 1] + "] expected ");
        } else {
            message.append("Expected ");
        }
        return message.toString();
    }

    private static String failLengthMessage(Object expectedEntry, Object actualEntry, int[] indices) {
        StringBuffer message = new StringBuffer();
        message.append(Assert.failInd(indices));
        message.append("array with length <");
        message.append(Array.getLength(expectedEntry));
        message.append("> but was array with length <");
        message.append(Array.getLength(actualEntry));
        message.append(STR_ASTOP);
        return message.toString();
    }

    private static String failMessage(Object expectedEntry, Object actualEntry, int[] indices) {
        StringBuffer message = new StringBuffer();
        message.append(Assert.failInd(indices));
        message.append(" <");
        message.append(expectedEntry);
        message.append(STR_BUTWAS);
        message.append(actualEntry);
        message.append(STR_ASTOP);
        return message.toString();
    }

    private static String failMessageDelta(double expectedEntry, double actualEntry, int[] indices, double delta) {
        StringBuffer message = new StringBuffer();
        if (indices.length > 0) {
            message.append("In entry [");
            int j = 0;
            while (j < indices.length - 1) {
                message.append(indices[j]);
                message.append(", ");
                ++j;
            }
            message.append(indices[indices.length - 1]);
            message.append("] expected <");
        } else {
            message.append("Expected <");
        }
        message.append(expectedEntry);
        message.append(STR_BUTWAS);
        message.append(actualEntry);
        message.append(">: deviation exceeds ");
        message.append(delta);
        message.append(STR_IN_ABS_VAL);
        return message.toString();
    }

    private static String failMessageLength(int expectedLen, int actualLen, int[] indices) {
        StringBuffer message = new StringBuffer();
        if (indices.length > 0) {
            message.append("In entry [");
            int j = 0;
            while (j < indices.length - 1) {
                message.append(indices[j]);
                message.append(", ");
                ++j;
            }
            message.append(indices[indices.length - 1]);
            message.append("] expected lengths <");
        } else {
            message.append("Expected lengths <");
        }
        message.append(expectedLen);
        message.append(STR_BUTWAS);
        message.append(actualLen);
        message.append(STR_ASTOP);
        return message.toString();
    }

    public static void assertArraysEquals(Object expected, Object actual, double delta) {
        Assert.checkArraysSameClass(expected, actual);
        Assert.assertRecArraysEquals(expected, actual, new int[0], delta);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void assertRecArraysEquals(Object expected, Object actual, int[] indices, double delta) {
        if (Array.getLength(expected) != Array.getLength(actual)) {
            Assert.fail((String)Assert.failMessageLength(Array.getLength(expected), Array.getLength(actual), indices));
        }
        int i = 0;
        while (i < Array.getLength(expected)) {
            Object expectedEntry = Array.get(expected, i);
            Object actualEntry = Array.get(actual, i);
            int[] newInd = new int[indices.length + 1];
            System.arraycopy(indices, 0, newInd, 0, indices.length);
            newInd[newInd.length - 1] = i;
            Class<?> entryClass = expectedEntry.getClass();
            if (entryClass.isArray()) {
                Assert.assertRecArraysEquals(expectedEntry, actualEntry, newInd, delta);
                return;
            }
            if (!entryClass.isPrimitive()) throw new NotYetImplementedException();
            if (entryClass == Double.TYPE) {
                Assert.assertEquals((String)Assert.failMessageDelta((Double)expectedEntry, (Double)actualEntry, newInd, delta), (double)((Double)expectedEntry), (double)((Double)actualEntry), (double)delta);
            } else {
                if (entryClass != Float.TYPE) throw new IllegalArgumentException("For primitive type " + entryClass + " no method assertEquals(" + entryClass + "," + entryClass + "," + entryClass + ") exists. ");
                Assert.assertEquals((String)Assert.failMessageDelta((Double)expectedEntry, (Double)actualEntry, newInd, delta), (float)((Float)expectedEntry).floatValue(), (float)((Float)actualEntry).floatValue(), (float)((float)delta));
            }
            ++i;
        }
    }

    public static boolean testRelEquals(double expected, double actual, double reldev) {
        if (expected == 0.0 || Double.isInfinite(expected) || Double.isNaN(expected)) {
            throw new IllegalArgumentException("Relative deviation for expected value <" + expected + "> is not defined. ");
        }
        if (Double.isNaN(reldev) || reldev < 0.0) {
            throw new IllegalArgumentException("The relative deviation may not be <" + reldev + STR_ASTOP);
        }
        return Math.abs((expected - actual) / expected) <= reldev;
    }

    public static void assertRelEquals(String message, double expected, double actual, double reldev) {
        if (!Assert.testRelEquals(expected, actual, reldev)) {
            Assert.fail((String)message);
        }
    }

    public static void assertRelEquals(double expected, double actual, double reldev) {
        Assert.assertRelEquals(String.valueOf(Assert.expectedActual(expected, actual)) + "; relative deviation <" + (expected - actual) / expected + "> exceeds <" + reldev + "> in absolute value. ", expected, actual, reldev);
    }

    public static void assertAbsRelEquals(String message, double expected, double separateAbsRel, double actual, double absdev, double reldev) {
        if (separateAbsRel < 0.0) {
            throw new IllegalArgumentException("Found negative separator " + separateAbsRel + ". ");
        }
        if (Math.abs(expected) <= separateAbsRel) {
            Assert.assertEquals((String)message, (double)expected, (double)actual, (double)absdev);
        } else {
            Assert.assertRelEquals(message, expected, actual, reldev);
        }
    }

    public static void assertAbsRelEquals(double expected, double separateAbsRel, double actual, double absdev, double reldev) {
        if (separateAbsRel < 0.0) {
            throw new IllegalArgumentException("Found negative separator " + separateAbsRel + ". ");
        }
        if (Math.abs(expected) <= separateAbsRel) {
            Assert.assertEquals((double)expected, (double)actual, (double)absdev);
        } else {
            Assert.assertRelEquals(expected, actual, reldev);
        }
    }

    public static boolean testAbsEquals(double expected, double actual, double absdev) {
        if (Double.isNaN(expected)) {
            throw new IllegalArgumentException("Absolute deviation for expected value <" + expected + "> is not defined. ");
        }
        if (Double.isNaN(absdev) || absdev < 0.0) {
            throw new IllegalArgumentException("The absolute deviation may not be <" + absdev + STR_ASTOP);
        }
        if (Double.isInfinite(expected)) {
            return expected == actual;
        }
        return Math.abs(expected - actual) <= absdev;
    }

    public static void assertAbsEquals(String message, double expected, double actual, double absdev) {
        if (!Assert.testAbsEquals(expected, actual, absdev)) {
            Assert.fail((String)message);
        }
    }

    public static void assertAbsEquals(double expected, double actual, double absdev) {
        Assert.assertAbsEquals(String.valueOf(Assert.expectedActual(expected, actual)) + "; absolute deviation <" + (expected - actual) + "> exceeds <" + absdev + "> in absolute value. ", expected, actual, absdev);
    }

    public static void assertStringEquals(String expected, String actual) {
        if (expected == null || actual == null) {
            Assert.assertEquals(expected, actual);
        }
        int minLen = Math.min(expected.length(), actual.length());
        int i = 0;
        while (i < minLen) {
            if (expected.charAt(i) != actual.charAt(i)) {
                throw new AssertionFailedError(String.valueOf(Assert.expectedActual(expected, actual)) + ". " + "Common prefix is <" + expected.substring(0, i) + STR_ASTOP);
            }
            ++i;
        }
        if (expected.length() < actual.length()) {
            throw new AssertionFailedError("Expected: <" + expected + "> but was prolongation <" + actual + STR_ASTOP);
        }
        if (expected.length() > actual.length()) {
            throw new AssertionFailedError("Expected: <" + expected + "> but was prefix <" + actual + STR_ASTOP);
        }
    }

    public static double test() {
        return Double.NaN;
    }

    public static enum CmpObj {
        LESS_EQ(" less or equal"){

            @Override
            boolean isValid(int flag3) {
                return flag3 <= 0;
            }
        }
        ,
        LESS(" less"){

            @Override
            boolean isValid(int flag3) {
                return flag3 < 0;
            }
        }
        ,
        GREATER(" greater"){

            @Override
            boolean isValid(int flag3) {
                return flag3 > 0;
            }
        }
        ,
        GREATER_EQ(" greater or equal"){

            @Override
            boolean isValid(int flag3) {
                return flag3 >= 0;
            }
        }
        ,
        EQUAL(" equal"){

            @Override
            boolean isValid(int flag3) {
                return flag3 == 0;
            }
        }
        ,
        NOT_EQUAL(" not equal"){

            @Override
            boolean isValid(int flag3) {
                return flag3 != 0;
            }
        };

        private String message;

        private CmpObj(String message) {
            this.message = message;
        }

        abstract boolean isValid(int var1);

        @SuppressWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"}, justification="expected is null and acutal is null are both ok. ")
        private boolean invokeCompareTo(Comparable<?> expected, Object actual) {
            Method compareTo;
            if (expected == null) {
                throw new IllegalArgumentException("Found expected value " + expected + " -- Use method assertNull instead. ");
            }
            try {
                compareTo = expected.getClass().getMethod("compareTo", Object.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(Assert.STR_OBJECT + expected + Assert.STR_DN_PROV + "public int compareTo(Object)\" - impossible " + "because expected is declared as Comparable. ");
            }
            compareTo.setAccessible(true);
            try {
                Integer result = (Integer)compareTo.invoke(expected, actual);
                if (actual != null) {
                    return this.isValid(result);
                }
                throw new IllegalStateException("Tried to compare <" + expected + "> to: <" + actual + "> which should raise a NullPointerException. ");
            }
            catch (IllegalAccessException iace) {
                Assert.thrwAccessible(compareTo);
            }
            catch (IllegalArgumentException iage) {
                Assert.thrwWrongArgs(compareTo);
            }
            catch (InvocationTargetException ite) {
                throw new IllegalArgumentException("Could not test ordering because method " + compareTo + Assert.STR_RAISED + ite.getTargetException() + ". ");
            }
            throw new IllegalStateException();
        }
    }
}

