/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.testhelpers;

import eu.simuline.util.BasicTypesCompatibilityChecker;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class Accessor<T> {
    private static final String INNER_SEPARATOR = "$";
    private static final String UNSPECIFIED_CLASS = "<unspecified class>";
    private static final String STR_DNE = " does not exist. ";
    private static final String STR_IN_CLS = "' in class '";
    private static final String STR_SPEC_NULL_CLS = "Specified null-class. ";

    private Accessor() {
    }

    private static String paramsToString(Class<?> ... paramCls) {
        StringBuffer ret = new StringBuffer();
        ret.append('(');
        if (paramCls.length != 0) {
            String clsString = paramCls[0] == null ? UNSPECIFIED_CLASS : paramCls[0].getName();
            ret.append(clsString);
            int i = 1;
            while (i < paramCls.length) {
                ret.append(", ");
                clsString = paramCls[i] == null ? UNSPECIFIED_CLASS : paramCls[i].getName();
                ret.append(clsString);
                ++i;
            }
        }
        ret.append(')');
        return ret.toString();
    }

    private static Object invoke(Method method, Object target, Object ... parameters) throws InvocationTargetException {
        if (Modifier.isStatic(method.getModifiers()) != (target == null)) {
            if (Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("For static method " + method.getName() + " no target has to be provided (i.e. null). ");
            }
            throw new IllegalArgumentException("For member method " + method.getName() + " a target has to be provided (not null). ");
        }
        try {
            return method.invoke(target, parameters);
        }
        catch (IllegalAccessException ie) {
            throw new IllegalStateException("Method should be accessible; still is not. ");
        }
    }

    private static Class<?>[] getParamCls(Object ... parameters) {
        Class[] paramCls = new Class[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            paramCls[i] = parameters[i] == null ? null : parameters[i].getClass();
            ++i;
        }
        return paramCls;
    }

    public static Object getField(Object target, String fieldName) throws NoSuchFieldException {
        if (target == null) {
            throw new IllegalArgumentException("Specified null-target. ");
        }
        return Accessor.getField(target.getClass(), target, fieldName);
    }

    public static Object getField(Class<?> aClass, String fieldName) throws NoSuchFieldException {
        return Accessor.getField(aClass, null, fieldName);
    }

    private static Field getFieldObj(Class<?> aClass, String fieldName, boolean shouldBeStatic) throws NoSuchFieldException {
        if (aClass == null) {
            throw new IllegalArgumentException(STR_SPEC_NULL_CLS);
        }
        Class<?> candClass = aClass;
        do {
            Field[] cands;
            Field[] fieldArray = cands = candClass.getDeclaredFields();
            int n = cands.length;
            int n2 = 0;
            while (n2 < n) {
                Field aField = fieldArray[n2];
                if (aField.getName().equals(fieldName)) {
                    aField.setAccessible(true);
                    if (shouldBeStatic != Modifier.isStatic(aField.getModifiers())) {
                        throw new IllegalArgumentException("The specified field '" + fieldName + "' should " + (shouldBeStatic ? "" : "not ") + "be static. ");
                    }
                    return aField;
                }
                ++n2;
            }
        } while ((candClass = candClass.getSuperclass()) != null);
        aClass.getDeclaredField(fieldName);
        throw new IllegalStateException("Should throw a NoSuchFieldException. ");
    }

    public static Object getField(Class<?> aClass, Object target, String fieldName) throws NoSuchFieldException {
        Field aField = Accessor.getFieldObj(aClass, fieldName, target == null);
        try {
            return aField.get(target);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Field '" + fieldName + STR_IN_CLS + (aClass == null ? target.getClass() : aClass).getName() + "is not accessible although it should. ");
        }
    }

    public static void setField(Object target, String fieldName, Object value) throws NoSuchFieldException {
        if (target == null) {
            throw new IllegalArgumentException("Specified null-target. ");
        }
        Accessor.setField(target.getClass(), target, fieldName, value);
    }

    public static void setField(Class<?> aClass, String fieldName, Object value) throws NoSuchFieldException {
        Accessor.setField(aClass, null, fieldName, value);
    }

    public static void setField(Class<?> aClass, Object target, String fieldName, Object value) throws NoSuchFieldException {
        Field aField = Accessor.getFieldObj(aClass, fieldName, target == null);
        if (aField.getType().isPrimitive() && value == null) {
            throw new IllegalArgumentException("Tried to assign null-value to field '" + fieldName + STR_IN_CLS + (aClass == null ? target.getClass() : aClass).getName() + "' although its type '" + aField.getType() + "' is primitive. ");
        }
        try {
            aField.set(target, value);
        }
        catch (IllegalAccessException e) {
            if (aClass == null) {
                aClass = target.getClass();
            }
            String clsName = aClass.getName();
            if (Modifier.isFinal(aField.getModifiers())) {
                throw new IllegalArgumentException("Field '" + fieldName + STR_IN_CLS + clsName + "' is declared final and is hence not accessible. ");
            }
            throw new IllegalStateException("Field '" + fieldName + STR_IN_CLS + clsName + "' is not accessible although it should. ");
        }
    }

    public static Object invokeStatic(Class<?> aClass, String methodName, Object ... parameters) throws InvocationTargetException {
        return Accessor.invoke(aClass, null, methodName, parameters);
    }

    public static Object invoke(Object target, String methodName, Object ... parameters) throws InvocationTargetException {
        return Accessor.invoke(target.getClass(), target, methodName, parameters);
    }

    public static Object invoke(Class<?> aClass, Object target, String methodName, Object ... parameters) throws InvocationTargetException {
        if (aClass == null) {
            throw new IllegalArgumentException(STR_SPEC_NULL_CLS);
        }
        Class<?> candClass = aClass;
        do {
            Method[] cands;
            Method toBeInvoked;
            if ((toBeInvoked = Accessor.getMethod(aClass, methodName, cands = candClass.getDeclaredMethods(), parameters)) == null) continue;
            return Accessor.invoke(toBeInvoked, target, parameters);
        } while ((candClass = candClass.getSuperclass()) != null);
        throw new IllegalArgumentException("Method " + aClass.getName() + "." + methodName + Accessor.paramsToString(Accessor.getParamCls(parameters)) + STR_DNE);
    }

    public static Object invoke(Class<?> aClass, Object target, String methodName, Class<?>[] paramCls, Object[] parameters) throws InvocationTargetException {
        if (aClass == null) {
            throw new IllegalArgumentException(STR_SPEC_NULL_CLS);
        }
        Method toBeInvoked = Accessor.getToBeInvoked(aClass, methodName, paramCls);
        if (toBeInvoked != null) {
            return Accessor.invoke(toBeInvoked, target, parameters);
        }
        throw new IllegalArgumentException("Method " + aClass.getName() + "." + methodName + Accessor.paramsToString(Accessor.getParamCls(parameters)) + STR_DNE);
    }

    static Method getToBeInvoked(Class<?> aClass, String methodName, Class<?> ... paramCls) {
        Class<?> candClass = aClass;
        while (candClass != null) {
            block4: {
                Method toBeInvoked;
                try {
                    toBeInvoked = candClass.getDeclaredMethod(methodName, paramCls);
                }
                catch (NoSuchMethodException e) {
                    break block4;
                }
                if (Modifier.isAbstract(toBeInvoked.getModifiers())) {
                    return null;
                }
                toBeInvoked.setAccessible(true);
                return toBeInvoked;
            }
            candClass = candClass.getSuperclass();
        }
        return null;
    }

    public static <T> T create(Class<T> aClass, Object ... parameters) throws InstantiationException, InvocationTargetException {
        Constructor<T> toBeInvoked = Accessor.getConstructor(aClass, parameters);
        if (toBeInvoked == null) {
            throw new IllegalArgumentException("Constructor " + aClass.getName() + Accessor.paramsToString(Accessor.getParamCls(parameters)) + STR_DNE);
        }
        return Accessor.create(toBeInvoked, parameters);
    }

    public static <T> T create(Class<T> aClass, Class<?>[] paramCls, Object ... parameters) throws NoSuchMethodException, InstantiationException, InvocationTargetException {
        Constructor<T> toBeInvoked = aClass.getDeclaredConstructor(paramCls);
        if (toBeInvoked == null) {
            throw new IllegalArgumentException("Constructor " + aClass.getName() + Accessor.paramsToString(paramCls) + STR_DNE);
        }
        toBeInvoked.setAccessible(true);
        return Accessor.create(toBeInvoked, parameters);
    }

    private static <T> T create(Constructor<T> toBeInvoked, Object ... parameters) throws InstantiationException, InvocationTargetException {
        try {
            return toBeInvoked.newInstance(parameters);
        }
        catch (IllegalAccessException ie) {
            throw new IllegalStateException("Constructor should be accessible; still is not. ");
        }
    }

    private static boolean methodMatches(Method cand, String methodName, Object ... parameters) {
        if (!cand.getName().equals(methodName)) {
            return false;
        }
        if (Modifier.isAbstract(cand.getModifiers())) {
            return false;
        }
        return Accessor.paramsMatch(cand.getParameterTypes(), parameters);
    }

    private static <T> boolean constructorMatches(Constructor<T> cand, Object ... parameters) {
        return Accessor.paramsMatch(cand.getParameterTypes(), parameters);
    }

    private static boolean paramsMatch(Class<?>[] paramTypes, Object ... parameters) {
        if (paramTypes.length != parameters.length) {
            return false;
        }
        int j = 0;
        while (j < parameters.length) {
            if (!BasicTypesCompatibilityChecker.areCompatible(paramTypes[j], (Object)parameters[j])) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private static Method getMethod(Class<?> aClass, String methodName, Method[] cands, Object ... parameters) {
        Method result = null;
        Method[] methodArray = cands;
        int n = cands.length;
        int n2 = 0;
        while (n2 < n) {
            Method aMethod = methodArray[n2];
            if (Accessor.methodMatches(aMethod, methodName, parameters)) {
                if (result != null) {
                    throw new IllegalArgumentException("Method " + aClass.getName() + "." + methodName + Accessor.paramsToString(Accessor.getParamCls(parameters)) + " is not unique: cannot distinguish " + result + " from " + aMethod + ". ");
                }
                result = aMethod;
            }
            ++n2;
        }
        if (result != null) {
            result.setAccessible(true);
        }
        return result;
    }

    private static <T> Constructor<T> getConstructor(Class<T> aClass, Object ... parameters) {
        Constructor<?>[] cands = aClass.getDeclaredConstructors();
        Constructor<T> result = null;
        Constructor<?>[] constructorArray = cands;
        int n = cands.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> aConstr = constructorArray[n2];
            if (Accessor.constructorMatches(aConstr, parameters)) {
                if (result != null) {
                    throw new IllegalArgumentException("Constructor " + aClass.getName() + Accessor.paramsToString(Accessor.getParamCls(parameters)) + " is not unique: cannot distinguish " + result + " from " + aConstr + ". ");
                }
                try {
                    result = aClass.getDeclaredConstructor(aConstr.getParameterTypes());
                    assert (result.equals(aConstr));
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("****");
                }
            }
            ++n2;
        }
        if (result != null) {
            result.setAccessible(true);
        }
        return result;
    }

    public static Class<?> getInnerClass(Class<?> enclosingCls, String[] pathToInner) {
        Class<?> result = enclosingCls;
        String[] stringArray = pathToInner;
        int n = pathToInner.length;
        int n2 = 0;
        while (n2 < n) {
            String clsName = stringArray[n2];
            result = Accessor.getInnerClass(result, clsName);
            ++n2;
        }
        return result;
    }

    public static Class<?> getInnerClass(Class<?> enclosingCls, String innerClsName) {
        if (enclosingCls == null) {
            throw new IllegalArgumentException(STR_SPEC_NULL_CLS);
        }
        if (innerClsName == null) {
            throw new IllegalArgumentException("Specified null-class-name. ");
        }
        Class<?> candCls = enclosingCls;
        do {
            Class<?>[] cands = candCls.getDeclaredClasses();
            String candClsName = String.valueOf(candCls.getName()) + INNER_SEPARATOR;
            Class<?>[] classArray = cands;
            int n = cands.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> aClass = classArray[n2];
                if (aClass.getName().equals(String.valueOf(candClsName) + innerClsName)) {
                    return aClass;
                }
                ++n2;
            }
        } while ((candCls = candCls.getSuperclass()) != null);
        throw new IllegalArgumentException("Class '" + enclosingCls.getName() + "' has no inner class named '" + innerClsName + "'. ");
    }
}

