/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.testhelpers;

import eu.simuline.testhelpers.ExtRunListener;
import java.util.Iterator;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public final class TextRunListener
extends ExtRunListener {
    private static String desc2string(Description desc) {
        StringBuffer buf = new StringBuffer();
        if (desc.isSuite()) {
            buf.append("<Suite name=\"");
            buf.append(desc.getDisplayName());
            buf.append("\">\n");
            Iterator iter = desc.getChildren().iterator();
            assert (iter.hasNext());
            Description child = (Description)iter.next();
            buf.append(TextRunListener.desc2string(child));
            while (iter.hasNext()) {
                child = (Description)iter.next();
                buf.append(", \n");
                buf.append(TextRunListener.desc2string(child));
            }
            buf.append("\n</Suite>");
        } else {
            assert (desc.isTest());
            buf.append(desc.getDisplayName());
        }
        return buf.toString();
    }

    public void testRunStarted(Description desc) throws Exception {
        System.out.println("T testRunStarted(..." + TextRunListener.desc2string(desc));
    }

    public void testRunFinished(Result result) throws Exception {
        System.out.println("T testRunFinished(..." + result);
        System.out.println("Statistics: ");
        System.out.println("runs:         " + result.getRunCount());
        System.out.println("ignored:      " + result.getIgnoreCount());
        System.out.println("failures:     " + result.getFailureCount());
        System.out.println("time elapsed: " + result.getRunTime() + "ms");
    }

    @Override
    public void testSuiteStarted(Description desc) throws Exception {
        System.out.println("S testSuiteStarted(...   " + desc);
    }

    @Override
    public void testSuiteFinished(Description desc) throws Exception {
        System.out.println("S testSuiteFinished(...  " + desc);
    }

    public void testStarted(Description desc) throws Exception {
        System.out.println("T testStarted(...       " + desc);
    }

    public void testFinished(Description desc) throws Exception {
        System.out.println("T testFinished(         " + desc);
    }

    public void testFailure(Failure failure) throws Exception {
        if (failure.getDescription().equals((Object)Description.TEST_MECHANISM)) {
            System.out.println("FRAMEWORK testFailure(          " + failure);
        }
        System.out.println("T testFailure(          " + failure);
    }

    public void testAssumptionFailure(Failure failure) {
        assert (failure.getException() instanceof AssumptionViolatedException);
        System.out.println("T testAssumptionFailure(" + failure);
    }

    public void testIgnored(Description desc) throws Exception {
        System.out.println("T testIgnored(          " + desc);
    }

    @Override
    public void testRunAborted() {
        System.out.println("S testRunAborted(");
    }

    @Override
    public void testClassStructureLoaded(Description desc) {
        System.out.println("S testClassStructureLoaded(" + desc);
    }
}

