/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.testhelpers;

import eu.simuline.util.JavaPath;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public final class TestCaseClassLoader
extends ClassLoader {
    private static final String PROP_TB_TESTED_CLSPATH = "tbTestedClasspath";
    private static final String PROP_KEY_NO_CLS_RELOAD = "noClsReload";
    static final String EXCLUDED_FILE = "noClsReload.properties";
    private static final int LEN_CLS_STREAM = 1000;
    private JavaPath jPath;
    private List<String> excluded;
    private final String[] defaultExclusions = new String[]{"junit.", "org.", "java.", "javax.", "com.", "sun."};

    public TestCaseClassLoader() {
        String classPath = System.getProperty("java.class.path");
        this.jPath = new JavaPath(classPath);
        this.readExcludedPackages();
    }

    @Override
    public URL getResource(String name) {
        return ClassLoader.getSystemResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return ClassLoader.getSystemResourceAsStream(name);
    }

    private boolean isIncluded(String name) {
        for (int i = 0; i < this.excluded.size(); ++i) {
            if (!name.startsWith(this.excluded.get(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> cls = this.findLoadedClass(name);
            if (cls == null) {
                Class<?> clazz = cls = this.isIncluded(name) ? this.findClass(name) : this.findSystemClass(name);
            }
            if (resolve) {
                this.resolveClass(cls);
            }
            return cls;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] clsData = this.loadClassData(name);
        return this.defineClass(name, clsData, 0, clsData.length);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] loadClassData(String className) throws ClassNotFoundException {
        File classFile = this.jPath.getFile(className);
        System.out.println("class file: " + classFile);
        try (InputStream inStream = this.jPath.getInputStream(className);){
            byte[] byArray;
            try (ByteArrayOutputStream outStream = new ByteArrayOutputStream(1000);){
                int numRead;
                if (inStream == null) {
                    throw new ClassNotFoundException("Class file for '" + className + "' not found. ");
                }
                byte[] data = new byte[1000];
                while ((numRead = inStream.read(data)) != -1) {
                    outStream.write(data, 0, numRead);
                }
                byArray = outStream.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Class file for '" + className + "' not readable. ", e);
        }
    }

    private void readExcludedPackages() {
        this.excluded = new ArrayList<String>();
        for (int i = 0; i < this.defaultExclusions.length; ++i) {
            this.excluded.add(this.defaultExclusions[i]);
        }
        String excludesPathProp = System.getProperty(PROP_KEY_NO_CLS_RELOAD);
        if (excludesPathProp != null) {
            String[] excludesProps;
            for (String excludeProp : excludesProps = excludesPathProp.split(":")) {
                this.excluded.add(excludeProp);
            }
        }
        System.out.println("URL of excluded-file: " + this.getClass().getResource(EXCLUDED_FILE));
        try (InputStream inStream = this.getClass().getResourceAsStream(EXCLUDED_FILE);){
            if (inStream == null) {
                return;
            }
            Properties prop = new Properties();
            prop.load(inStream);
            Enumeration<?> e = prop.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith("excluded.")) continue;
                String path = prop.getProperty(key);
                if ((path = path.trim()).endsWith("*")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.length() <= 0) continue;
                this.excluded.add(path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read excludes from file. ", e);
        }
    }
}

