/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.testhelpers;

import eu.simuline.util.JavaPath;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public final class TestCaseClassLoader
extends ClassLoader {
    private static final String PROP_KEY_NO_CLS_RELOAD = "noClsReload";
    static final String EXCLUDED_FILE = "noClsReload.properties";
    private static final int LEN_CLS_STREAM = 1000;
    private JavaPath jPath;
    private List<String> excluded;
    private final String[] defaultExclusions = new String[]{"junit.", "org.", "java.", "javax.", "com.", "sun."};

    public TestCaseClassLoader() {
        String classPath = System.getProperty("java.class.path");
        this.jPath = new JavaPath(classPath);
        this.readExcludedPackages();
    }

    @Override
    public URL getResource(String name) {
        return ClassLoader.getSystemResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return ClassLoader.getSystemResourceAsStream(name);
    }

    private boolean isExcluded(String name) {
        for (int i = 0; i < this.excluded.size(); ++i) {
            if (!name.startsWith(this.excluded.get(i))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        System.out.println("classloader of classloader: " + this.getClass().getClassLoader());
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> cls = this.findLoadedClass(name);
            if (cls == null) {
                System.out.println("loading class: " + name);
                if (this.isExcluded(name)) {
                    System.out.println("is excluded");
                    try {
                        cls = this.findSystemClass(name);
                        return cls;
                    }
                    catch (ClassNotFoundException e) {
                        System.out.println("keep searching **** although excluded. ");
                    }
                }
                cls = this.findClass(name);
            }
            if (resolve) {
                this.resolveClass(cls);
            }
            return cls;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] clsData = this.loadClassData(name);
        return this.defineClass(name, clsData, 0, clsData.length);
    }

    private byte[] loadClassData(String className) throws ClassNotFoundException {
        try {
            int numRead;
            File classFile = this.jPath.getFile(className);
            System.out.println("class file: " + classFile);
            InputStream inStream = this.jPath.getInputStream(className);
            if (inStream == null) {
                throw new ClassNotFoundException();
            }
            ByteArrayOutputStream outStream = new ByteArrayOutputStream(1000);
            byte[] data = new byte[1000];
            while ((numRead = inStream.read(data)) != -1) {
                outStream.write(data, 0, numRead);
            }
            inStream.close();
            outStream.close();
            return outStream.toByteArray();
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Class '" + className + "' not found. ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readExcludedPackages() {
        Properties prop;
        block16: {
            this.excluded = new ArrayList<String>();
            for (int i = 0; i < this.defaultExclusions.length; ++i) {
                this.excluded.add(this.defaultExclusions[i]);
            }
            String excludesPathProp = System.getProperty(PROP_KEY_NO_CLS_RELOAD);
            if (excludesPathProp != null) {
                String[] excludesProp = excludesPathProp.split(":");
                for (int i = 0; i < excludesProp.length; ++i) {
                    this.excluded.add(excludesProp[i]);
                }
            }
            InputStream inStream = this.getClass().getResourceAsStream(EXCLUDED_FILE);
            System.out.println("URL of excluded-file: " + this.getClass().getResource(EXCLUDED_FILE));
            if (inStream == null) {
                return;
            }
            prop = new Properties();
            prop.load(inStream);
            try {
                inStream.close();
            }
            catch (IOException i) {}
            break block16;
            catch (IOException e) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
                catch (Throwable throwable) {
                    try {
                        inStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("excluded.")) continue;
            String path = prop.getProperty(key);
            if ((path = path.trim()).endsWith("*")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.length() <= 0) continue;
            this.excluded.add(path);
        }
    }
}

