/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.testhelpers;

import eu.simuline.util.JavaPath;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public final class TestCaseClassLoaderB
extends ClassLoader {
    static final String EXCLUDED_FILE = "noClsReload.properties";
    private static final int LEN_CLS_STREAM = 1000;
    private JavaPath jPath;

    public TestCaseClassLoaderB() {
        this(System.getProperty("java.class.path"));
    }

    private TestCaseClassLoaderB(String classPath) {
        this.jPath = new JavaPath(classPath);
    }

    @Override
    public URL getResource(String name) {
        return ClassLoader.getSystemResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return ClassLoader.getSystemResourceAsStream(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] data = this.lookupClassData(name);
        return this.defineClass(name, data, 0, data.length);
    }

    private byte[] lookupClassData(String className) throws ClassNotFoundException {
        try {
            int numRead;
            InputStream streamIn = this.jPath.getInputStream(className);
            if (streamIn == null) {
                throw new ClassNotFoundException();
            }
            ByteArrayOutputStream streamOut = new ByteArrayOutputStream(1000);
            byte[] data = new byte[1000];
            while ((numRead = streamIn.read(data)) != -1) {
                assert (numRead <= 1000);
                streamOut.write(data, 0, numRead);
            }
            streamIn.close();
            streamOut.close();
            return streamOut.toByteArray();
        }
        catch (IOException e) {
            throw new ClassNotFoundException("IO Exception reading class file for class'" + className + "'. ");
        }
    }
}

