/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.testhelpers;

import eu.simuline.junit.AssumptionFailure;
import eu.simuline.junit.Error;
import eu.simuline.junit.Failure;
import eu.simuline.junit.Ignored;
import eu.simuline.junit.New;
import eu.simuline.junit.Ok;
import eu.simuline.sun.gtk.File;
import eu.simuline.util.images.GifResource;
import java.awt.Color;
import javax.swing.ImageIcon;
import junit.framework.AssertionFailedError;

enum Quality {
    Scheduled(0){

        @Override
        ImageIcon getIcon() {
            return GifResource.getIcon(File.class);
        }

        @Override
        Quality setStarted() {
            return Started;
        }

        @Override
        Quality setFinished() {
            throw new IllegalStateException("Found testcase finished before started. ");
        }

        @Override
        Quality setIgnored() {
            return Ignored;
        }

        @Override
        String getMessage() {
            return "Scheduled";
        }

        @Override
        long setTime(long time) {
            return -1L;
        }
    }
    ,
    Started(0){

        @Override
        ImageIcon getIcon() {
            return GifResource.getIcon(New.class);
        }

        @Override
        Quality setFinished() {
            return Success;
        }

        @Override
        Quality setIgnored() {
            throw new IllegalStateException("Found testcase to be ignored while running. ");
        }

        @Override
        Quality setScheduled() {
            throw new IllegalStateException("Found testcase scheduled before started. ");
        }

        @Override
        Quality setStarted() {
            throw new IllegalStateException("Found testcase started while running. ");
        }

        @Override
        String getMessage() {
            return "started";
        }

        @Override
        long setTime(long time) {
            return System.currentTimeMillis();
        }

        @Override
        Quality setAssumptionFailure() {
            return Invalidated;
        }

        @Override
        Quality setFailure(Throwable thrw) {
            return thrw instanceof AssertionFailedError || thrw instanceof AssertionError ? Failure : Error;
        }
    }
    ,
    Success(0){

        @Override
        ImageIcon getIcon() {
            return GifResource.getIcon(Ok.class);
        }

        @Override
        Quality setFinished() {
            throw new IllegalStateException("Found testcase successful before finished. ");
        }

        @Override
        String getMessage() {
            return "succeeded";
        }
    }
    ,
    Invalidated(1){

        @Override
        ImageIcon getIcon() {
            return GifResource.getIcon(AssumptionFailure.class);
        }

        @Override
        String getMessage() {
            return "invalidated by failed assumption";
        }
    }
    ,
    Ignored(1){

        @Override
        ImageIcon getIcon() {
            return GifResource.getIcon(Ignored.class);
        }

        @Override
        long setTime(long time) {
            return 0L;
        }

        @Override
        Quality setFinished() {
            throw new IllegalStateException("Found testcase finished and ignored. ");
        }

        @Override
        String getMessage() {
            return "was ignored";
        }
    }
    ,
    Failure(2){

        @Override
        ImageIcon getIcon() {
            return GifResource.getIcon(Failure.class);
        }

        @Override
        String getMessage() {
            return "failed";
        }
    }
    ,
    Error(2){

        @Override
        ImageIcon getIcon() {
            return GifResource.getIcon(Error.class);
        }

        @Override
        String getMessage() {
            return "had an error";
        }
    };

    private int level;
    private static final Color COLOR_FAIL;
    private static final Color COLOR_OK;
    private static final Color COLOR_IGNORED;

    private Quality(int level) {
        this.level = level;
    }

    Quality setScheduled() {
        return Scheduled;
    }

    Quality setStarted() {
        throw new IllegalStateException("Found testcase started but not scheduled. ");
    }

    Quality setIgnored() {
        throw new IllegalStateException("Found testcase ignored but not scheduled. ");
    }

    Quality setFinished() {
        return this;
    }

    Quality setAssumptionFailure() {
        throw new IllegalStateException("Found testcase with assumtion failure which is not started. ");
    }

    Quality setFailure(Throwable thrw) {
        throw new IllegalStateException("Found testcase with failure which is not started. ");
    }

    abstract ImageIcon getIcon();

    abstract String getMessage();

    Quality max(Quality other) {
        return this.level > other.level ? this : other;
    }

    Color getColor() {
        switch (this.level) {
            case 0: {
                return COLOR_OK;
            }
            case 1: {
                return COLOR_IGNORED;
            }
            case 2: {
                return COLOR_FAIL;
            }
        }
        throw new IllegalStateException("Found undefined level " + this.level + ". ");
    }

    long setTime(long time) {
        return System.currentTimeMillis() - time;
    }

    boolean isNeutral() {
        return this.level == 0;
    }

    boolean hasFailure() {
        switch (this.level) {
            case 0: {
                return false;
            }
            case 1: {
                return this == Invalidated;
            }
            case 2: {
                return true;
            }
        }
        throw new IllegalStateException("Found undefined level " + this.level + ". ");
    }

    static {
        COLOR_FAIL = Color.red;
        COLOR_OK = Color.green;
        COLOR_IGNORED = Color.yellow;
    }
}

