package eu.simuline.testhelpers;

public enum Editor {
  emacsclient {
    String[] invocation(int lineNumber, String path) {
      return new String[] {
        "emacsclient", 
        "--no-wait", 
        "+" + lineNumber, 
        path
          };
    }
  }, 
  code {
    String[] invocation(int lineNumber, String path) {
      return new String[] {
        "code",
        "-g", 
        path + ":" + lineNumber
      };
    }
  };

  abstract String[] invocation(int lineNumber, String path);
}
