/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.testhelpers;

import java.util.ArrayList;
import java.util.List;

public abstract class DTestHelper {
    static double random(boolean signed) {
        return signed ? 2.0 * (Math.random() - 0.5) : Math.random();
    }

    public static double createArgD(boolean isSigned) {
        double cand = Math.random();
        cand *= Math.pow(2.0, 100.0 * Math.random() - 50.0);
        return cand *= isSigned ? Math.signum(Math.random() - 0.5) : 1.0;
    }

    public static double createArgD(boolean isSigned, int exp0, int exp1) {
        double cand = Math.random();
        cand *= Math.pow(2.0, (double)(exp1 - exp0) * Math.random() + (double)exp0);
        return cand *= isSigned ? Math.signum(Math.random() - 0.5) : 1.0;
    }

    public static List<Double> createMultArgsSumD(int numArgs, boolean signed, boolean inRange) {
        ArrayList<Double> resultD = new ArrayList<Double>(numArgs);
        if (numArgs == 0) {
            return resultD;
        }
        double sum = 0.0;
        double max = 0.0;
        for (int i = 0; i < numArgs; ++i) {
            double cand = DTestHelper.random(signed);
            max = Math.max(max, Math.abs(cand));
            resultD.add(cand);
            sum += cand;
        }
        if (inRange) {
            int sgn = (int)Math.signum(sum);
            max = Math.max(max, Math.abs(sum));
            double shift = Math.pow(2.0, Math.ceil(Math.log(max) / Math.log(2.0)));
            assert (-1.0 < sum / shift && sum / shift < 1.0);
            assert (-1.0 < max / shift && max / shift < 1.0);
            for (int i = 0; i < numArgs; ++i) {
                resultD.set(i, (Double)resultD.get(i) / shift * (double)sgn);
            }
        }
        return resultD;
    }

    public static List<Double> createMultArgsSumD(boolean signed, boolean inRange) {
        int numArgs = 1 + (int)Math.round(10.0 * Math.random());
        return DTestHelper.createMultArgsSumD(numArgs, signed, inRange);
    }

    public static List<Double> createMultArgsD(int numArgs, boolean allowsSigned, boolean inRange, boolean allowsNaN) {
        ArrayList<Double> resultD = new ArrayList<Double>(numArgs);
        for (int i = 0; i < numArgs; ++i) {
            double num;
            if (allowsNaN && Math.random() > 0.95) {
                num = Double.NaN;
            } else {
                num = Math.random();
                num *= inRange ? 1.0 : Math.pow(2.0, 100.0 * Math.random() - 50.0);
                num *= allowsSigned ? Math.signum(Math.random() - 0.5) : 1.0;
            }
            resultD.add(num);
        }
        return resultD;
    }

    public static List<Double> createMultArgsD(boolean signed, boolean inRange, boolean allowsNaN) {
        int numArgs = 1 + (int)Math.round(10.0 * Math.random());
        return DTestHelper.createMultArgsD(numArgs, signed, inRange, allowsNaN);
    }
}

