/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class PathFinder {
    public static final String EXEC_ARG = "{}";
    public static final Filter TRUE = new Filter(){

        @Override
        public boolean pass(Path path) {
            return true;
        }
    };
    public static final Filter FALSE = new Filter(){

        @Override
        public boolean pass(Path path) {
            return false;
        }
    };
    public static final Filter CAN_EXEC = new Filter(){

        @Override
        public boolean pass(Path path) {
            return Files.isExecutable(path);
        }
    };
    public static final Filter CAN_READ = new Filter(){

        @Override
        public boolean pass(Path path) {
            return Files.isReadable(path);
        }
    };
    public static final Filter CAN_WRITE = new Filter(){

        @Override
        public boolean pass(Path path) {
            return Files.isWritable(path);
        }
    };
    public static final Filter IS_PATH = new Filter(){

        @Override
        public boolean pass(Path path) {
            return Files.isRegularFile(path, new LinkOption[0]);
        }
    };
    public static final Filter IS_DIR = new Filter(){

        @Override
        public boolean pass(Path path) {
            return Files.isDirectory(path, new LinkOption[0]);
        }
    };

    private PathFinder() {
    }

    public static PathFinder path(Path path) {
        return new Primary(path);
    }

    public PathFinder print(PrintStream str) {
        return new PrintFilter(this, str);
    }

    public PathFinder add(Filter filter) {
        return new Secondary(this, filter);
    }

    public PathFinder name(String pattern) {
        return this.add(PathFinder.nameFilter(pattern));
    }

    public PathFinder exec(String[] cmd) {
        return this.add(PathFinder.execFilter(cmd));
    }

    public PathFinder execJava(Callable callable) {
        return this.add(PathFinder.execJavaFilter(callable));
    }

    public PathFinder not(Filter filter) {
        return this.add(filter.not());
    }

    public PathFinder and(Filter[] filters) {
        return this.add(Filter.and(filters));
    }

    public PathFinder or(Filter[] filters) {
        return this.add(Filter.or(filters));
    }

    public static Filter nameFilter(String pattern) {
        return new NameFilter(pattern);
    }

    public static Filter execFilter(String[] cmd) {
        return new ExecFilter(cmd);
    }

    public static Filter execJavaFilter(Callable callable) {
        return new ExecJavaFilter(callable);
    }

    public abstract boolean hasNext();

    public abstract Path next();

    public static void main(String[] args) {
        Path path = Paths.get(args[0], new String[0]);
        PathFinder finder = PathFinder.path(path).name(".*\\.m").not(PathFinder.execFilter(new String[]{"grep", "'", EXEC_ARG})).print(System.out);
        while (finder.hasNext()) {
            finder.next();
        }
    }

    static class OrFilter
    extends Filter {
        private final Filter[] filters;

        OrFilter(Filter[] filters) {
            this.filters = filters;
        }

        @Override
        public boolean pass(Path path) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (!this.filters[i].pass(path)) continue;
                return true;
            }
            return false;
        }
    }

    static class AndFilter
    extends Filter {
        private final Filter[] filters;

        AndFilter(Filter[] filters) {
            this.filters = filters;
        }

        @Override
        public boolean pass(Path path) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i].pass(path)) continue;
                return false;
            }
            return true;
        }
    }

    static class NegFilter
    extends Filter {
        private final Filter tbNegFilter;

        NegFilter(Filter tbNegFilter) {
            this.tbNegFilter = tbNegFilter;
        }

        @Override
        public boolean pass(Path path) {
            return !this.tbNegFilter.pass(path);
        }
    }

    static class ExecJavaFilter
    extends Filter {
        private final Callable callable;

        ExecJavaFilter(Callable callable) {
            this.callable = callable;
        }

        @Override
        public boolean pass(Path path) {
            return this.callable.call(path);
        }
    }

    public static interface Callable {
        public boolean call(Path var1);
    }

    static class ExecFilter
    extends Filter {
        private final String[] cmd;

        ExecFilter(String[] cmd) {
            this.cmd = cmd;
        }

        @Override
        public boolean pass(Path path) {
            int exitVal;
            Process proc;
            String nextStr = path.toString();
            String[] cmd = new String[this.cmd.length];
            System.arraycopy(this.cmd, 0, cmd, 0, this.cmd.length);
            for (int idx = 0; idx < this.cmd.length; ++idx) {
                if (cmd[idx] != PathFinder.EXEC_ARG) continue;
                cmd[idx] = nextStr;
            }
            try {
                proc = Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e) {
                System.out.println("exec: " + e.getMessage());
                return false;
            }
            try {
                exitVal = proc.waitFor();
            }
            catch (InterruptedException e) {
                System.out.println("exec:" + e.getMessage());
                return false;
            }
            return exitVal == 0;
        }
    }

    static class NameFilter
    extends Filter {
        private final Pattern pattern;

        NameFilter(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }

        @Override
        public boolean pass(Path path) {
            return this.pattern.matcher(path.toString()).matches();
        }
    }

    static abstract class Filter {
        Filter() {
        }

        abstract boolean pass(Path var1);

        Filter not() {
            return new NegFilter(this);
        }

        static Filter and(Filter[] filters) {
            return new AndFilter(filters);
        }

        static Filter or(Filter[] filters) {
            return new OrFilter(filters);
        }
    }

    class PrintFilter
    extends Secondary {
        private final PrintStream str;
        private int idx;

        PrintFilter(PathFinder encl, PrintStream str) {
            super(encl, TRUE);
            this.str = str;
            this.idx = 0;
        }

        @Override
        public Path next() {
            assert (super.hasNext());
            Path res = this.getNext();
            assert (res != null);
            ++this.idx;
            this.str.println(this.idx + " " + res.toString());
            this.updateNext();
            return res;
        }
    }

    static class Secondary
    extends PathFinder {
        private Path next;
        private final PathFinder encl;
        private final Filter filter;

        Secondary(PathFinder encl, Filter filter) {
            this.encl = encl;
            this.filter = filter;
            this.updateNext();
        }

        protected void updateNext() {
            while (this.encl.hasNext()) {
                this.next = this.encl.next();
                assert (this.next != null);
                if (!this.filter.pass(this.next)) continue;
                return;
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Path next() {
            assert (this.hasNext());
            Path res = this.next;
            assert (res != null);
            this.updateNext();
            return res;
        }

        protected Path getNext() {
            assert (this.hasNext());
            Path res = this.next;
            assert (res != null);
            return res;
        }
    }

    static class Primary
    extends PathFinder {
        private final Stack<Path> files = new Stack();

        Primary(Path file) {
            this.files.push(file);
        }

        Primary(Path[] path) {
            for (Path file : path) {
                this.files.push(file);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.files.isEmpty();
        }

        @Override
        public Path next() {
            assert (this.hasNext());
            Path path = this.files.pop();
            if (Files.isDirectory(path, new LinkOption[0])) {
                try {
                    Stream<Path> list = Files.list(path);
                    this.files.addAll(list.collect(Collectors.toList()));
                }
                catch (IOException ioe) {
                    throw new RuntimeException("IOE: Could not determine next entry. ");
                }
            }
            return path;
        }
    }
}

