/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Stack;
import java.util.regex.Pattern;

public abstract class Finder {
    public static final String EXEC_ARG = "{}";
    public static final Filter TRUE = new Filter(){

        @Override
        public boolean pass(File file) {
            return true;
        }
    };
    public static final Filter FALSE = new Filter(){

        @Override
        public boolean pass(File file) {
            return false;
        }
    };
    public static final Filter CAN_EXEC = new Filter(){

        @Override
        public boolean pass(File file) {
            return file.canExecute();
        }
    };
    public static final Filter CAN_READ = new Filter(){

        @Override
        public boolean pass(File file) {
            return file.canRead();
        }
    };
    public static final Filter CAN_WRITE = new Filter(){

        @Override
        public boolean pass(File file) {
            return file.canWrite();
        }
    };
    public static final Filter IS_FILE = new Filter(){

        @Override
        public boolean pass(File file) {
            return file.isFile();
        }
    };
    public static final Filter IS_DIR = new Filter(){

        @Override
        public boolean pass(File file) {
            return file.isDirectory();
        }
    };

    private Finder() {
    }

    public static Finder path(File file) {
        return new Primary(file);
    }

    public Finder print(PrintStream str) {
        return new PrintFilter(this, str);
    }

    public Finder add(Filter filter) {
        return new Secondary(this, filter);
    }

    public Finder name(String pattern) {
        return this.add(Finder.nameFilter(pattern));
    }

    public Finder exec(String[] cmd) {
        return this.add(Finder.execFilter(cmd));
    }

    public Finder execJava(Callable callable) {
        return this.add(Finder.execJavaFilter(callable));
    }

    public Finder not(Filter filter) {
        return this.add(filter.not());
    }

    public Finder and(Filter[] filters) {
        return this.add(Filter.and(filters));
    }

    public Finder or(Filter[] filters) {
        return this.add(Filter.or(filters));
    }

    public static Filter nameFilter(String pattern) {
        return new NameFilter(pattern);
    }

    public static Filter execFilter(String[] cmd) {
        return new ExecFilter(cmd);
    }

    public static Filter execJavaFilter(Callable callable) {
        return new ExecJavaFilter(callable);
    }

    public abstract boolean hasNext();

    public abstract File next();

    public static void main(String[] args) {
        File file = new File(args[0]);
        Finder finder = Finder.path(file).name(".*\\.m").not(Finder.execFilter(new String[]{"grep", "'", EXEC_ARG})).print(System.out);
        while (finder.hasNext()) {
            finder.next();
        }
    }

    static class OrFilter
    extends Filter {
        private final Filter[] filters;

        OrFilter(Filter[] filters) {
            this.filters = filters;
        }

        @Override
        public boolean pass(File file) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (!this.filters[i].pass(file)) continue;
                return true;
            }
            return false;
        }
    }

    static class AndFilter
    extends Filter {
        private final Filter[] filters;

        AndFilter(Filter[] filters) {
            this.filters = filters;
        }

        @Override
        public boolean pass(File file) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i].pass(file)) continue;
                return false;
            }
            return true;
        }
    }

    static class NegFilter
    extends Filter {
        private final Filter tbNegFilter;

        NegFilter(Filter tbNegFilter) {
            this.tbNegFilter = tbNegFilter;
        }

        @Override
        public boolean pass(File file) {
            return !this.tbNegFilter.pass(file);
        }
    }

    static class ExecJavaFilter
    extends Filter {
        private final Callable callable;

        ExecJavaFilter(Callable callable) {
            this.callable = callable;
        }

        @Override
        public boolean pass(File file) {
            return this.callable.call(file);
        }
    }

    public static interface Callable {
        public boolean call(File var1);
    }

    static class ExecFilter
    extends Filter {
        private final String[] cmd;

        ExecFilter(String[] cmd) {
            this.cmd = cmd;
        }

        @Override
        public boolean pass(File file) {
            int exitVal;
            Process proc;
            String nextStr = file.toString();
            String[] cmd = new String[this.cmd.length];
            System.arraycopy(this.cmd, 0, cmd, 0, this.cmd.length);
            for (int idx = 0; idx < this.cmd.length; ++idx) {
                if (cmd[idx] != Finder.EXEC_ARG) continue;
                cmd[idx] = nextStr;
            }
            try {
                proc = Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e) {
                System.out.println("exec: " + e.getMessage());
                return false;
            }
            try {
                exitVal = proc.waitFor();
            }
            catch (InterruptedException e) {
                System.out.println("exec:" + e.getMessage());
                return false;
            }
            return exitVal == 0;
        }
    }

    static class NameFilter
    extends Filter {
        private final Pattern pattern;

        NameFilter(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }

        @Override
        public boolean pass(File file) {
            return this.pattern.matcher(file.toString()).matches();
        }
    }

    static abstract class Filter {
        Filter() {
        }

        abstract boolean pass(File var1);

        Filter not() {
            return new NegFilter(this);
        }

        static Filter and(Filter[] filters) {
            return new AndFilter(filters);
        }

        static Filter or(Filter[] filters) {
            return new OrFilter(filters);
        }
    }

    class PrintFilter
    extends Secondary {
        private final PrintStream str;
        private int idx;

        PrintFilter(Finder encl, PrintStream str) {
            super(encl, TRUE);
            this.str = str;
            this.idx = 0;
        }

        @Override
        public File next() {
            assert (super.hasNext());
            File res = this.getNext();
            assert (res != null);
            ++this.idx;
            this.str.println(this.idx + " " + res.toString());
            this.updateNext();
            return res;
        }
    }

    static class Secondary
    extends Finder {
        private File next;
        private final Finder encl;
        private final Filter filter;

        Secondary(Finder encl, Filter filter) {
            this.encl = encl;
            this.filter = filter;
            this.updateNext();
        }

        protected void updateNext() {
            while (this.encl.hasNext()) {
                this.next = this.encl.next();
                assert (this.next != null);
                if (!this.filter.pass(this.next)) continue;
                return;
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public File next() {
            assert (this.hasNext());
            File res = this.next;
            assert (res != null);
            this.updateNext();
            return res;
        }

        protected File getNext() {
            assert (this.hasNext());
            File res = this.next;
            assert (res != null);
            return res;
        }
    }

    static class Primary
    extends Finder {
        private final Stack<File> files = new Stack();

        Primary(File file) {
            this.files.push(file);
        }

        Primary(File[] path) {
            for (File file : path) {
                this.files.push(file);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.files.isEmpty();
        }

        @Override
        public File next() {
            assert (this.hasNext());
            File file = this.files.pop();
            if (file.isDirectory()) {
                File[] list = file.listFiles();
                if (list == null) {
                    System.out.println("cannot read " + file);
                } else {
                    for (int i = list.length - 1; i >= 0; --i) {
                        this.files.push(list[i]);
                    }
                }
            }
            return file;
        }
    }
}

