/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util.images;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.javalobby.icons20x20.Hammer;

public abstract class GifResource {
    private static final String URL_SEP = "/";
    private static final String CLASS_END = "class";
    private static final String GIF_END = "gif";
    private static final String CLASS = "/target/classes/";
    private static final String RESOURCE = "/src/main/resources/";
    private static final Map<Class<?>, ImageIcon> GIFS = new HashMap();

    public static ImageIcon getIcon(Class<? extends GifResource> res) {
        ImageIcon ret = GIFS.get(res);
        if (ret == null) {
            Object path = res.getName().replace('.', '/') + ".class";
            URL url = ClassLoader.getSystemResource((String)path);
            assert (url != null);
            path = url.toString().replaceAll("class\\z", GIF_END);
            path = ((String)path).replace(CLASS, RESOURCE);
            try {
                url = new URL((String)path);
            }
            catch (MalformedURLException e) {
                throw new UnsatisfiedLinkError("Resource not found: " + (String)path);
            }
            GIFS.put(res, new ImageIcon(url));
            ret = GIFS.get(res);
        }
        assert (ret == GIFS.get(res));
        return ret;
    }

    public static final void main(String[] args) {
        ImageIcon icon = GifResource.getIcon(Hammer.class);
        System.out.println("icon: " + icon.getImage());
        System.out.println("icon: " + icon.getIconWidth());
    }
}

