/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class JavaPath {
    private static final char FILE_SEP = System.getProperty("file.separator").charAt(0);
    private static final String PATH_SEP = System.getProperty("path.separator");
    private static final char CLASS_SEP = '.';
    private static final String INNER_CLASS_SEP = "\\$";
    private static final String ZIP_END = ".zip";
    private static final String JAR_END = ".jar";
    private static final int LEN_BUFFER = 1000;
    private final List<File> roots;

    public JavaPath(String path) {
        String[] fileNames = path.split(PATH_SEP);
        if (fileNames.length == 0) {
            throw new IllegalArgumentException("String \"" + path + "\" is not a path. ");
        }
        this.roots = new ArrayList<File>(fileNames.length);
        for (String fileName : fileNames) {
            if (fileName.length() == 0) {
                System.out.println("Warning: Found file \"\" in path \"" + path + "\". ");
            }
            this.roots.add(new File(fileName));
        }
    }

    private String cls2locFile(String clsName, ClsSrc clsSrc) {
        String localFilename = clsName.replace('.', FILE_SEP);
        localFilename = clsSrc.trimInnerClass(localFilename);
        StringBuffer fileNameBuf = new StringBuffer(localFilename);
        fileNameBuf.append(clsSrc.fileEnding());
        return fileNameBuf.toString();
    }

    public File getFile(String clsName, ClsSrc clsSrc) {
        return this.getFile(this.cls2locFile(clsName, clsSrc));
    }

    public File getFile(String localFilename) {
        FileWrapper fileWr = this.locFile2Wrapper(localFilename);
        try {
            return fileWr == null ? null : fileWr.getFile();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public InputStream getInputStream(String clsName) throws IOException {
        FileWrapper fileWrapper = this.locFile2Wrapper(this.cls2locFile(clsName, ClsSrc.Class));
        if (fileWrapper == null) {
            return null;
        }
        return fileWrapper.getInputStream();
    }

    private FileWrapper locFile2Wrapper(String localFilename) {
        File cand = null;
        for (File candParent : this.roots) {
            ZipFile zipFile;
            if (candParent.isDirectory()) {
                cand = new File(candParent, localFilename);
                if (!cand.exists() || !cand.isFile()) continue;
                return new OrdFileWrapper(cand);
            }
            assert (!candParent.isDirectory());
            if (!candParent.getName().endsWith(ZIP_END) && !candParent.getName().endsWith(JAR_END)) continue;
            try {
                zipFile = new ZipFile(candParent);
            }
            catch (IOException e) {
                continue;
            }
            ZipEntry entry = zipFile.getEntry(localFilename);
            if (entry == null) continue;
            return new ZipEntryWrapper(zipFile, entry);
        }
        return null;
    }

    public String getLocFileName(File absFile) {
        String fileName = absFile.getPath();
        for (File cand : this.roots) {
            if (!fileName.startsWith(cand.getPath())) continue;
            fileName = fileName.substring(cand.getPath().length() + 1, fileName.length());
            return fileName;
        }
        return null;
    }

    public String locFile2cls(String locFileName, ClsSrc clsSrc) {
        if (!locFileName.endsWith(clsSrc.fileEnding())) {
            throw new IllegalArgumentException("Expected filename with ending \"" + clsSrc.fileEnding() + "\" but found \"" + locFileName + "\". ");
        }
        locFileName = locFileName.substring(0, locFileName.length() - clsSrc.fileEnding().length());
        locFileName = locFileName.replace(FILE_SEP, '.');
        return locFileName;
    }

    public String absFile2cls(File absFile, ClsSrc clsSrc) {
        String locFileName = this.getLocFileName(absFile);
        System.out.println("locFileName: " + locFileName);
        if (locFileName == null) {
            return null;
        }
        return this.locFile2cls(locFileName, clsSrc);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("<JavaPath>");
        ret.append(this.roots);
        ret.append("</JavaPath>");
        return ret.toString();
    }

    public static void main(String[] args) {
        System.out.println("tt: " + new JavaPath("/home/ernst"));
        System.out.println("tt: " + new JavaPath("/home/ernst:/usr/bin"));
    }

    static class ZipEntryWrapper
    implements FileWrapper {
        private final ZipFile zipFile;
        private final ZipEntry entry;

        ZipEntryWrapper(ZipFile zipFile, ZipEntry entry) {
            this.zipFile = zipFile;
            this.entry = entry;
        }

        @Override
        public boolean coversZip() {
            return true;
        }

        @Override
        public File getFile() throws IOException {
            File ret = File.createTempFile("JUnitGUI" + System.currentTimeMillis(), ClsSrc.Source.fileEnding());
            try (InputStream inStream = this.getInputStream();
                 FileOutputStream outStream = new FileOutputStream(ret);){
                byte[] buf = new byte[1000];
                int numRead = inStream.read(buf, 0, 999);
                while (numRead != -1) {
                    outStream.write(buf, 0, numRead);
                    numRead = inStream.read(buf, 0, 999);
                }
            }
            return ret;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.zipFile.getInputStream(this.entry);
        }

        class WrappedInputStream
        extends FilterInputStream {
            WrappedInputStream(InputStream inputStream) {
                super(inputStream);
            }

            @Override
            public void close() throws IOException {
                super.close();
                ZipEntryWrapper.this.zipFile.close();
            }
        }
    }

    static class OrdFileWrapper
    implements FileWrapper {
        private final File file;

        OrdFileWrapper(File file) {
            this.file = file;
        }

        @Override
        public boolean coversZip() {
            return false;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.file);
        }
    }

    static interface FileWrapper {
        public boolean coversZip();

        public File getFile() throws IOException;

        public InputStream getInputStream() throws IOException;
    }

    public static enum ClsSrc {
        Class{

            @Override
            String fileEnding() {
                return ".class";
            }

            @Override
            String trimInnerClass(String clsName) {
                return clsName;
            }
        }
        ,
        Source{

            @Override
            String fileEnding() {
                return ".java";
            }

            @Override
            String trimInnerClass(String clsName) {
                return clsName.replaceAll("\\$.*", "");
            }
        };


        abstract String fileEnding();

        abstract String trimInnerClass(String var1);
    }
}

