/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

import javax.swing.SwingUtilities;

public abstract class SwingWorker {
    private Object value;
    private final ThreadVar threadVar;

    protected final synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object obj) {
        this.value = obj;
    }

    public abstract Object construct();

    public void finished() {
    }

    public final void interrupt() {
        Thread thr = this.threadVar.get();
        if (thr != null) {
            thr.interrupt();
        }
        this.threadVar.clear();
    }

    public final Object get() {
        Thread thr;
        while ((thr = this.threadVar.get()) != null) {
            try {
                thr.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorker() {
        final Runnable doFinished = new Runnable(){

            @Override
            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){

            @Override
            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                }
                finally {
                    SwingWorker.this.threadVar.clear();
                }
                SwingUtilities.invokeLater(doFinished);
            }
        };
        Thread thr = new Thread(doConstruct);
        this.threadVar = new ThreadVar(thr);
    }

    public final void start() {
        Thread thr = this.threadVar.get();
        if (thr != null) {
            thr.start();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread thr) {
            this.thread = thr;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

