/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util.sgml;

import eu.simuline.util.ListMap;
import eu.simuline.util.sgml.AttributesImpl;
import eu.simuline.util.sgml.ParseExceptionHandler;
import eu.simuline.util.sgml.SGMLFilter;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class SGMLParser {
    private static final String QUOTE_DOT = "\". ";
    private static final char SYMB_EQ = '=';
    private static final char SYMB_COMMENT = '-';
    private static final char SYMB_TAG = '<';
    private static final CharTester TEST_BLANK_GT_SLASH = new CharTester(){

        @Override
        public boolean testChar(char chr) {
            return Character.isWhitespace(chr) || chr == '/' || chr == '>';
        }
    };
    private static final CharTester TEST_BLANK_GT = new CharTester(){

        @Override
        public boolean testChar(char chr) {
            return Character.isWhitespace(chr) || chr == '>';
        }
    };
    private static final CharTester TEST_LT = new CharTester(){

        @Override
        public boolean testChar(char chr) {
            return chr == '<';
        }
    };
    private static final CharTester TEST_GT = new CharTester(){

        @Override
        public boolean testChar(char chr) {
            return chr == '>';
        }
    };
    private static final CharTester TEST_BLANK_EQUALS_GT = new CharTester(){

        @Override
        public boolean testChar(char chr) {
            return Character.isWhitespace(chr) || chr == '=' || chr == '>';
        }
    };
    private static final CharTester TEST_NO_WHITESPACE = new CharTester(){

        @Override
        public boolean testChar(char chr) {
            return !Character.isWhitespace(chr);
        }
    };
    private static final CharTester TEST_END_OF_COMMENT = new CharTester(){
        static final String END_OF_COMMENT = "-->";
        private int index = 0;

        @Override
        public boolean testChar(char chr) {
            if (END_OF_COMMENT.charAt(this.index) == chr) {
                ++this.index;
                if (this.index == END_OF_COMMENT.length() - 1) {
                    this.index = 0;
                    return true;
                }
                return false;
            }
            this.index = 0;
            return false;
        }
    };
    private static final SpecCharTester TEST_SPEC = new SpecCharTester();
    private final XMLsGMLspecifica htmlAttributeParser = new XMLsGMLspecifica(){

        @Override
        public void parseAttribute(AttributesWrapper attributes) throws IOException, SAXException {
            StringBuffer qName = SGMLParser.this.buffer.readStringBuffer(TEST_BLANK_EQUALS_GT, SGMLParser.ATTR_NAME);
            qName.insert(0, (char)SGMLParser.this.currChar);
            String attName = qName.toString().toLowerCase(Locale.ENGLISH);
            SGMLParser.this.currChar = SGMLParser.this.buffer.readChar();
            if (Character.isWhitespace((char)SGMLParser.this.currChar)) {
                qName = SGMLParser.this.buffer.readStringBuffer(TEST_NO_WHITESPACE, SGMLParser.WHITESP_IN_ATTR);
                SGMLParser.this.currChar = SGMLParser.this.buffer.readChar();
            }
            if (SGMLParser.this.currChar != 61) {
                attributes.addAttribute(attName, AttributesImpl.NO_VALUE);
                return;
            }
            qName = SGMLParser.this.buffer.readStringBuffer(TEST_NO_WHITESPACE, SGMLParser.WHITESP_IN_ATTR);
            SGMLParser.this.currChar = SGMLParser.this.buffer.readChar();
            switch (SGMLParser.this.currChar) {
                case 34: 
                case 39: {
                    char quote = (char)SGMLParser.this.currChar;
                    TEST_SPEC.setChar(quote);
                    qName = new StringBuffer();
                    while (true) {
                        qName.append(SGMLParser.this.buffer.readStringBuffer(TEST_SPEC, SGMLParser.ATTR_VALUE));
                        if (qName.length() == 0 || qName.charAt(qName.length() - 1) != '\\') break;
                        qName.setCharAt(qName.length() - 1, quote);
                    }
                    SGMLParser.this.currChar = SGMLParser.this.buffer.readChar();
                    break;
                }
                default: {
                    qName = SGMLParser.this.buffer.readStringBuffer(TEST_BLANK_GT, SGMLParser.ATTR_VALUE);
                    qName.insert(0, (char)SGMLParser.this.currChar);
                }
            }
            SGMLParser.this.currChar = SGMLParser.this.buffer.readChar();
            String attValue = qName.toString();
            attributes.addAttribute(attName, attValue);
        }

        @Override
        public void parseCommentElemTypeDecl() throws IOException, SAXException {
            SGMLParser.this.currChar = SGMLParser.this.buffer.readChar();
            if (SGMLParser.this.currChar != 45) {
                SGMLParser.this.buffer.readArray(TEST_GT);
                SGMLParser.this.buffer.getStartAndMove();
                return;
            }
            SGMLParser.this.currChar = SGMLParser.this.buffer.readChar();
            if (SGMLParser.this.currChar != 45) {
                throw new SAXParseException("Comments must start with \"<!--\" but found \"<!-" + (char)SGMLParser.this.currChar + SGMLParser.QUOTE_DOT, null);
            }
            int numRead = 0;
            do {
                if ((numRead = SGMLParser.this.buffer.readArray(TEST_END_OF_COMMENT)) == -1) {
                    StringBuffer qName = new StringBuffer();
                    qName.append(SGMLParser.this.buffer.getChars(), SGMLParser.this.buffer.getStartAndMove(), numRead);
                    throw new SAXParseException("End of stream while scanning comment. Recently read: \"" + qName + SGMLParser.QUOTE_DOT, null);
                }
                SGMLParser.this.buffer.getStartAndMove();
            } while (SGMLParser.this.buffer.isEmpty());
            SGMLParser.this.buffer.getStartAndMove();
        }

        @Override
        public void parseExtProcessingInstruction() throws IOException, SAXException {
            SGMLParser.this.parseStartOrStartEndTag();
        }
    };
    private final XMLsGMLspecifica xmlAttributeParser = new XMLsGMLspecifica(){

        @Override
        public void parseAttribute(AttributesWrapper attributes) throws IOException, SAXException {
            StringBuffer qName = SGMLParser.this.buffer.readStringBuffer(TEST_BLANK_EQUALS_GT, SGMLParser.ATTR_NAME);
            qName.insert(0, (char)SGMLParser.this.currChar);
            String attName = qName.toString();
            SGMLParser.this.currChar = SGMLParser.this.buffer.readChar();
            if (Character.isWhitespace((char)SGMLParser.this.currChar)) {
                qName = SGMLParser.this.buffer.readStringBuffer(TEST_NO_WHITESPACE, SGMLParser.WHITESP_IN_ATTR);
                SGMLParser.this.currChar = SGMLParser.this.buffer.readChar();
            }
            if (SGMLParser.this.currChar != 61) {
                throw new SAXParseException("Missing value for attribute \"" + attName + SGMLParser.QUOTE_DOT, null);
            }
            qName = SGMLParser.this.buffer.readStringBuffer(TEST_NO_WHITESPACE, SGMLParser.WHITESP_IN_ATTR);
            SGMLParser.this.currChar = SGMLParser.this.buffer.readChar();
            switch (SGMLParser.this.currChar) {
                case 34: 
                case 39: {
                    char quote = (char)SGMLParser.this.currChar;
                    TEST_SPEC.setChar(quote);
                    qName = new StringBuffer();
                    while (true) {
                        qName.append(SGMLParser.this.buffer.readStringBuffer(TEST_SPEC, SGMLParser.ATTR_VALUE));
                        if (qName.length() == 0 || qName.charAt(qName.length() - 1) != '\\') break;
                        qName.setCharAt(qName.length() - 1, quote);
                    }
                    SGMLParser.this.currChar = SGMLParser.this.buffer.readChar();
                    break;
                }
                default: {
                    throw new SAXParseException("Value of attribute \"" + attName + "\" is not quoted. ", null);
                }
            }
            SGMLParser.this.currChar = SGMLParser.this.buffer.readChar();
            String attValue = qName.toString();
            attributes.addAttribute(attName, attValue);
        }

        @Override
        public void parseCommentElemTypeDecl() throws IOException, SAXException {
            SGMLParser.this.buffer.readStringBuffer(TEST_GT, SGMLParser.PROC_INSTR);
            SGMLParser.this.currChar = SGMLParser.this.buffer.readChar();
            SGMLParser.this.contentHandler.processingInstruction(null, null);
        }

        @Override
        public void parseExtProcessingInstruction() throws IOException, SAXException {
            SGMLParser.this.buffer.readStringBuffer(TEST_GT, SGMLParser.PROC_INSTR);
            SGMLParser.this.currChar = SGMLParser.this.buffer.readChar();
            SGMLParser.this.contentHandler.processingInstruction(null, null);
        }
    };
    private static final int BUFFER_SIZE = 999999;
    private static final String START_TAG = "start tag";
    private static final String END_TAG = "end tag";
    private static final String PROC_INSTR = "processing instruction";
    private static final String ATTR_NAME = "attribute name";
    private static final String WHITESP_IN_ATTR = "whitespace in attribute";
    private static final String ATTR_VALUE = "attribute value";
    private XMLsGMLspecifica xmlSgmlSpecifica = this.htmlAttributeParser;
    private int currChar;
    private ContentHandler contentHandler = new TrivialContentHandler();
    private ParseExceptionHandler parseExceptionHandler = new ParseExceptionHandler.Impl();
    private Buffer buffer;

    void parse(InputSource src) throws IOException, SAXException {
        this.parse(src.getCharacterStream());
    }

    public void parse(Reader reader) throws IOException, SAXException {
        this.buffer = new Buffer(reader, 999999);
        int numRead = this.buffer.readArray(TEST_LT);
        this.contentHandler.startDocument();
        while (numRead != -1) {
            this.currChar = this.buffer.readChar();
            if (this.currChar == 60) {
                numRead = this.parseTagOrPI();
                continue;
            }
            numRead = this.parseText();
        }
        this.contentHandler.endDocument();
    }

    private int parseText() throws IOException, SAXException {
        int numRead = this.buffer.readArray(TEST_LT);
        if (numRead != -1) {
            this.contentHandler.characters(this.buffer.getChars(), this.buffer.getStartAndMove(), numRead);
        }
        return numRead;
    }

    void parseEndTag() throws IOException, SAXException {
        StringBuffer qName = this.buffer.readStringBuffer(TEST_GT, END_TAG);
        this.currChar = this.buffer.readChar();
        this.contentHandler.endElement(null, null, qName.toString());
        this.currChar = this.buffer.readChar();
    }

    void parseStartOrStartEndTag() throws IOException, SAXException {
        if (!Character.isLetter((char)this.currChar)) {
            this.parseExceptionHandler.foundIllegalCharInTag((char)this.currChar);
            this.currChar = this.buffer.readChar();
        }
        StringBuffer qName = this.buffer.readStringBuffer(TEST_BLANK_GT_SLASH, START_TAG);
        qName.insert(0, (char)this.currChar);
        this.currChar = this.buffer.readChar();
        while (Character.isWhitespace((char)this.currChar)) {
            this.buffer.readStringBuffer(TEST_NO_WHITESPACE, WHITESP_IN_ATTR);
            this.currChar = this.buffer.readChar();
        }
        AttributesWrapper attributesWrapper = new AttributesWrapper();
        while (this.currChar != 47 && this.currChar != 62) {
            this.xmlSgmlSpecifica.parseAttribute(attributesWrapper);
            while (Character.isWhitespace((char)this.currChar)) {
                this.buffer.readStringBuffer(TEST_NO_WHITESPACE, WHITESP_IN_ATTR);
                this.currChar = this.buffer.readChar();
            }
        }
        Attributes attributes = attributesWrapper.getAttributes();
        switch (this.currChar) {
            case 47: {
                block11: while (true) {
                    this.currChar = this.buffer.readChar();
                    switch (this.currChar) {
                        case 62: {
                            break block11;
                        }
                        case -1: {
                            this.parseExceptionHandler.foundUnexpectedEndOfDocument();
                            continue block11;
                        }
                        default: {
                            this.parseExceptionHandler.foundCharAfterEndOfEndTag((char)this.currChar);
                            continue block11;
                        }
                    }
                    break;
                }
                this.contentHandler.startElement(null, null, qName.toString(), attributes);
                this.contentHandler.endElement(null, null, qName.toString());
                break;
            }
            case 62: {
                this.contentHandler.startElement(null, null, qName.toString(), attributes);
                break;
            }
            default: {
                throw new SAXParseException("Expected finishing tag \"" + qName + "\" with character '/' or '>' but found '" + (char)this.currChar + "'. ", null);
            }
        }
    }

    private int parseTagOrPI() throws IOException, SAXException {
        this.currChar = this.buffer.readChar();
        switch (this.currChar) {
            case 47: {
                this.parseEndTag();
                break;
            }
            case 33: {
                this.xmlSgmlSpecifica.parseCommentElemTypeDecl();
                break;
            }
            case 63: {
                this.xmlSgmlSpecifica.parseExtProcessingInstruction();
                break;
            }
            default: {
                this.parseStartOrStartEndTag();
            }
        }
        return 1;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = this.isXMLParser() ? contentHandler : new SGMLFilter(contentHandler);
    }

    public ContentHandler getContentHandler() {
        if (this.isXMLParser()) {
            return this.contentHandler;
        }
        return ((SGMLFilter)this.contentHandler).getWrapped();
    }

    public void setExceptionHandler(ParseExceptionHandler peHandler) {
        this.parseExceptionHandler = peHandler;
    }

    public ParseExceptionHandler getExceptionHandler() {
        return this.parseExceptionHandler;
    }

    public boolean parseXML(boolean xml) {
        boolean result = this.xmlSgmlSpecifica == this.xmlAttributeParser;
        this.xmlSgmlSpecifica = xml ? this.xmlAttributeParser : this.htmlAttributeParser;
        return result;
    }

    public boolean isXMLParser() {
        return this.xmlSgmlSpecifica == this.xmlAttributeParser;
    }

    static interface XMLsGMLspecifica {
        public void parseAttribute(AttributesWrapper var1) throws IOException, SAXException;

        public void parseCommentElemTypeDecl() throws IOException, SAXException;

        public void parseExtProcessingInstruction() throws IOException, SAXException;
    }

    static class TrivialContentHandler
    implements ContentHandler {
        TrivialContentHandler() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        }

        @Override
        public void characters(char[] chr, int start, int length) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] chr, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }

    static class Buffer {
        private final Reader reader;
        private final char[] bufferArray;
        private int start;
        private int newStart;
        private int end;

        Buffer(Reader reader, int length) throws IOException {
            this.reader = reader;
            this.bufferArray = new char[length];
            this.end = this.start = 0;
        }

        boolean isEmpty() {
            return this.end == this.start;
        }

        boolean reachedEOS() {
            return this.end == -1;
        }

        int readChar() throws IOException {
            if (this.reachedEOS()) {
                return -1;
            }
            if (this.isEmpty()) {
                this.start = 0;
                this.end = this.reader.read(this.bufferArray);
                if (this.reachedEOS()) {
                    return -1;
                }
            }
            return this.bufferArray[this.start++];
        }

        int readArray(CharTester charTester) throws IOException {
            if (this.reachedEOS()) {
                return -1;
            }
            if (this.isEmpty()) {
                this.start = 0;
                this.end = this.reader.read(this.bufferArray);
                if (this.reachedEOS()) {
                    return -1;
                }
            }
            for (int i = this.start; i < this.end; ++i) {
                if (!charTester.testChar(this.bufferArray[i])) continue;
                this.newStart = i;
                return this.newStart - this.start;
            }
            this.newStart = this.end;
            return this.end - this.start;
        }

        StringBuffer readStringBuffer(CharTester charTester, String elementName) throws IOException, SAXParseException {
            StringBuffer qName = new StringBuffer();
            int numRead = 0;
            do {
                if ((numRead = this.readArray(charTester)) == -1) {
                    throw new SAXParseException("End of stream while scanning " + elementName + ". Read so far: \"" + qName + SGMLParser.QUOTE_DOT, null);
                }
                qName.append(this.getChars(), this.getStartAndMove(), numRead);
            } while (this.isEmpty());
            return qName;
        }

        char[] getChars() {
            return this.bufferArray;
        }

        int getStartAndMove() {
            int ret = this.start;
            this.start = this.newStart;
            return ret;
        }

        int getStart() {
            return this.start;
        }

        int getEnd() {
            return this.end;
        }
    }

    static interface CharTester {
        public boolean testChar(char var1);
    }

    class AttributesWrapper {
        private final ListMap<String, String> name2value = new ListMap();

        AttributesWrapper() {
        }

        void addAttribute(String attName, String attValue) {
            String oldAttValue = this.name2value.put(attName, attValue);
            if (oldAttValue != null) {
                SGMLParser.this.parseExceptionHandler.foundMultipleAttribute(attName, oldAttValue);
            }
        }

        Attributes getAttributes() {
            return new AttributesImpl(this.name2value);
        }
    }

    static class SpecCharTester
    implements CharTester {
        private char chr;

        SpecCharTester() {
        }

        void setChar(char chr) {
            this.chr = chr;
        }

        @Override
        public boolean testChar(char chr) {
            return chr == this.chr;
        }
    }
}

