/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

import java.util.Stack;

public final class Benchmarker {
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static final Stack<Snapshot> snapshots = new Stack();

    private Benchmarker() {
    }

    private static long usedMemoryBytes() {
        RUNTIME.gc();
        return RUNTIME.maxMemory() - RUNTIME.freeMemory();
    }

    public static void reset() {
        snapshots.clear();
    }

    public static int mtic() {
        Snapshot snap;
        if (!snapshots.isEmpty()) {
            snap = snapshots.peek();
            if (snap.isStopped()) {
                throw new IllegalStateException("Added tic on stopped tic. ");
            }
            snap.toggleStartStop(true);
            assert (snap.isStopped());
        }
        snap = new Snapshot(true);
        assert (!snap.isStopped());
        snapshots.push(snap);
        return snap.hashCode();
    }

    public static int[] mtic(int numTics) {
        Snapshot snap;
        if (numTics <= 0) {
            throw new IllegalArgumentException("Expected a positive number of tics but found " + numTics + ". ");
        }
        assert (numTics > 0);
        if (!snapshots.isEmpty()) {
            snap = snapshots.peek();
            if (snap.isStopped()) {
                throw new IllegalStateException("Added tic on stopped tic. ");
            }
            snap.toggleStartStop(true);
            assert (snap.isStopped());
        }
        int[] hashCodes = new int[numTics];
        for (int i = 0; i < numTics - 1; ++i) {
            snap = new Snapshot(false);
            assert (snap.isStopped());
            snapshots.push(snap);
            hashCodes[i] = snap.hashCode();
        }
        snap = new Snapshot(true);
        assert (!snap.isStopped());
        snapshots.push(snap);
        hashCodes[numTics - 1] = snap.hashCode();
        return hashCodes;
    }

    public static int mtic2() {
        return Benchmarker.mtic(1)[0];
    }

    public static void pause() {
        if (snapshots.isEmpty()) {
            throw new IllegalStateException("No tic to pause. ");
        }
        assert (!snapshots.isEmpty());
        Snapshot snap = snapshots.peek();
        snap.toggleStartStop(true);
        assert (snap.isStopped());
    }

    public static void resume() {
        if (snapshots.isEmpty()) {
            throw new IllegalStateException("No tic to resume. ");
        }
        assert (!snapshots.isEmpty());
        Snapshot snap = snapshots.peek();
        snap.toggleStartStop(false);
        assert (!snap.isStopped());
    }

    public static Snapshot snap() {
        if (snapshots.isEmpty()) {
            throw new IllegalStateException("No tic to snapshot. ");
        }
        assert (!snapshots.isEmpty());
        Snapshot snap = snapshots.peek();
        snap.toggleStartStop(true);
        Snapshot res = new Snapshot(snap);
        snap.toggleStartStop(false);
        return res;
    }

    public static Snapshot mtoc() {
        if (snapshots.isEmpty()) {
            throw new IllegalStateException("No tic to toc. ");
        }
        assert (!snapshots.isEmpty());
        Snapshot res = snapshots.pop().toggleStartStop(true);
        if (!snapshots.isEmpty()) {
            Snapshot snap = snapshots.peek();
            snap.add(res);
            snap.toggleStartStop(false);
            assert (!snap.isStopped());
        }
        assert (res.isStopped());
        return res;
    }

    public static Snapshot[] mtoc(int numTocs) {
        Snapshot snap;
        Snapshot snapLast;
        if (numTocs <= 0) {
            throw new IllegalArgumentException("Expected a positive number of tics but found " + numTocs + ". ");
        }
        assert (numTocs > 0);
        if (snapshots.size() < numTocs) {
            throw new IllegalStateException(String.format("Only %d tics for %d tocs. ", snapshots.size(), numTocs));
        }
        Snapshot[] res = new Snapshot[numTocs];
        res[numTocs - 1] = snapLast = snapshots.pop().toggleStartStop(true);
        for (int i = numTocs - 2; i >= 0; --i) {
            snap = snapshots.pop();
            snap.add(snapLast);
            res[i] = snap;
            snapLast = snap;
        }
        if (!snapshots.isEmpty()) {
            snap = snapshots.peek();
            snap.add(snapLast);
            snap.toggleStartStop(false);
            assert (!snap.isStopped());
        }
        return res;
    }

    public static Snapshot mtoc2() {
        return Benchmarker.mtoc(1)[0];
    }

    public static int numNestedMeasurements() {
        return snapshots.size();
    }

    public static boolean isStopped() {
        assert (!snapshots.isEmpty());
        return snapshots.peek().isStopped;
    }

    public static class Snapshot {
        private boolean isStopped;
        private long timeNs;
        private long memBytes;

        Snapshot(boolean doStart) {
            this.isStopped = true;
            if (doStart) {
                this.toggleStartStop(false);
            }
        }

        Snapshot(Snapshot other) {
            assert (other.isStopped());
            this.isStopped = other.isStopped;
            this.timeNs = other.timeNs;
            this.memBytes = other.memBytes;
        }

        protected Snapshot toggleStartStop(boolean doStop) {
            if (this.isStopped == doStop) {
                String msg = doStop ? "Tried to pause already stopped. " : "Tried to resume already running. ";
                throw new IllegalStateException(msg);
            }
            assert (this.isStopped != doStop);
            if (doStop) {
                this.timeNs = System.nanoTime() - this.timeNs;
                this.memBytes = Benchmarker.usedMemoryBytes() - this.memBytes;
            } else {
                this.memBytes = Benchmarker.usedMemoryBytes() - this.memBytes;
                this.timeNs = System.nanoTime() - this.timeNs;
            }
            this.isStopped = doStop;
            return this;
        }

        protected void add(Snapshot snap) {
            if (!snap.isStopped() || !this.isStopped()) {
                throw new IllegalStateException("Trying to add two snapshots which are not both stopped. ");
            }
            assert (snap.isStopped());
            assert (this.isStopped());
            this.timeNs += snap.timeNs;
            this.memBytes += snap.memBytes;
        }

        public double getTimeMs() {
            assert (this.isStopped);
            return (double)this.timeNs / 1000000.0;
        }

        public double getMemoryMB() {
            assert (this.isStopped);
            return (double)this.memBytes / 1000000.0;
        }

        public boolean isStopped() {
            return this.isStopped;
        }

        public String toString() {
            String es = this.isStopped ? "Elapsed " : "Snapshot";
            return String.format("%s time: %fms mem %f", es, this.getTimeMs(), this.getMemoryMB());
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final boolean equals(Object obj) {
            return super.equals(obj);
        }
    }
}

