/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util.sgml;

import eu.simuline.util.sgml.AttributesImpl;
import eu.simuline.util.sgml.ParseExceptionHandler;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class SavingHandler
implements ContentHandler,
ParseExceptionHandler {
    public static final String START_OF_DOCUMENT = "start of document";
    public static final String END_OF_DOCUMENT = "end of document";
    private List<String> events = new ArrayList<String>();
    private boolean strict;

    public SavingHandler(boolean strict) {
        this.strict = strict;
    }

    public SavingHandler() {
        this(true);
    }

    public List<String> getEvents() {
        return this.events;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        this.events.add(START_OF_DOCUMENT);
    }

    @Override
    public void endDocument() throws SAXException {
        this.events.add(END_OF_DOCUMENT);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.events.add("TS<" + qName + ">");
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.events.add("TE</" + qName + ">");
    }

    @Override
    public void characters(char[] chr, int start, int length) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] chr, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.strict) {
            this.events.add("PI<!" + target + ", " + data + ">");
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void foundMultipleAttribute(String attrName, Object oldAttrValue) {
        StringBuilder buf = new StringBuilder();
        buf.append("Found second value for attribute \"");
        buf.append(attrName);
        buf.append("\"; overwritten ");
        if (oldAttrValue == AttributesImpl.NO_VALUE) {
            buf.append("no value. ");
        } else {
            buf.append("old value \"");
            buf.append(oldAttrValue);
            buf.append('\"');
        }
        this.events.add(buf.toString());
    }

    @Override
    public void foundIllegalCharInTag(char chr) {
        this.events.add("exc: ill letter in tag: " + chr);
    }

    @Override
    public void foundCharAfterEndOfEndTag(char chr) {
        this.events.add("exc: etter after eo EndTag: " + chr);
    }

    @Override
    public void foundUnexpectedEndOfDocument() {
    }
}

