/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

import eu.simuline.util.Comparators;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;

public final class ListSet<E>
extends AbstractSet<E>
implements SortedSet<E> {
    private final List<E> list;
    private final Comparator<? super E> outerCmp;
    private final Comparator<? super E> innerCmp;

    public static <E> ListSet<E> sortedAsAdded() {
        return ListSet.sortedAsListed(new ArrayList());
    }

    public static <E> ListSet<E> sortedAsListed(List<E> list) {
        return new ListSet<E>(list, Comparators.getAsListed(list));
    }

    private ListSet(List<E> list, Comparator<? super E> cmp) {
        this.list = list;
        this.outerCmp = cmp;
        this.innerCmp = cmp == null ? new Comparator<E>(){

            @Override
            public int compare(E obj1, E obj2) {
                return ((Comparable)obj1).compareTo(obj2);
            }
        } : cmp;
        Collections.sort(this.list, this.innerCmp);
    }

    public ListSet(SortedSet<E> sortedSet) {
        this(sortedSet.comparator());
        for (Object elem : sortedSet) {
            this.list.add(elem);
        }
    }

    public ListSet(Collection<? extends E> coll) {
        this((Comparator)null);
        this.addAll(coll);
    }

    public ListSet(Comparator<? super E> cmp) {
        this(new ArrayList(), cmp);
    }

    public ListSet() {
        this((Comparator)null);
    }

    public List<E> getList() {
        return this.list;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        return this.list.contains(obj);
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arr) {
        return this.list.toArray(arr);
    }

    @Override
    public boolean add(E obj) {
        int index = Collections.binarySearch(this.list, obj, this.innerCmp);
        if (index >= 0) {
            return false;
        }
        index = -index - 1;
        this.list.add(index, obj);
        return true;
    }

    @Override
    public boolean remove(Object obj) {
        return this.list.remove(obj);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        Iterator<?> iter = coll.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    private boolean isSortedWithSameComparator(Collection<?> coll) {
        if (!(coll instanceof SortedSet)) {
            return false;
        }
        SortedSet sSet = (SortedSet)coll;
        return sSet.comparator() == this.comparator() || this.comparator() != null && this.comparator().equals(sSet.comparator());
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        if (this.isSortedWithSameComparator(coll)) {
            ArrayList<? extends E> cList = new ArrayList<E>(coll);
            return this.addList(this.list, cList);
        }
        boolean modified = false;
        for (E entry : coll) {
            modified |= this.add(entry);
        }
        return modified;
    }

    private boolean addList(List<E> list1, List<E> list2) {
        switch (list2.size()) {
            case 0: {
                return false;
            }
            case 1: {
                int index = Collections.binarySearch(list1, list2.get(0), this.innerCmp);
                if (index >= 0) {
                    return false;
                }
                index = -1 - index;
                list1.add(index, list2.get(0));
                return true;
            }
        }
        int index2 = list2.size() / 2;
        int index1 = Collections.binarySearch(list1, list2.get(index2), this.innerCmp);
        if (index1 >= 0) {
            int index1b = index1;
            int index2b = index2;
            while (++index1b < list1.size() && ++index2b < list2.size() && this.innerCmp.compare(list1.get(index1b), list2.get(index2b)) == 0) {
            }
            if (index1b == list1.size()) {
                list1.addAll(list2.subList(index2b, list2.size()));
                return this.addList(list1.subList(0, index1), list2.subList(0, index2));
            }
            boolean isModified = this.addList(list1.subList(index1b, list1.size()), list2.subList(index2b, list2.size()));
            return isModified |= this.addList(list1.subList(0, index1), list2.subList(0, index2));
        }
        if ((index1 = -1 - index1) < list1.size()) {
            int index2b;
            E obj = list1.get(index1);
            Comparator<E> cmp = this.innerCmp;
            for (index2b = index2 + 1; index2b < list2.size() && cmp.compare(obj, list2.get(index2b)) > 0; ++index2b) {
            }
            this.addList(list1.subList(index1, list1.size()), list2.subList(index2b, list2.size()));
            if (index2b > 1 + index2) {
                list1.addAll(index1, list2.subList(index2, index2b));
            } else {
                list1.add(index1, list2.get(index2));
            }
            this.addList(list1.subList(0, index1), list2.subList(0, index2));
            return true;
        }
        list1.addAll(list2.subList(index2, list2.size()));
        this.addList(list1.subList(0, index1), list2.subList(0, index2));
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        return this.list.retainAll(coll);
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return this.list.removeAll(coll);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.outerCmp;
    }

    int obj2idx(E obj) {
        int idx = Collections.binarySearch(this.list, obj, this.innerCmp);
        if (idx < 0) {
            idx = -idx - 1;
        }
        assert (idx >= 0);
        return idx;
    }

    ListSet<E> subSetIdx(int fromIdx, int toIdx) {
        return new ListSet<E>(this.list.subList(fromIdx, toIdx), this.outerCmp);
    }

    @Override
    public ListSet<E> subSet(E fromObj, E toObj) {
        return this.subSetIdx(this.obj2idx(fromObj), this.obj2idx(toObj));
    }

    @Override
    public SortedSet<E> headSet(E toObj) {
        return this.subSetIdx(0, this.obj2idx(toObj));
    }

    @Override
    public SortedSet<E> tailSet(E fromObj) {
        return this.subSetIdx(this.obj2idx(fromObj), this.size());
    }

    @Override
    public E first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.list.get(0);
    }

    @Override
    public E last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.list.get(this.size() - 1);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Set)) {
            return false;
        }
        Set other = (Set)obj;
        if (this.size() != other.size()) {
            return false;
        }
        return this.containsAll(other);
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append('[');
        if (!this.isEmpty()) {
            result.append(this.list.get(0).toString());
            for (int i = 1; i < this.size(); ++i) {
                result.append(", ");
                result.append(this.list.get(i));
            }
        }
        result.append(']');
        return result.toString();
    }

    @Override
    public int hashCode() {
        int code = 0;
        for (E cand : this) {
            code += cand == null ? 0 : cand.hashCode();
        }
        return code;
    }

    public static void main(String[] args) {
        ListSet<Integer> aSet = ListSet.sortedAsListed(Arrays.asList(3, 2, 1));
        System.out.println(": " + aSet.getList());
    }
}

