/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class TwoSidedList<E>
implements List<E> {
    private List<E> list;
    private int firstIndex;

    public TwoSidedList(List<E> list, int firstIndex) {
        this.list = list;
        this.firstIndex = firstIndex;
        this.checkMinFreeIndex(list.size());
    }

    public static <E> TwoSidedList<E> create(List<? extends E> list, int firstIndex) {
        return new TwoSidedList<E>(new ArrayList<E>(list), firstIndex);
    }

    public TwoSidedList(List<E> list) {
        this(list, 0);
    }

    public static <E> TwoSidedList<E> create(List<? extends E> list) {
        return new TwoSidedList<E>(new ArrayList<E>(list));
    }

    public TwoSidedList(TwoSidedList<E> other) {
        this(other.list, other.firstIndex);
    }

    public static <E> TwoSidedList<E> create(TwoSidedList<? extends E> other) {
        return new TwoSidedList<E>(new ArrayList<E>(other.list), other.firstIndex);
    }

    public TwoSidedList(int firstIndex) {
        this(new ArrayList(), firstIndex);
    }

    void checkRange(int ind) {
        this.checkRange("", ind, this.firstIndex, this.minFreeIndex());
    }

    private void checkRange(int ind, Direction dir) {
        dir.checkRange(ind, this);
    }

    private void checkRange(String fromToNothing, int ind, int min, int maxP) {
        if (ind < min || ind >= maxP) {
            throw new IndexOutOfBoundsException(fromToNothing + "Index: " + ind + " Range: " + this.firstIndex + " - " + this.minFreeIndex() + " exclusively. ");
        }
    }

    private void decFirstIndex() {
        if (this.firstIndex == Integer.MIN_VALUE) {
            throw new IllegalStateException("Adding an object at top of this list would cause index underrun. ");
        }
        --this.firstIndex;
    }

    private void incFirstIndex() {
        if (this.firstIndex == Integer.MAX_VALUE) {
            throw new IllegalStateException("Removing an object at top of this list would cause index overrun. ");
        }
        ++this.firstIndex;
    }

    void checkIncMinFreeIndex() {
        if (this.minFreeIndex() == Integer.MAX_VALUE) {
            throw new IllegalStateException("Adding an object at the tail of this list would cause index overrun. ");
        }
    }

    private void subFirstIndex(int numAdded) {
        if (this.firstIndex < this.firstIndex - numAdded) {
            throw new IllegalStateException("Adding " + numAdded + " objects at top of this list would cause index underrun. ");
        }
        this.firstIndex -= numAdded;
    }

    void checkMinFreeIndex(int numAdded) {
        assert (numAdded >= 0);
        if (this.minFreeIndex() > this.minFreeIndex() + numAdded) {
            throw new IllegalStateException("Adding " + numAdded + " objects at the tail of this list would cause index overrun. ");
        }
    }

    public int firstIndex() {
        return this.firstIndex;
    }

    public void firstIndex(int firstIndex) {
        this.firstIndex = firstIndex;
    }

    public int minFreeIndex() {
        return this.list.size() + this.firstIndex;
    }

    public int shiftRight(int num) {
        if (num > 0) {
            if (this.minFreeIndex() > this.minFreeIndex() + num) {
                throw new IllegalStateException("Shifting this list by " + num + " would cause index overrun. ");
            }
        } else {
            assert (num <= 0);
            if (this.firstIndex < this.firstIndex + num) {
                throw new IllegalStateException("Shifting this list by " + num + " would cause index underrun. ");
            }
        }
        this.firstIndex += num;
        return this.firstIndex;
    }

    public List<E> list() {
        return this.list;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        return this.list.contains(obj);
    }

    @Override
    public int indexOf(Object obj) {
        return this.list.indexOf(obj) + this.firstIndex;
    }

    @Override
    public int lastIndexOf(Object obj) {
        return this.list.lastIndexOf(obj) + this.firstIndex;
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <E> E[] toArray(E[] objArr) {
        return this.list.toArray(objArr);
    }

    @Override
    public E get(int ind) {
        this.checkRange(ind);
        return this.list.get(ind - this.firstIndex);
    }

    @Override
    public E set(int ind, E obj) {
        this.checkRange(ind);
        return this.list.set(ind - this.firstIndex, obj);
    }

    @Override
    public boolean add(E obj) {
        throw new UnsupportedOperationException("Use addFirst(Object) or addLast(E) instead. ");
    }

    public boolean addFirst(E obj) {
        this.decFirstIndex();
        this.list.add(0, obj);
        return true;
    }

    public boolean addLast(E obj) {
        this.checkIncMinFreeIndex();
        return this.list.add(obj);
    }

    @Override
    public void add(int ind, E obj) {
        throw new UnsupportedOperationException("Use add(int,E,Direction) instead. ");
    }

    public void add(int ind, E obj, Direction dir) {
        this.checkRange(ind, dir);
        dir.checkAdd1(this);
        this.list.add(ind - this.firstIndex, obj);
    }

    @Override
    public E remove(int ind) {
        throw new UnsupportedOperationException("Use remove(int,Direction) instead. ");
    }

    public E remove(int ind, Direction dir) {
        this.checkRange(ind);
        E res = this.list.remove(ind - this.firstIndex);
        if (dir == Direction.Right2Left) {
            this.incFirstIndex();
        }
        return res;
    }

    @Override
    public boolean remove(Object obj) {
        throw new UnsupportedOperationException("Use removeFirst(E) or removeLast(E) instead. ");
    }

    public boolean removeFirst(Object obj) {
        return this.list.remove(obj);
    }

    public boolean removeLast(Object obj) {
        int ind = this.list.lastIndexOf(obj);
        if (ind == -1) {
            return false;
        }
        this.incFirstIndex();
        this.list.remove(ind);
        return true;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        throw new UnsupportedOperationException("Use addAllFirst or addAllLast instead. ");
    }

    public boolean addAllFirst(Collection<? extends E> coll) {
        this.subFirstIndex(coll.size());
        return this.list.addAll(0, coll);
    }

    public boolean addAllLast(Collection<? extends E> coll) {
        this.checkMinFreeIndex(coll.size());
        return this.list.addAll(coll);
    }

    @Override
    public boolean addAll(int ind, Collection<? extends E> coll) {
        throw new UnsupportedOperationException("Use addAll(int,Collection,Direction) instead. ");
    }

    public boolean addAll(int ind, Collection<? extends E> coll, Direction dir) {
        this.checkRange(ind, dir);
        dir.checkAddAll(coll.size(), this);
        return this.list.addAll(ind - this.firstIndex, coll);
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int ind) {
        this.checkRange("", ind, this.firstIndex, this.minFreeIndex() + 1);
        return this.list.listIterator(ind - this.firstIndex);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.list.containsAll(coll);
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        throw new UnsupportedOperationException("Use removeAll(Collection,Direction) instead. ");
    }

    public boolean removeAll(Collection<?> coll, Direction dir) {
        switch (dir) {
            case Left2Right: {
                return this.list.removeAll(coll);
            }
            case Right2Left: {
                int oldSize = this.list.size();
                boolean ret = this.list.removeAll(coll);
                this.firstIndex += oldSize - this.list.size();
                return ret;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        throw new UnsupportedOperationException("Use retainAll(Collection,Direction) instead. ");
    }

    public boolean retainAll(Collection<?> coll, Direction dir) {
        switch (dir) {
            case Left2Right: {
                return this.list.retainAll(coll);
            }
            case Right2Left: {
                int oldSize = this.list.size();
                boolean ret = this.list.retainAll(coll);
                this.firstIndex += oldSize - this.list.size();
                return ret;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public List<E> subList(int indStart, int indEnd) {
        if (indStart > indEnd) {
            throw new IndexOutOfBoundsException("fromIndex(" + indStart + ") > toIndex(" + indEnd + ")");
        }
        this.checkRange("from", indStart, this.firstIndex, this.minFreeIndex() + 1);
        this.checkRange("to", indEnd, this.firstIndex, this.minFreeIndex() + 1);
        return this.list.subList(indStart - this.firstIndex, indEnd - this.firstIndex);
    }

    public TwoSidedList<E> subList2(int indStart, int indEnd) {
        return new TwoSidedList<E>(this.subList(indStart, indEnd), indStart);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TwoSidedList)) {
            return false;
        }
        TwoSidedList other = (TwoSidedList)obj;
        return this.list.equals(other.list) && this.firstIndex == other.firstIndex;
    }

    @Override
    public int hashCode() {
        return this.list.hashCode() + this.firstIndex;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("<TwoSidedList firstIndex=\"");
        res.append(this.firstIndex);
        res.append("\">");
        res.append(this.list);
        res.append("</TwoSidedList>");
        return res.toString();
    }

    public static void main(String[] args) {
    }

    public static enum Direction {
        Left2Right{

            @Override
            void checkRange(int ind, TwoSidedList<?> list) {
                ((TwoSidedList)list).checkRange("", ind, list.firstIndex(), list.minFreeIndex() + 1);
            }

            @Override
            void checkAdd1(TwoSidedList<?> list) {
                list.checkIncMinFreeIndex();
            }

            @Override
            void checkAddAll(int size, TwoSidedList<?> list) {
                list.checkMinFreeIndex(size);
            }
        }
        ,
        Right2Left{

            @Override
            void checkRange(int ind, TwoSidedList<?> list) {
                ((TwoSidedList)list).checkRange("", ind, list.firstIndex() - 1, list.minFreeIndex());
            }

            @Override
            void checkAdd1(TwoSidedList<?> list) {
                ((TwoSidedList)list).decFirstIndex();
            }

            @Override
            void checkAddAll(int size, TwoSidedList<?> list) {
                ((TwoSidedList)list).subFirstIndex(size);
            }
        };


        abstract void checkRange(int var1, TwoSidedList<?> var2);

        abstract void checkAdd1(TwoSidedList<?> var1);

        abstract void checkAddAll(int var1, TwoSidedList<?> var2);
    }
}

