/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

public enum DataModel {
    Bits64("64"),
    Bits32("32"),
    Unknown("unknown"){

        @Override
        public boolean isKnown() {
            return false;
        }
    };

    private final String code;

    private DataModel(String code) {
        this.code = code;
    }

    public static DataModel getDataModel(boolean retNull) {
        String code = System.getProperty("sun.arch.data.model");
        for (DataModel cand : DataModel.values()) {
            if (!cand.code.equals(code)) continue;
            return cand;
        }
        if (retNull) {
            return null;
        }
        throw new IllegalStateException("Unknown data model: " + code + ". ");
    }

    public String getCode() {
        return this.code;
    }

    public boolean isKnown() {
        return true;
    }
}

