/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import eu.simuline.util.Caster;
import eu.simuline.util.CyclicIterator;
import eu.simuline.util.CyclicList;
import eu.simuline.util.EmptyCyclicListException;
import eu.simuline.util.MultiSet;
import eu.simuline.util.MultiSetIterator;
import eu.simuline.util.NotYetImplementedException;
import eu.simuline.util.SortedMultiSet;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public abstract class CollectionsExt<E> {
    public static <E> ImmutableCollection<E> getImmutableCollection(Collection<E> coll) {
        return new ImmutableCollection<E>(coll);
    }

    public static <E> ImmutableSet<E> getImmutableSet(Set<E> set) {
        return new ImmutableSet<E>(set);
    }

    public static <E> ImmutableSortedSet<E> getImmutableSortedSet(SortedSet<E> set) {
        return new ImmutableSortedSet<E>(set);
    }

    public static <E> ImmutableList<E> getImmutableList(List<E> list) {
        return new ImmutableList<E>(list);
    }

    public static <E> CyclicList<E> getImmutableCyclicList(CyclicList<E> cyc) {
        return new ImmutableCyclicList<E>(cyc);
    }

    public static <E> MultiSet<E> getImmutableMultiSet(MultiSet<E> mSet) {
        return new ImmutableMultiSet<E>(mSet);
    }

    public static <E> MultiSet<E> getImmutableSortedMultiSet(SortedMultiSet<E> mSet) {
        return new ImmutableMultiSet<E>(mSet);
    }

    public static <E> Set<E> weakHashSet() {
        return Collections.newSetFromMap(new WeakHashMap());
    }

    public static Object[] recToArray(List<?> list) {
        Object[] result = new Object[list.size()];
        int index = 0;
        for (Object cand : list) {
            result[index] = cand instanceof List ? CollectionsExt.recToArray((List)cand) : cand;
            ++index;
        }
        return result;
    }

    public static Object recToArray(Object source, Class<?> cls) {
        return CollectionsExt.recToArray(source, cls, Caster.BASIC_TYPES);
    }

    public static Object recToArray(Object source, Class<?> cls, Caster caster) {
        if (caster.areCompatible(cls, source)) {
            return caster.cast(source);
        }
        if (!cls.isArray()) {
            throw new IllegalArgumentException("Found incompatible types: " + source + " is not an instance of " + cls + " but of " + source.getClass() + ". ");
        }
        if (!(source instanceof Collection)) {
            throw new IllegalArgumentException("Found incompatible types: " + source + " is not an instance of List. ");
        }
        Collection coll = (Collection)source;
        Class<?> compType = cls.getComponentType();
        Object result = Array.newInstance(compType, coll.size());
        int ind = 0;
        for (Object cand : coll) {
            Array.set(result, ind++, CollectionsExt.recToArray(cand, compType, caster));
        }
        return result;
    }

    public static <T> T getUnique(Collection<? extends T> coll) {
        if (coll.size() != 1) {
            throw new IllegalStateException("Expected a single element; found collection " + coll + ". ");
        }
        assert (!coll.isEmpty());
        return coll.iterator().next();
    }

    public static <T> List<T> reverse(List<T> list) {
        ArrayList<T> res = new ArrayList<T>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            res.add(list.get(list.size() - 1 - i));
        }
        return res;
    }

    public static void main(String[] args) {
    }

    public static final class ImmutableCollection<E>
    extends AbstractImmutableCollection<Collection<E>, E> {
        private final Collection<E> coll;

        ImmutableCollection(Collection<E> coll) {
            if (coll == null) {
                throw new NullPointerException();
            }
            this.coll = coll;
        }

        @Override
        public Collection<E> unrestricted() {
            return this.coll;
        }
    }

    public static final class ImmutableSet<E>
    extends AbstractImmutableCollection<Set<E>, E>
    implements Set<E> {
        private final Set<E> set;

        ImmutableSet(Set<E> set) {
            if (set == null) {
                throw new NullPointerException();
            }
            this.set = set;
        }

        ImmutableSet(Set<Modification> mods, Set<E> set) {
            super(mods);
            if (set == null) {
                throw new NullPointerException();
            }
            this.set = set;
        }

        @Override
        public Set<E> unrestricted() {
            return this.set;
        }
    }

    public static final class ImmutableSortedSet<E>
    extends AbstractImmutableCollection<SortedSet<E>, E>
    implements SortedSet<E> {
        private final SortedSet<E> set;

        ImmutableSortedSet(SortedSet<E> set) {
            if (set == null) {
                throw new NullPointerException();
            }
            this.set = set;
        }

        ImmutableSortedSet(Set<Modification> mods, SortedSet<E> set) {
            super(mods);
            if (set == null) {
                throw new NullPointerException();
            }
            this.set = set;
        }

        @Override
        public SortedSet<E> unrestricted() {
            return this.set;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.unrestricted().comparator();
        }

        @Override
        public E first() {
            return this.unrestricted().first();
        }

        @Override
        public E last() {
            return this.unrestricted().last();
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            SortedSet<E> res0 = this.unrestricted().headSet(toElement);
            return new ImmutableSortedSet<E>(this.allowedModifications(), res0);
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            SortedSet<E> res0 = this.unrestricted().subSet(fromElement, toElement);
            return new ImmutableSortedSet<E>(this.allowedModifications(), res0);
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            SortedSet<E> res0 = this.unrestricted().tailSet(fromElement);
            return new ImmutableSortedSet<E>(this.allowedModifications(), res0);
        }
    }

    public static final class ImmutableList<E>
    extends AbstractImmutableCollection<List<E>, E>
    implements List<E> {
        private final List<E> list;

        ImmutableList(List<E> list) {
            if (list == null) {
                throw new NullPointerException();
            }
            this.list = list;
        }

        ImmutableList(Set<Modification> mods, List<E> list) {
            super(mods);
            if (list == null) {
                throw new NullPointerException();
            }
            this.list = list;
        }

        @Override
        public List<E> unrestricted() {
            return this.list;
        }

        @Override
        public void add(int index, E obj) {
            if (!this.allowedModifications().contains((Object)Modification.AddObj)) {
                throw new UnsupportedOperationException();
            }
            this.unrestricted().add(index, obj);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> coll) {
            if (this.allowedModifications().contains((Object)Modification.AddObj)) {
                return this.unrestricted().addAll(index, coll);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public E get(int index) {
            return this.unrestricted().get(index);
        }

        @Override
        public int hashCode() {
            return this.unrestricted().hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return this.unrestricted().equals(obj);
        }

        @Override
        public int indexOf(Object obj) {
            return this.unrestricted().indexOf(obj);
        }

        @Override
        public int lastIndexOf(Object obj) {
            return this.unrestricted().lastIndexOf(obj);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new ListIterator<E>(){
                private ListIterator<E> wrapped;
                {
                    this.wrapped = this.unrestricted().listIterator();
                }

                @Override
                public boolean hasNext() {
                    return this.wrapped.hasNext();
                }

                @Override
                public E next() {
                    return this.wrapped.next();
                }

                @Override
                public int nextIndex() {
                    return this.wrapped.nextIndex();
                }

                @Override
                public boolean hasPrevious() {
                    return this.wrapped.hasPrevious();
                }

                @Override
                public E previous() {
                    return this.wrapped.previous();
                }

                @Override
                public int previousIndex() {
                    return this.wrapped.previousIndex();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    this.wrapped.forEachRemaining(action);
                }

                @Override
                public void remove() {
                    if (this.allowedModifications().contains((Object)Modification.RemoveObj)) {
                        this.wrapped.remove();
                    }
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(E element) {
                    if (this.allowedModifications().contains((Object)Modification.AddObj)) {
                        this.wrapped.add(element);
                    }
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(E element) {
                    if (this.allowedModifications().contains((Object)Modification.SetObj)) {
                        this.wrapped.add(element);
                    }
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public E remove(int index) {
            if (this.allowedModifications().contains((Object)Modification.RemoveObj)) {
                return this.unrestricted().remove(index);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public E set(int index, E element) {
            if (this.allowedModifications().contains((Object)Modification.SetObj)) {
                return this.unrestricted().set(index, element);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            if (!this.allowedModifications().contains((Object)Modification.SetObj)) {
                throw new UnsupportedOperationException();
            }
            this.unrestricted().replaceAll(operator);
        }

        @Override
        public void sort(Comparator<? super E> cmp) {
            if (!this.allowedModifications().contains((Object)Modification.SetObj)) {
                throw new UnsupportedOperationException();
            }
            this.unrestricted().sort(cmp);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            List res0 = this.unrestricted().subList(fromIndex, toIndex);
            return new ImmutableList(this.allowedModifications(), res0);
        }
    }

    public static final class ImmutableCyclicList<E>
    implements CyclicList<E> {
        private final CyclicList<E> wrapped;

        ImmutableCyclicList(CyclicList<E> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public int shiftIndex(int index) {
            throw new NotYetImplementedException();
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }

        @Override
        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        @Override
        public CyclicList<E> getInverse() {
            throw new NotYetImplementedException();
        }

        @Override
        public boolean contains(Object obj) {
            return this.wrapped.contains(obj);
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            throw new NotYetImplementedException();
        }

        @Override
        public Iterator<E> iterator() {
            throw new NotYetImplementedException();
        }

        @Override
        public CyclicIterator<E> cyclicIterator(int index) {
            CyclicIterator<E> tbWrapped = this.wrapped.cyclicIterator(index);
            return new NonModifyingCyclicIterator<E>(tbWrapped);
        }

        @Override
        public Object[] toArray(int index) {
            throw new NotYetImplementedException();
        }

        @Override
        public <E> E[] toArray(int index, E[] array) {
            throw new NotYetImplementedException();
        }

        @Override
        public Object[] toArray() {
            throw new NotYetImplementedException();
        }

        @Override
        public <E> E[] toArray(E[] ret) {
            throw new NotYetImplementedException();
        }

        @Override
        public List<E> asList(int index) {
            throw new NotYetImplementedException();
        }

        @Override
        public List<E> asList() {
            return Collections.unmodifiableList(this.wrapped.asList());
        }

        @Override
        public CyclicList<E> cycle(int num) {
            throw new NotYetImplementedException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            return this.wrapped.equals(obj);
        }

        @Override
        public boolean equalsCyclic(Object obj) {
            return this.wrapped.equalsCyclic(obj);
        }

        @Override
        public int hashCode() {
            return this.wrapped.hashCode();
        }

        @Override
        public int hashCodeCyclic() {
            return this.wrapped.hashCodeCyclic();
        }

        @Override
        public E get(int index) {
            return this.wrapped.get(index);
        }

        @Override
        public E set(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replace(int index, Iterator<E> iter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replace(int index, List<E> list) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addAll(int index, Iterator<E> iter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addAll(int index, List<? extends E> list) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E remove(int index) throws EmptyCyclicListException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getIndexOf(int idx, Object obj) {
            throw new NotYetImplementedException();
        }

        @Override
        public CyclicList<E> getCopy(int len) {
            throw new NotYetImplementedException();
        }
    }

    static class ImmutableMultiSet<E>
    extends AbstractImmutableMultiSet<MultiSet<E>, E> {
        private final MultiSet<E> mSet;

        ImmutableMultiSet(MultiSet<E> mSet) {
            if (mSet == null) {
                throw new NullPointerException();
            }
            this.mSet = mSet;
        }

        @Override
        public MultiSet<E> unrestricted() {
            return this.mSet;
        }
    }

    static class ImmutableSortedMultiSet<E>
    extends AbstractImmutableMultiSet<SortedMultiSet<E>, E>
    implements SortedMultiSet<E> {
        private final SortedMultiSet<E> mSet;

        ImmutableSortedMultiSet(SortedMultiSet<E> mSet) {
            if (mSet == null) {
                throw new NullPointerException();
            }
            this.mSet = mSet;
        }

        ImmutableSortedMultiSet(Set<Modification> mods, SortedMultiSet<E> mSet) {
            super(mods);
            if (mSet == null) {
                throw new NullPointerException();
            }
            this.mSet = mSet;
        }

        @Override
        public SortedMultiSet<E> unrestricted() {
            return this.mSet;
        }

        @Override
        public SortedSet<E> getSet() {
            return new ImmutableSortedSet(this.allowedModifications(), this.unrestricted().getSet());
        }

        @Override
        public NavigableMap<E, MultiSet.Multiplicity> getMap() {
            throw new NotYetImplementedException();
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.unrestricted().comparator();
        }

        @Override
        public E first() {
            return (E)this.unrestricted().first();
        }

        @Override
        public E last() {
            return (E)this.unrestricted().last();
        }

        @Override
        public SortedMultiSet<E> headSet(E toElement) {
            SortedMultiSet<E> res0 = this.unrestricted().headSet(toElement);
            return new ImmutableSortedMultiSet<E>(this.allowedModifications(), res0);
        }

        @Override
        public SortedMultiSet<E> tailSet(E fromElement) {
            SortedMultiSet<E> res0 = this.unrestricted().tailSet(fromElement);
            return new ImmutableSortedMultiSet<E>(this.allowedModifications(), res0);
        }

        @Override
        public SortedMultiSet<E> subSet(E fromElement, E toElement) {
            SortedMultiSet<E> res0 = this.unrestricted().subSet(fromElement, toElement);
            return new ImmutableSortedMultiSet<E>(this.allowedModifications(), res0);
        }
    }

    static abstract class AbstractImmutableMultiSet<C extends MultiSet<E>, E>
    implements MultiSet<E> {
        private final Set<Modification> mods;

        private AbstractImmutableMultiSet() {
            this(EnumSet.noneOf(Modification.class));
        }

        AbstractImmutableMultiSet(Set<Modification> mods) {
            this.mods = mods;
        }

        public final Set<Modification> allowedModifications() {
            return this.mods;
        }

        public abstract C unrestricted();

        @Override
        public int size() {
            return this.unrestricted().size();
        }

        @Override
        public int sizeWithMult() {
            return this.unrestricted().sizeWithMult();
        }

        @Override
        public boolean isEmpty() {
            return this.unrestricted().isEmpty();
        }

        @Override
        public Object getObjWithMaxMult() {
            return this.unrestricted().getObjWithMaxMult();
        }

        @Override
        public int getMaxMult() {
            return this.unrestricted().getMaxMult();
        }

        @Override
        public int getMultiplicity(Object obj) {
            return this.unrestricted().getMultiplicity(obj);
        }

        @Override
        public boolean contains(Object obj) {
            return this.unrestricted().contains(obj);
        }

        @Override
        public Object[] toArray() {
            return this.unrestricted().toArray();
        }

        @Override
        public E[] toArray(E[] arr) {
            return this.unrestricted().toArray(arr);
        }

        @Override
        public MultiSet.Multiplicity getMultiplicityObj(Object obj) {
            MultiSet.Multiplicity res0 = this.unrestricted().getMultiplicityObj(obj);
            return new ImmutableMultiplicity(res0, this.allowedModifications());
        }

        @Override
        public MultiSetIterator<E> iterator() {
            return new MultiSetIterator<E>(){
                private MultiSetIterator<E> wrapped;
                {
                    this.wrapped = this.unrestricted().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.wrapped.hasNext();
                }

                @Override
                public E next() {
                    return this.wrapped.next();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    this.wrapped.forEachRemaining(action);
                }

                @Override
                public void remove() {
                    if (mods.contains((Object)Modification.RemoveObj)) {
                        this.wrapped.remove();
                    }
                    throw new UnsupportedOperationException();
                }

                @Override
                public int getMult() {
                    return this.wrapped.getMult();
                }

                @Override
                public MultiSet.Multiplicity getMultObj() {
                    return this.wrapped.getMultObj();
                }

                @Override
                public int setMult(int mult) {
                    MultiSet.Multiplicity last = this.getMultObj();
                    assert (last != null);
                    if (mult == 0) {
                        int res = last.get();
                        this.remove();
                        return res;
                    }
                    return last.set(mult);
                }

                @Override
                public int removeMult(int mult) {
                    MultiSet.Multiplicity last = this.getMultObj();
                    assert (last != null);
                    int oldMult = last.get();
                    if (mult == oldMult) {
                        this.remove();
                        return oldMult;
                    }
                    last.add(-mult);
                    return oldMult;
                }
            };
        }

        @Override
        public int addWithMult(E obj) {
            if (this.mods.contains((Object)Modification.AddObj)) {
                return this.unrestricted().addWithMult(obj);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public int addWithMult(E obj, int addMult) {
            if (this.mods.contains((Object)Modification.AddObj)) {
                return this.unrestricted().addWithMult(obj, addMult);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(E obj) {
            if (this.mods.contains((Object)Modification.AddObj)) {
                return this.unrestricted().add(obj);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeWithMult(Object obj) {
            if (this.mods.contains((Object)Modification.RemoveObj)) {
                return this.unrestricted().removeWithMult(obj);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeWithMult(Object obj, int removeMult) {
            if (this.mods.contains((Object)Modification.RemoveObj)) {
                return this.unrestricted().removeWithMult(obj, removeMult);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object obj) {
            if (this.mods.contains((Object)Modification.RemoveObj)) {
                return this.unrestricted().remove(obj);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public int setMultiplicity(E obj, int newMult) {
            throw new NotYetImplementedException();
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            return this.unrestricted().containsAll(coll);
        }

        @Override
        public boolean addAll(MultiSet<? extends E> mvs) {
            if (this.mods.contains((Object)Modification.AddObj)) {
                return this.unrestricted().addAll(mvs);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Set<? extends E> set) {
            if (this.mods.contains((Object)Modification.AddObj)) {
                return this.unrestricted().addAll(set);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            if (this.mods.contains((Object)Modification.RemoveObj)) {
                return this.unrestricted().removeAll(coll);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            if (this.mods.contains((Object)Modification.RemoveObj)) {
                return this.unrestricted().retainAll(coll);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            if (!this.mods.contains((Object)Modification.RemoveObj)) {
                throw new UnsupportedOperationException();
            }
            this.unrestricted().clear();
        }

        @Override
        public Set<E> getSet() {
            return new ImmutableSet(this.allowedModifications(), this.unrestricted().getSet());
        }

        @Override
        public Map<E, MultiSet.Multiplicity> getMap() {
            throw new NotYetImplementedException();
        }

        @Override
        public Set<Map.Entry<E, MultiSet.Multiplicity>> getSetWithMults() {
            return new ImmutableSet<Map.Entry<E, MultiSet.Multiplicity>>(this.allowedModifications(), this.unrestricted().getSetWithMults());
        }

        @Override
        public String toString() {
            StringBuilder res = new StringBuilder();
            res.append("<Immutable modifications=\">");
            res.append(this.mods);
            res.append("\">");
            res.append(this.unrestricted().toString());
            res.append("</Immutable>");
            return res.toString();
        }

        @Override
        public boolean equals(Object obj) {
            return this.unrestricted().equals(obj);
        }

        @Override
        public int hashCode() {
            return this.unrestricted().hashCode();
        }
    }

    private static class ImmutableMultiplicity
    implements MultiSet.Multiplicity {
        private final MultiSet.Multiplicity wrapped;
        private final Set<Modification> mod;

        ImmutableMultiplicity(MultiSet.Multiplicity wrapped, Set<Modification> mod) {
            this.wrapped = wrapped;
            this.mod = mod;
        }

        private Set<Modification> allowedModifications() {
            return this.mod;
        }

        @Override
        public int set(int mult) {
            int multOrg = this.wrapped.get();
            switch ((int)Math.signum(mult - multOrg)) {
                case -1: {
                    assert (mult < multOrg);
                    if (!this.allowedModifications().contains((Object)Modification.RemoveObj)) break;
                    return this.wrapped.set(mult);
                }
                case 1: {
                    assert (mult > multOrg);
                    if (!this.allowedModifications().contains((Object)Modification.AddObj)) break;
                    return this.wrapped.set(mult);
                }
                case 0: {
                    assert (mult == multOrg);
                    return this.wrapped.set(mult);
                }
                default: {
                    throw new IllegalStateException("****");
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public int add(int mult) {
            switch ((int)Math.signum(mult)) {
                case -1: {
                    assert (mult < 0);
                    if (!this.allowedModifications().contains((Object)Modification.RemoveObj)) break;
                    return this.wrapped.add(mult);
                }
                case 1: {
                    assert (mult > 0);
                    if (!this.allowedModifications().contains((Object)Modification.AddObj)) break;
                    return this.wrapped.add(mult);
                }
                case 0: {
                    assert (mult == 0);
                    return this.wrapped.add(mult);
                }
                default: {
                    throw new IllegalStateException("****");
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public int get() {
            return this.wrapped.get();
        }

        @Override
        public int compareTo(MultiSet.Multiplicity mult) {
            return this.wrapped.compareTo(mult);
        }

        @Override
        public boolean equals(Object obj) {
            return this.wrapped.equals(obj);
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }
    }

    public static final class NonModifyingCyclicIterator<E>
    implements CyclicIterator<E> {
        private final CyclicIterator<E> wrapped;

        NonModifyingCyclicIterator(CyclicIterator<E> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public int getFirstIndex() {
            return this.wrapped.getFirstIndex();
        }

        @Override
        public int getIndex() {
            return this.wrapped.getIndex();
        }

        @Override
        public CyclicList<E> getCyclicList() {
            return this.wrapped.getCyclicList();
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public E next() {
            return this.wrapped.next();
        }

        @Override
        public boolean hasPrev() {
            return this.wrapped.hasPrev();
        }

        @Override
        public E previous() {
            return this.wrapped.previous();
        }

        @Override
        public int getNextIndexOf(E obj) {
            return this.wrapped.getNextIndexOf(obj);
        }

        @Override
        public void setIndex(int index) {
            this.wrapped.setIndex(index);
        }

        @Override
        public void add(E obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addAll(List<? extends E> list) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void refresh() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retEquals(CyclicIterator<?> other) {
            throw new NotYetImplementedException();
        }

        @Override
        @SuppressWarnings(value={"EQ_UNUSUAL"}, justification="special kind of exception")
        public boolean equals(Object other) {
            throw new NotYetImplementedException();
        }

        public int hashCode() {
            throw new NotYetImplementedException();
        }

        @Override
        public double dist(CyclicIterator<E> other) {
            throw new NotYetImplementedException();
        }
    }

    public static abstract class AbstractImmutableCollection<C extends Collection<E>, E>
    extends AbstractCollection<E> {
        private final Set<Modification> mods;

        private AbstractImmutableCollection() {
            this(EnumSet.noneOf(Modification.class));
        }

        AbstractImmutableCollection(Set<Modification> mods) {
            this.mods = mods;
        }

        public final AbstractImmutableCollection<C, E> allowModification(Modification mod) {
            this.mods.add(mod);
            return this;
        }

        public final void allowModifications(Set<Modification> mods) {
            this.mods.addAll(mods);
        }

        public final Set<Modification> allowedModifications() {
            return this.mods;
        }

        public abstract C unrestricted();

        @Override
        public final int size() {
            return this.unrestricted().size();
        }

        @Override
        public final boolean add(E obj) {
            if (this.mods.contains((Object)Modification.AddObj)) {
                return this.unrestricted().add(obj);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean remove(Object obj) {
            if (this.mods.contains((Object)Modification.RemoveObj)) {
                return this.unrestricted().remove(obj);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final void clear() {
            if (this.mods.contains((Object)Modification.RemoveObj)) {
                this.unrestricted().clear();
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends E> coll) {
            if (this.mods.contains((Object)Modification.AddObj)) {
                return this.unrestricted().addAll(coll);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(Collection<?> coll) {
            if (this.mods.contains((Object)Modification.RemoveObj)) {
                return this.unrestricted().retainAll(coll);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(Collection<?> cmp) {
            if (this.mods.contains((Object)Modification.RemoveObj)) {
                return this.unrestricted().removeAll(cmp);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeIf(Predicate<? super E> filter) {
            if (this.mods.contains((Object)Modification.RemoveObj)) {
                return this.unrestricted().removeIf(filter);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final Iterator<E> iterator() {
            return new Iterator<E>(){
                private Iterator<E> wrapped;
                {
                    this.wrapped = this.unrestricted().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.wrapped.hasNext();
                }

                @Override
                public E next() {
                    return this.wrapped.next();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    this.wrapped.forEachRemaining(action);
                }

                @Override
                public void remove() {
                    if (mods.contains((Object)Modification.RemoveObj)) {
                        this.wrapped.remove();
                    }
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public final String toString() {
            StringBuilder res = new StringBuilder();
            res.append("<Immutable modifications=\"");
            res.append(this.mods);
            res.append("\">");
            res.append(this.unrestricted().toString());
            res.append("</Immutable>");
            return res.toString();
        }
    }

    public static enum Modification {
        AddObj,
        RemoveObj,
        SetObj;

    }
}

