/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

import java.util.Stack;

public final class Benchmarker {
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static Stack<Snapshot> snapshots = new Stack();

    private Benchmarker() {
    }

    private static long usedMemoryBytes() {
        RUNTIME.gc();
        return RUNTIME.maxMemory() - RUNTIME.freeMemory();
    }

    public static void mtic() {
        assert (snapshots.isEmpty());
        snapshots.push(new Snapshot());
        assert (!snapshots.peek().isStopped());
    }

    public static void pause() {
        assert (!snapshots.isEmpty());
        snapshots.peek().toggleStartStop(true);
        assert (snapshots.peek().isStopped());
    }

    public static void resume() {
        assert (!snapshots.isEmpty());
        snapshots.peek().toggleStartStop(false);
        assert (!snapshots.peek().isStopped());
    }

    public static Snapshot mtoc() {
        assert (!snapshots.isEmpty());
        Snapshot res = snapshots.pop().toggleStartStop(true);
        assert (snapshots.isEmpty());
        assert (res.isStopped());
        return res;
    }

    public static boolean isStarted() {
        return !snapshots.isEmpty();
    }

    public static class Snapshot {
        private boolean isStopped = false;
        private long timeNs = System.nanoTime();
        private long memBytes = Benchmarker.access$000();

        Snapshot() {
        }

        protected Snapshot toggleStartStop(boolean doStop) {
            assert (this.isStopped != doStop);
            this.timeNs = System.nanoTime() - this.timeNs;
            this.memBytes = Benchmarker.usedMemoryBytes() - this.memBytes;
            this.isStopped = doStop;
            return this;
        }

        public double getTimeMs() {
            assert (this.isStopped);
            return (double)this.timeNs / 1000000.0;
        }

        public double getMemoryMB() {
            assert (this.isStopped);
            return (double)this.memBytes / 1000000.0;
        }

        public boolean isStopped() {
            return this.isStopped;
        }

        public String toString() {
            String es = this.isStopped ? "Elapsed " : "Snapshot";
            return String.format("%s time: %fms mem %f", es, this.getTimeMs(), this.getMemoryMB());
        }
    }
}

