/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

public final class Benchmarker {
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static Snapshot snapshot = null;

    private Benchmarker() {
    }

    private static long usedMemoryBytes() {
        RUNTIME.gc();
        return RUNTIME.maxMemory() - RUNTIME.freeMemory();
    }

    public static void mtic() {
        assert (snapshot == null);
        snapshot = new Snapshot();
        assert (snapshot != null);
    }

    public static Snapshot mtoc() {
        assert (snapshot != null);
        Snapshot res = snapshot.stop();
        snapshot = null;
        assert (snapshot == null);
        return res;
    }

    public static boolean isStarted() {
        return snapshot != null;
    }

    public static class Snapshot {
        private long timeTicNs = System.nanoTime();
        private long memBytes = Benchmarker.access$000();
        private boolean isStopped = false;

        Snapshot() {
        }

        protected Snapshot stop() {
            assert (!this.isStopped);
            this.timeTicNs = System.nanoTime() - this.timeTicNs;
            this.memBytes = Benchmarker.usedMemoryBytes() - this.memBytes;
            this.isStopped = true;
            return this;
        }

        public double getTimeMs() {
            assert (this.isStopped);
            return (double)this.timeTicNs / 1000000.0;
        }

        public double getMemoryMB() {
            assert (this.isStopped);
            return (double)this.memBytes / 1000000.0;
        }

        public String toString() {
            String es = this.isStopped ? "Elapsed " : "Snapshot";
            return String.format("%s time: %fms mem %f", es, this.getTimeMs(), this.getMemoryMB());
        }
    }
}

