/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

public final class Benchmarker {
    private static boolean isStarted = false;
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static Snapshot snapshot = null;

    private Benchmarker() {
    }

    private static long usedMemoryBytes() {
        RUNTIME.gc();
        return RUNTIME.maxMemory() - RUNTIME.freeMemory();
    }

    public static void mtic() {
        assert (isStarted == (snapshot != null));
        assert (!isStarted);
        isStarted = !isStarted;
        snapshot = new Snapshot();
        assert (isStarted == (snapshot != null));
    }

    public static Snapshot mtoc() {
        assert (isStarted == (snapshot != null));
        assert (isStarted);
        isStarted = !isStarted;
        snapshot.stop();
        Snapshot res = snapshot;
        snapshot = null;
        assert (isStarted == (snapshot != null));
        return res;
    }

    public static boolean isStarted() {
        return isStarted;
    }

    public static class Snapshot {
        private long timeTicNs = System.nanoTime();
        private long memBytes = Benchmarker.access$000();
        private boolean isStopped = false;

        Snapshot() {
        }

        protected void stop() {
            this.timeTicNs = System.nanoTime() - this.timeTicNs;
            this.memBytes = Benchmarker.usedMemoryBytes() - this.memBytes;
            this.isStopped = true;
        }

        public double getTimeMs() {
            assert (this.isStopped);
            return (double)this.timeTicNs / 1000000.0;
        }

        public double getMemoryMB() {
            assert (this.isStopped);
            return (double)this.memBytes / 1000000.0;
        }

        public String toString() {
            String es = this.isStopped ? "Elapsed " : "Snapshot";
            return String.format("%s time: %fms mem %f", es, this.getTimeMs(), this.getMemoryMB());
        }
    }
}

