/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

public final class Benchmarker {
    private static boolean isStarted = false;
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static long TIME_TIC_NS;
    private static long TIME_TIC_MS;
    private static long MEMORY_BYTES;

    private Benchmarker() {
    }

    private static long usedMemoryBytes() {
        RUNTIME.gc();
        return RUNTIME.maxMemory() - RUNTIME.freeMemory();
    }

    public static long mtic() {
        assert (!isStarted);
        isStarted = !isStarted;
        MEMORY_BYTES = Benchmarker.usedMemoryBytes();
        TIME_TIC_NS = System.nanoTime();
        TIME_TIC_MS = System.currentTimeMillis();
        return TIME_TIC_MS;
    }

    public static long mtoc() {
        assert (isStarted);
        isStarted = !isStarted;
        TIME_TIC_NS = System.nanoTime() - TIME_TIC_NS;
        TIME_TIC_MS = System.currentTimeMillis() - TIME_TIC_MS;
        MEMORY_BYTES = Benchmarker.usedMemoryBytes() - MEMORY_BYTES;
        return TIME_TIC_MS;
    }

    public static long getStartTime() {
        assert (isStarted);
        return TIME_TIC_MS;
    }

    public static double getStartTimeD() {
        assert (isStarted);
        return TIME_TIC_MS;
    }

    public static long getStartTimeP() {
        assert (isStarted);
        return TIME_TIC_NS;
    }

    public static long getTimeMs() {
        assert (!isStarted);
        return TIME_TIC_MS;
    }

    public static double getTimeMsD() {
        assert (!isStarted);
        double res = TIME_TIC_MS;
        assert (res == (double)TIME_TIC_MS);
        return res;
    }

    public static long getTimeMsP() {
        assert (!isStarted);
        return TIME_TIC_MS;
    }

    public static double getMemoryMB() {
        assert (!isStarted);
        return (double)MEMORY_BYTES / 1000000.0;
    }

    public static boolean isStarted() {
        return isStarted;
    }
}

