/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

public final class Benchmarker {
    private static boolean isStarted = false;
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static long TIME_TIC_NS;
    private static long MEMORY_BYTES;

    private Benchmarker() {
    }

    private static long usedMemoryBytes() {
        RUNTIME.gc();
        return RUNTIME.maxMemory() - RUNTIME.freeMemory();
    }

    public static long mtic() {
        assert (!isStarted);
        isStarted = !isStarted;
        MEMORY_BYTES = Benchmarker.usedMemoryBytes();
        TIME_TIC_NS = System.currentTimeMillis();
        return TIME_TIC_NS;
    }

    public static long mtoc() {
        assert (isStarted);
        isStarted = !isStarted;
        TIME_TIC_NS = System.currentTimeMillis() - TIME_TIC_NS;
        MEMORY_BYTES = Benchmarker.usedMemoryBytes() - MEMORY_BYTES;
        return TIME_TIC_NS;
    }

    public static double getTimeMs() {
        assert (!isStarted);
        return TIME_TIC_NS;
    }

    public static double getMemoryMB() {
        assert (!isStarted);
        return (double)MEMORY_BYTES / 1000000.0;
    }

    public boolean isStarted() {
        return isStarted;
    }
}

