/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

import java.util.HashMap;
import java.util.Map;

public final class BasicTypesCompatibilityChecker {
    private static final Map<Class<?>, Class<?>> MAP_WRAPPER2BASIC_TYPE = new HashMap();
    private static final Map<Class<?>, Class<?>> MAP_BASIC_TYPE2WRAPPER = new HashMap();

    private BasicTypesCompatibilityChecker() {
    }

    public static boolean isPrimitive(Class<?> cls) {
        return MAP_BASIC_TYPE2WRAPPER.keySet().contains(cls);
    }

    public static boolean wrapsPrimitive(Class<?> cls) {
        return MAP_WRAPPER2BASIC_TYPE.keySet().contains(cls);
    }

    public static boolean areCompatible(Class<?> cls, Object obj) {
        if (cls.isPrimitive()) {
            if (obj == null) {
                return false;
            }
            assert (obj != null);
            return BasicTypesCompatibilityChecker.getWrapperCls(cls, false).isInstance(obj);
        }
        return obj == null || cls.isInstance(obj);
    }

    public static Class<?> getWrappedCls(Class<?> cls, boolean allowsVoid) {
        Class<?> res = MAP_WRAPPER2BASIC_TYPE.get(cls);
        if (res == null || !allowsVoid && res == Void.TYPE) {
            throw new IllegalArgumentException("Expected wrapper class of primitive type " + (allowsVoid ? "or" : "but not") + " void; found " + cls + ". ");
        }
        assert (res != null && (allowsVoid || res != Void.TYPE));
        return res;
    }

    public static Class<?> getWrapperCls(Class<?> cls, boolean allowsVoid) {
        Class<?> res = MAP_BASIC_TYPE2WRAPPER.get(cls);
        if (res == null || !allowsVoid && res == Void.TYPE) {
            throw new IllegalArgumentException("Expected primitive type " + (allowsVoid ? "or" : "but not") + " void; found " + cls + ". ");
        }
        assert (res != null && (allowsVoid || res != Void.TYPE));
        return res;
    }

    static {
        MAP_WRAPPER2BASIC_TYPE.put(Boolean.class, Boolean.TYPE);
        MAP_WRAPPER2BASIC_TYPE.put(Character.class, Character.TYPE);
        MAP_WRAPPER2BASIC_TYPE.put(Byte.class, Byte.TYPE);
        MAP_WRAPPER2BASIC_TYPE.put(Short.class, Short.TYPE);
        MAP_WRAPPER2BASIC_TYPE.put(Integer.class, Integer.TYPE);
        MAP_WRAPPER2BASIC_TYPE.put(Long.class, Long.TYPE);
        MAP_WRAPPER2BASIC_TYPE.put(Float.class, Float.TYPE);
        MAP_WRAPPER2BASIC_TYPE.put(Double.class, Double.TYPE);
        MAP_WRAPPER2BASIC_TYPE.put(Void.TYPE, Void.TYPE);
        MAP_BASIC_TYPE2WRAPPER.put(Boolean.TYPE, Boolean.class);
        MAP_BASIC_TYPE2WRAPPER.put(Character.TYPE, Character.class);
        MAP_BASIC_TYPE2WRAPPER.put(Byte.TYPE, Byte.class);
        MAP_BASIC_TYPE2WRAPPER.put(Short.TYPE, Short.class);
        MAP_BASIC_TYPE2WRAPPER.put(Integer.TYPE, Integer.class);
        MAP_BASIC_TYPE2WRAPPER.put(Long.TYPE, Long.class);
        MAP_BASIC_TYPE2WRAPPER.put(Float.TYPE, Float.class);
        MAP_BASIC_TYPE2WRAPPER.put(Double.TYPE, Double.class);
        MAP_BASIC_TYPE2WRAPPER.put(Void.TYPE, Void.TYPE);
    }
}

