/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

import eu.simuline.util.MultiSet;
import eu.simuline.util.MultiSetIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMultiSet<MAP extends Map<T, MultiSet.Multiplicity>, T>
implements MultiSet<T> {
    protected final MAP obj2mult;

    public AbstractMultiSet(MAP t2mult) {
        this.obj2mult = t2mult;
    }

    @Override
    public final int size() {
        return this.obj2mult.size();
    }

    @Override
    public final int sizeWithMult() {
        int result = 0;
        for (MultiSet.Multiplicity mult : this.obj2mult.values()) {
            if ((result += mult.get()) >= 0) continue;
            return Integer.MAX_VALUE;
        }
        assert (result >= 0);
        return result;
    }

    @Override
    public final boolean isEmpty() {
        return this.obj2mult.isEmpty();
    }

    private Map.Entry<T, MultiSet.Multiplicity> getMaxObjWithMult() {
        Map.Entry maxCand = null;
        int maxVal = 0;
        for (Map.Entry cand : this.obj2mult.entrySet()) {
            int cmpVal = ((MultiSet.Multiplicity)cand.getValue()).get();
            if (maxVal >= cmpVal) continue;
            maxCand = cand;
            maxVal = cmpVal;
        }
        return maxCand;
    }

    @Override
    public final T getObjWithMaxMult() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getMaxObjWithMult().getKey();
    }

    @Override
    public final int getMaxMult() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.getMaxObjWithMult().getValue().get();
    }

    @Override
    public final int getMultiplicity(Object obj) {
        MultiSet.Multiplicity result = this.getMultiplicityObj(obj);
        return result == null ? 0 : result.get();
    }

    @Override
    public final MultiSet.Multiplicity getMultiplicityObj(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return (MultiSet.Multiplicity)this.obj2mult.get(obj);
    }

    @Override
    public final boolean contains(Object obj) {
        return this.getMultiplicityObj(obj) != null;
    }

    @Override
    public final MultiSetIterator<T> iterator() {
        return new MultiSetIteratorImpl(this);
    }

    @Override
    public final Object[] toArray() {
        return this.getSet().toArray(new Object[0]);
    }

    @Override
    public final T[] toArray(T[] arr) {
        return this.getSet().toArray(arr);
    }

    @Override
    public final int addWithMult(T obj) {
        return this.addWithMult(obj, 1);
    }

    @Override
    public final int addWithMult(T obj, int addMult) {
        if (addMult < 0) {
            throw new IllegalArgumentException("Expected non-negative multiplicity; found " + addMult + ". ");
        }
        MultiSet.Multiplicity mult = this.getMultiplicityObj(obj);
        if (mult == null) {
            if (addMult != 0) {
                assert (addMult > 0);
                mult = MultiplicityImpl.create(addMult);
                this.obj2mult.put(obj, (MultiSet.Multiplicity)mult);
            }
            return addMult;
        }
        return mult.add(addMult);
    }

    @Override
    public final boolean add(T obj) {
        MultiSet.Multiplicity mult = this.getMultiplicityObj(obj);
        if (mult == null) {
            mult = MultiplicityImpl.create(1);
            this.obj2mult.put(obj, (MultiSet.Multiplicity)mult);
            return true;
        }
        mult.add(1);
        return false;
    }

    @Override
    public final int removeWithMult(Object obj) {
        return this.removeWithMult(obj, 1);
    }

    @Override
    public final int removeWithMult(Object obj, int removeMult) {
        if (removeMult < 0) {
            throw new IllegalArgumentException("Expected non-negative multiplicity; found " + removeMult + ". ");
        }
        MultiSet.Multiplicity mult = this.getMultiplicityObj(obj);
        if (mult == null) {
            if (removeMult != 0) {
                throw new IllegalArgumentException("Tried to remove object " + obj + " which is not in this MultiSet. ");
            }
            return 0;
        }
        int ret = mult.get();
        if (ret == removeMult) {
            this.obj2mult.remove(obj);
        } else {
            mult.add(-removeMult);
        }
        return ret;
    }

    @Override
    public final boolean remove(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return this.obj2mult.remove(obj) != null;
    }

    @Override
    public final int setMultiplicity(T obj, int newMult) {
        if (obj == null) {
            throw new IllegalArgumentException("Found null element. ");
        }
        if (newMult < 0) {
            throw new IllegalArgumentException("Found negative multiplicity " + newMult + ". ");
        }
        MultiSet.Multiplicity oldMult = newMult == 0 ? (MultiSet.Multiplicity)this.obj2mult.remove(obj) : (MultiSet.Multiplicity)this.obj2mult.put(obj, (MultiplicityImpl)MultiplicityImpl.create(newMult));
        return oldMult == null ? 0 : oldMult.get();
    }

    @Override
    public final boolean containsAll(Collection<?> coll) {
        for (Object cand : coll) {
            if (this.contains(cand)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean addAll(MultiSet<? extends T> mvs) {
        boolean added = false;
        for (T cand : mvs.getSet()) {
            int mvsMult = mvs.getMultiplicity(cand);
            assert (mvsMult > 0);
            MultiSet.Multiplicity mult = (MultiSet.Multiplicity)this.obj2mult.get(cand);
            if (mult == null) {
                this.obj2mult.put(cand, (MultiplicityImpl)MultiplicityImpl.create(mvsMult));
                added = true;
                continue;
            }
            mult.add(mvsMult);
        }
        return added;
    }

    @Override
    public final boolean addAll(Set<? extends T> set) {
        boolean added = false;
        for (T cand : set) {
            MultiSet.Multiplicity mult = (MultiSet.Multiplicity)this.obj2mult.get(cand);
            if (mult == null) {
                this.obj2mult.put(cand, (MultiplicityImpl)MultiplicityImpl.create(1));
                added = true;
                continue;
            }
            mult.add(1);
        }
        return added;
    }

    @Override
    public final boolean removeAll(Collection<?> coll) {
        boolean thisChanged = false;
        for (Object cand : coll) {
            thisChanged |= this.remove(cand);
        }
        return thisChanged;
    }

    @Override
    public final boolean retainAll(Collection<?> coll) {
        boolean result = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object cand = iter.next();
            if (coll.contains(cand)) continue;
            iter.remove();
            result = true;
        }
        return result;
    }

    @Override
    public final void clear() {
        this.obj2mult.clear();
    }

    @Override
    public final Set<Map.Entry<T, MultiSet.Multiplicity>> getSetWithMults() {
        return this.obj2mult.entrySet();
    }

    @Override
    public final boolean equals(Object obj) {
        if (!(obj instanceof MultiSet)) {
            return false;
        }
        MultiSet other = (MultiSet)obj;
        return this.getSetWithMults().equals(other.getSetWithMults());
    }

    @Override
    public final int hashCode() {
        int result = 0;
        for (Object cand : this.getSet()) {
            result += cand.hashCode() * this.getMultiplicity(cand);
        }
        return result;
    }

    protected static class MultiSetIteratorImpl<T>
    implements MultiSetIterator<T> {
        private final Iterator<Map.Entry<T, MultiSet.Multiplicity>> entrySetIter;
        private Map.Entry<T, MultiSet.Multiplicity> last;

        MultiSetIteratorImpl(MultiSet<T> multiSet) {
            this.entrySetIter = multiSet.getSetWithMults().iterator();
            this.last = null;
        }

        @Override
        public final boolean hasNext() {
            return this.entrySetIter.hasNext();
        }

        @Override
        public final T next() {
            this.last = this.entrySetIter.next();
            return this.last.getKey();
        }

        @Override
        public final void remove() {
            this.entrySetIter.remove();
            this.last = null;
        }

        @Override
        public final int getMult() {
            return this.getMultObj().get();
        }

        @Override
        public final MultiSet.Multiplicity getMultObj() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            assert (this.last != null);
            return this.last.getValue();
        }

        @Override
        public final int setMult(int mult) {
            MultiSet.Multiplicity last = this.getMultObj();
            assert (last != null);
            if (mult == 0) {
                int res = last.get();
                this.remove();
                return res;
            }
            return last.set(mult);
        }

        @Override
        public final int removeMult(int mult) {
            MultiSet.Multiplicity last = this.getMultObj();
            assert (last != null);
            int oldMult = last.get();
            if (mult == oldMult) {
                this.remove();
                return oldMult;
            }
            last.add(-mult);
            return oldMult;
        }
    }

    public static final class MultiplicityImpl
    implements MultiSet.Multiplicity {
        private int mult;

        private MultiplicityImpl(int mult) {
            this.set(mult);
        }

        protected static MultiplicityImpl create(int mult) {
            return new MultiplicityImpl(mult);
        }

        @Override
        public int set(int mult) {
            if (mult <= 0) {
                throw new IllegalArgumentException("Expected non-negative multiplicity; found " + mult + ". ");
            }
            int oldMult = this.mult;
            this.mult = mult;
            return oldMult;
        }

        @Override
        public int add(int mult) {
            this.mult += mult;
            if (this.mult <= 0) {
                if (this.mult == 0) {
                    throw new IllegalStateException("should not occur: removed element implicitely. ");
                }
                this.mult -= mult;
                throw new IllegalArgumentException("Resulting multiplicity " + this.mult + " + " + mult + " should be non-negative. ");
            }
            return this.mult;
        }

        @Override
        public int get() {
            return this.mult;
        }

        @Override
        public int compareTo(MultiSet.Multiplicity mult) {
            return this.get() - mult.get();
        }

        public String toString() {
            return "Multiplicity " + this.get();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof MultiSet.Multiplicity)) {
                return false;
            }
            return ((MultiSet.Multiplicity)obj).get() == this.get();
        }

        public int hashCode() {
            return this.mult;
        }
    }
}

