/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import eu.simuline.util.ListSet;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;

public final class ListMap<K, V>
implements SortedMap<K, V> {
    private final ListSet<K> keys;
    private final List<V> values;
    private final Collection<V> valuesColl;
    private final SortedSet<K> keysSet;
    private final SortedSet<Map.Entry<K, V>> entrySet;

    public ListMap() {
        this(ListSet.sortedAsAdded(), new ArrayList());
    }

    public ListMap(Map<K, V> map) {
        this(ListMap.map2keys(map), ListMap.map2values(map));
    }

    private static <K, V> ListSet<K> map2keys(Map<K, V> map) {
        ListSet<K> res = ListSet.sortedAsAdded();
        res.addAll(map.keySet());
        return res;
    }

    private static <K, V> List<V> map2values(Map<K, V> map) {
        ArrayList<V> res = new ArrayList<V>();
        for (K key : map.keySet()) {
            res.add(map.get(key));
        }
        return res;
    }

    private ListMap(ListSet<K> keys, List<V> values) {
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException("Collection of keys and values must have same size. ");
        }
        this.keys = keys;
        this.values = values;
        this.valuesColl = new Values();
        this.keysSet = new Keys();
        this.entrySet = new Entries();
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    @Override
    public boolean containsValue(Object val) {
        return this.values.contains(val);
    }

    @Override
    public SortedSet<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    @Override
    public V get(Object key) {
        int idx = this.keys.getList().indexOf(key);
        if (idx == -1) {
            return null;
        }
        assert (idx >= 0 && idx < this.size());
        return this.values.get(idx);
    }

    @Override
    public boolean isEmpty() {
        assert (this.keys.isEmpty() == this.values.isEmpty());
        return this.keys.isEmpty();
    }

    @Override
    public SortedSet<K> keySet() {
        return this.keysSet;
    }

    @Override
    public V put(K key, V value) {
        int idx = this.keys.getList().indexOf(key);
        if (idx == -1) {
            this.keys.getList().add(key);
            this.values.add(value);
            return null;
        }
        assert (idx >= 0 && idx < this.size());
        return this.values.set(idx, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> other) {
        for (K key : other.keySet()) {
            this.put(key, other.get(key));
        }
    }

    @Override
    public V remove(Object key) {
        int idx = this.keys.getList().indexOf(key);
        if (idx == -1) {
            return null;
        }
        assert (idx >= 0 && idx < this.size());
        V res = this.values.get(idx);
        this.keys.getList().remove(idx);
        this.values.remove(idx);
        return res;
    }

    private boolean removeIdx(int idx) {
        if (idx == -1) {
            return false;
        }
        assert (idx >= 0 && idx < this.size());
        this.keys.getList().remove(idx);
        this.values.remove(idx);
        return true;
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.keys.comparator();
    }

    @Override
    public Collection<V> values() {
        return this.valuesColl;
    }

    @Override
    public K firstKey() {
        return (K)this.keySet().first();
    }

    @Override
    public K lastKey() {
        return (K)this.keySet().last();
    }

    @Override
    public ListMap<K, V> headMap(K toKey) {
        return this.subMap(false, (K)this.keys.obj2idx(toKey));
    }

    @Override
    public ListMap<K, V> tailMap(K fromKey) {
        return this.subMap((K)this.keys.obj2idx(fromKey), (K)this.size());
    }

    @Override
    ListMap<K, V> subMap(int fromIdx, int toIdx) {
        ListSet<K> subKeys = this.keys.subSetIdx(fromIdx, toIdx);
        List<V> subValues = this.values.subList(fromIdx, toIdx);
        return new ListMap<K, V>(subKeys, subValues);
    }

    @Override
    public ListMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap((K)this.keys.obj2idx(fromKey), (K)this.keys.obj2idx(toKey));
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        return ((Object)this.entrySet()).equals(other.entrySet());
    }

    @Override
    public int hashCode() {
        return ((Object)this.entrySet()).hashCode();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("<ListMap>\n");
        int i = 0;
        while (i < this.size()) {
            result.append("[" + this.keys.getList().get(i) + " => " + this.values.get(i) + "]\n");
            ++i;
        }
        result.append("</ListMap>\n");
        return result.toString();
    }

    public static void main(String[] args) {
        ArrayList list = new ArrayList();
        list.iterator().remove();
    }

    private class Entries
    extends AbstractSet<Map.Entry<K, V>>
    implements SortedSet<Map.Entry<K, V>> {
        private Entries() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntriesIterator();
        }

        @Override
        public int size() {
            return ListMap.this.size();
        }

        private Object getKey(Object obj) {
            Map.Entry entry = (Map.Entry)obj;
            return entry.getKey();
        }

        @Override
        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            return ListMap.this.containsKey(this.getKey(obj));
        }

        @Override
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            entry.getClass().getTypeParameters();
            return ListMap.this.keysSet.remove(this.getKey(entry));
        }

        @Override
        public void clear() {
            ListMap.this.clear();
        }

        @Override
        public Comparator<? super Map.Entry<K, V>> comparator() {
            return new Comparator<Map.Entry<K, V>>(){

                @Override
                public int compare(Map.Entry<K, V> entry1, Map.Entry<K, V> entry2) {
                    return ListMap.this.comparator().compare(entry1.getKey(), entry2.getKey());
                }
            };
        }

        private Map.Entry<K, V> key2entry(K key) {
            return new Entry(key, ListMap.this.get(key));
        }

        @Override
        public Map.Entry<K, V> first() {
            return this.key2entry(ListMap.this.keys.first());
        }

        @Override
        public Map.Entry<K, V> last() {
            return this.key2entry(ListMap.this.keys.last());
        }

        @Override
        public SortedSet<Map.Entry<K, V>> subSet(Map.Entry<K, V> fromElement, Map.Entry<K, V> toElement) {
            return ((ListMap)ListMap.this.subMap(fromElement.getKey(), toElement.getKey())).entrySet();
        }

        @Override
        public SortedSet<Map.Entry<K, V>> headSet(Map.Entry<K, V> toElement) {
            return ((ListMap)ListMap.this.headMap(toElement.getKey())).entrySet();
        }

        @Override
        public SortedSet<Map.Entry<K, V>> tailSet(Map.Entry<K, V> fromElement) {
            return ((ListMap)ListMap.this.tailMap(fromElement.getKey())).entrySet();
        }
    }

    private class EntriesIterator
    extends XIterator
    implements Iterator<Map.Entry<K, V>> {
        private EntriesIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            int idx = this.lIter.nextIndex();
            return new Entry(this.lIter.next(), ListMap.this.values.get(idx));
        }
    }

    private final class Entry
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        private Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode() + this.getValue().hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)obj;
            return Objects.equals(this.getKey(), other.getKey()) && Objects.equals(this.getValue(), other.getValue());
        }
    }

    private class Keys
    extends AbstractSet<K>
    implements SortedSet<K> {
        private Keys() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return ListMap.this.size();
        }

        @Override
        public boolean contains(Object obj) {
            return ListMap.this.containsKey(obj);
        }

        @Override
        public boolean remove(Object obj) {
            int idx = ListMap.this.keys.getList().indexOf(obj);
            return ListMap.this.removeIdx(idx);
        }

        @Override
        public void clear() {
            ListMap.this.clear();
        }

        @Override
        public Comparator<? super K> comparator() {
            return ListMap.this.comparator();
        }

        @Override
        public K first() {
            return ListMap.this.keys.first();
        }

        @Override
        public K last() {
            return ListMap.this.keys.last();
        }

        @Override
        public SortedSet<K> subSet(K fromElement, K toElement) {
            return ((ListMap)ListMap.this.subMap(fromElement, toElement)).keySet();
        }

        @Override
        public SortedSet<K> headSet(K toElement) {
            return ((ListMap)ListMap.this.headMap(toElement)).keySet();
        }

        @Override
        public SortedSet<K> tailSet(K fromElement) {
            return ((ListMap)ListMap.this.tailMap(fromElement)).keySet();
        }
    }

    private class KeysIterator
    extends XIterator
    implements Iterator<K> {
        private KeysIterator() {
        }

        @Override
        public K next() {
            return this.lIter.next();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int size() {
            return ListMap.this.size();
        }

        @Override
        public boolean contains(Object obj) {
            return ListMap.this.containsValue(obj);
        }

        @Override
        public boolean remove(Object obj) {
            int idx = ListMap.this.values.indexOf(obj);
            return ListMap.this.removeIdx(idx);
        }

        @Override
        public void clear() {
            ListMap.this.clear();
        }
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"}, justification="bug in findbugs")
    private class ValuesIterator
    extends XIterator
    implements Iterator<V> {
        private ValuesIterator() {
        }

        @Override
        public V next() {
            int idx = this.lIter.nextIndex();
            this.lIter.next();
            return ListMap.this.values.get(idx);
        }
    }

    private abstract class XIterator {
        protected final ListIterator<K> lIter;

        XIterator() {
            this.lIter = ListMap.this.keys.getList().listIterator();
        }

        public boolean hasNext() {
            return this.lIter.hasNext();
        }

        public void remove() {
            int idxPrev = this.lIter.previousIndex();
            if (idxPrev == -1) {
                throw new IllegalStateException();
            }
            ListMap.this.removeIdx(idxPrev);
        }
    }
}

