/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

import java.util.AbstractList;
import java.util.BitSet;
import java.util.Collection;

public final class BitSetList
extends AbstractList<Integer>
implements Cloneable {
    private BitSet wrapped;
    private int size;

    public BitSetList() {
        this(0);
    }

    public BitSetList(Collection<? extends Integer> coll) {
        this(coll.size() / 2);
        this.addAll(coll);
    }

    public BitSetList(int initialCapacity) {
        this.wrapped = new BitSet(initialCapacity);
        this.size = 0;
    }

    private static Integer bool2int(boolean bool) {
        return bool ? 1 : 0;
    }

    private static boolean int2bool(int num) {
        assert (num == 0 || num == 1);
        return num != 0;
    }

    public int cardinality() {
        return this.wrapped.cardinality();
    }

    public int sizeInternally() {
        return this.wrapped.size();
    }

    public int length1() {
        return this.wrapped.length();
    }

    public void setW(int index) {
        this.wrapped.set(index);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Integer cand : this) {
            hashCode = 31 * hashCode + cand;
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public void add(int index, Integer integer) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        switch (integer) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        ++this.size;
        int i = this.size();
        while (i > index) {
            this.wrapped.set(i, this.wrapped.get(i - 1));
            --i;
        }
        this.wrapped.set(index, BitSetList.int2bool(integer));
    }

    @Override
    public void clear() {
        this.wrapped.clear();
        this.size = 0;
    }

    @Override
    public boolean contains(Object object) {
        int cand = (Integer)object;
        switch (cand) {
            case 0: {
                return this.wrapped.length() != this.wrapped.cardinality();
            }
            case 1: {
                return this.wrapped.length() != 0;
            }
        }
        return false;
    }

    @Override
    public Integer get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int ret = BitSetList.bool2int(this.wrapped.get(index));
        return ret;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean remove(Object object) {
        int cand = (Integer)object;
        switch (cand) {
            case 0: {
                if (this.wrapped.length() == this.wrapped.cardinality()) {
                    return false;
                }
                assert (this.wrapped.length() > this.wrapped.cardinality());
                int i = 0;
                while (i < this.wrapped.length()) {
                    if (!this.wrapped.get(i)) {
                        this.remove(i);
                    }
                    ++i;
                }
                return true;
            }
            case 1: {
                if (this.wrapped.length() == 0) {
                    return false;
                }
                this.wrapped.clear(this.wrapped.length() - 1);
                return true;
            }
        }
        return false;
    }

    @Override
    public Integer remove(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        Integer ret = BitSetList.bool2int(this.wrapped.get(index));
        int i = index;
        while (i < this.size() - 1) {
            this.wrapped.set(i, this.wrapped.get(i + 1));
            ++i;
        }
        --this.size;
        return ret;
    }

    @Override
    public Integer set(int index, Integer integer) {
        Integer ret = this.get(index);
        this.wrapped.set(index, BitSetList.int2bool(integer));
        return ret;
    }

    public BitSetList clone() throws CloneNotSupportedException {
        BitSetList res = (BitSetList)super.clone();
        res.wrapped = (BitSet)this.wrapped.clone();
        assert (res.size == this.size);
        return res;
    }
}

