/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class RealRepresentation {
    public static final Cutter ALIGN_CUT_OFF_LEFT = new Cutter(){

        @Override
        public String cut(String str, int len) {
            int strLen = str.length();
            return str.substring(strLen - len, strLen);
        }
    };
    public static final Cutter ALIGN_CUT_OFF_RIGHT = new Cutter(){

        @Override
        public String cut(String str, int len) {
            return str.substring(0, len);
        }
    };
    public static final Cutter ALIGN_EXCEPTION = new Cutter(){

        @Override
        public String cut(String str, int len) {
            throw new IllegalArgumentException("String \"" + str + "\" longer than expected (" + len + "). ");
        }
    };
    public static final Cutter ALIGN_LEAVE_UNCHANGED = new Cutter(){

        @Override
        public String cut(String str, int len) {
            return str;
        }
    };
    private static final Map<Character, String> FILL_STRINGS = new HashMap<Character, String>();
    public static final String EXP_CHAR = "e";
    private static String noPointS = " ";
    private static final String POINT_S = ".";
    private static final String SIGN_PLUS = "+";
    private static final String SIGN_MINUS = "-";
    protected String sign;
    protected String integer;
    protected String fraction;
    protected String exponent;
    private String signOfExp;
    private String unsignedExp;

    public static void compensatePoint(boolean compensate) {
        noPointS = compensate ? " " : "";
    }

    @SuppressWarnings(value={"URF_UNREAD_FIELD"}, justification="to be used in later versions ")
    protected final void initSignExp() {
        Number2SignUnsigned sus = new Number2SignUnsigned(this.exponent);
        this.signOfExp = sus.getSign();
        this.unsignedExp = sus.getUnSigned();
    }

    public static RealRepresentation create(String val, boolean precision) {
        return precision ? new BigDecimalRep(val) : new DoubleRep(val);
    }

    public static RealRepresentation create(Number val, boolean precision) {
        if (precision) {
            return val instanceof BigDecimal ? new BigDecimalRep((BigDecimal)val) : new DoubleRep((double)((Double)val));
        }
        return new DoubleRep(val.doubleValue());
    }

    public static RealRepresentation create(double val, boolean precision) {
        return RealRepresentation.create((Number)val, precision);
    }

    public static RealRepresentation create(Number val) {
        return val instanceof BigDecimal ? RealRepresentation.create((BigDecimal)val, true) : RealRepresentation.create((Double)val, false);
    }

    public static String fill(char chr0, int len) {
        Character chr = Character.valueOf(chr0);
        String cutString = FILL_STRINGS.get(chr);
        boolean copyBack = false;
        if (cutString == null) {
            cutString = chr.toString();
            copyBack = true;
        }
        if (cutString.length() < len) {
            copyBack = true;
            StringBuffer cutBuf = new StringBuffer(cutString);
            while (cutBuf.length() < len) {
                cutBuf.append(cutBuf);
            }
            cutString = cutBuf.toString();
        }
        if (copyBack) {
            FILL_STRINGS.put(chr, cutString);
        }
        return cutString.substring(0, len);
    }

    public static String alignLeft(String str, int len, char filler, Cutter cutter) {
        int strLen = str.length();
        return strLen > len ? cutter.cut(str, len) : str + RealRepresentation.fill(filler, len - strLen);
    }

    public static String alignRight(String str, int len, char filler, Cutter cutter) {
        int strLen = str.length();
        return strLen > len ? cutter.cut(str, len) : RealRepresentation.fill(filler, len - strLen) + str;
    }

    public final String trimInteger(int numDigits, char blankOrNull, boolean strict) {
        Cutter cutter = strict ? ALIGN_EXCEPTION : ALIGN_LEAVE_UNCHANGED;
        this.integer = RealRepresentation.alignRight(this.integer, numDigits, blankOrNull, cutter);
        return this.integer;
    }

    public final String trimExponent(int numDigits, char blankOrNull, boolean strict) {
        Cutter cutter = strict ? ALIGN_EXCEPTION : ALIGN_LEAVE_UNCHANGED;
        this.exponent = RealRepresentation.alignRight(this.exponent, numDigits, blankOrNull, cutter);
        return this.exponent;
    }

    public final String trimFraction(int numDigits, char blankOrNull, Cutter cutter) {
        this.fraction = RealRepresentation.alignLeft(this.fraction, numDigits, blankOrNull, cutter);
        return this.fraction;
    }

    public final void asInteger() {
        String trimmedExponent = this.exponent.trim();
        BigInteger expVal = "".equals(trimmedExponent) ? BigInteger.ZERO : new BigInteger(trimmedExponent);
        String trimmedFraction = this.fraction.replaceAll("0* *$", "");
        expVal = expVal.subtract(new BigInteger(Integer.toString(trimmedFraction.length())));
        this.integer = this.integer + trimmedFraction;
        this.integer = this.integer.replaceAll("^[0 ]*", "");
        if (this.integer.equals("")) {
            this.integer = "0";
        }
        switch (expVal.signum()) {
            case -1: {
                throw new NumberFormatException("Could not represent " + this + " as an integer. ");
            }
            case 0: {
                break;
            }
            case 1: {
                this.integer = this.integer + RealRepresentation.fill('0', expVal.intValue());
                break;
            }
            default: {
                throw new IllegalStateException("Found signum " + expVal.signum() + " which may be only -1, 0 or 1. ");
            }
        }
        this.fraction = "";
        this.exponent = "";
    }

    public final boolean hasBlankFraction() {
        return !this.fraction.matches("^ *$");
    }

    public final boolean hasFraction() {
        return !this.fraction.matches("^0* *$");
    }

    public final boolean hasInteger() {
        return !this.integer.matches("^ *0*$");
    }

    public final boolean hasExponent() {
        return !this.exponent.matches("^ *$");
    }

    public final String sign() {
        return this.sign;
    }

    public final String exponent() {
        return this.exponent;
    }

    public final String mantissa() {
        return this.integer + (this.hasBlankFraction() ? POINT_S : noPointS) + this.fraction;
    }

    public final String integer() {
        return this.integer;
    }

    public final String fraction() {
        return this.fraction;
    }

    public final Double this2Double() {
        return Double.valueOf(this.sign + this.mantissa() + this.getExpWithE());
    }

    public final double this2double() {
        return this.this2Double();
    }

    public final BigDecimal this2BigDecimal() {
        return new BigDecimal(this.sign + this.mantissa() + this.getExpWithE());
    }

    private String getExpWithE() {
        return this.exponent.equals("") ? "" : EXP_CHAR + this.exponent;
    }

    public final String toString() {
        return (this.sign == SIGN_PLUS ? "" : this.sign) + this.mantissa() + (this.hasExponent() ? EXP_CHAR : "") + this.exponent();
    }

    public final String toString(Desc desc) {
        this.trimInteger(desc.lenI, ' ', false);
        this.trimFraction(desc.lenM - desc.lenI, ' ', desc.fractionCutter);
        this.trimExponent(desc.lenE, ' ', false);
        return (this.sign == SIGN_PLUS ? "" : this.sign) + this.mantissa() + (this.hasExponent() ? "E" : " ") + this.exponent();
    }

    public final String toStringDecomp() {
        return "sign:     " + this.sign + "\ninteger:  " + this.integer + "\nfraction: " + this.fraction + "\nexponent: " + this.exponent;
    }

    public static class Desc {
        @SuppressWarnings(value={"SS_SHOULD_BE_STATIC"}, justification="not now")
        private final boolean strictInteger = false;
        @SuppressWarnings(value={"SS_SHOULD_BE_STATIC"}, justification="not now")
        private final boolean strictExponent = false;
        private final Cutter fractionCutter = ALIGN_CUT_OFF_RIGHT;
        private final int lenI;
        private final int lenM;
        private final int lenE;

        public Desc(int lenI, int lenM, int lenE) {
            this.lenI = lenI;
            this.lenM = lenM;
            this.lenE = lenE;
        }
    }

    private static class Number2SignUnsigned {
        private final String sign;
        private final String unSigned;

        Number2SignUnsigned(String signed) {
            switch (signed.charAt(0)) {
                case '+': {
                    this.sign = RealRepresentation.SIGN_PLUS;
                    this.unSigned = signed.substring(1, signed.length());
                    break;
                }
                case '-': {
                    this.sign = RealRepresentation.SIGN_MINUS;
                    this.unSigned = signed.substring(1, signed.length());
                    break;
                }
                default: {
                    if (!signed.substring(0, 1).matches("\\d")) {
                        throw new NumberFormatException("Expected unsigned number found " + signed + ". ");
                    }
                    this.sign = RealRepresentation.SIGN_PLUS;
                    this.unSigned = signed;
                }
            }
        }

        String getSign() {
            return this.sign;
        }

        String getUnSigned() {
            return this.unSigned;
        }
    }

    public static interface Cutter {
        public String cut(String var1, int var2);
    }

    private static final class DoubleRep
    extends RealRepresentation {
        DoubleRep(double dbl) {
            String mantissa;
            if (Double.isNaN(dbl) || Double.isInfinite(dbl)) {
                throw new NumberFormatException("For input string: \"" + Math.abs(dbl) + "\"");
            }
            String str = Double.toString(dbl);
            int index = str.indexOf(69);
            if (index == -1) {
                index = str.indexOf(101);
            }
            if (index == -1) {
                this.exponent = "";
                mantissa = str;
            } else {
                this.exponent = str.substring(index + 1, str.length());
                mantissa = str.substring(0, index);
                this.initSignExp();
            }
            Number2SignUnsigned sus = new Number2SignUnsigned(mantissa);
            this.sign = sus.getSign();
            mantissa = sus.getUnSigned();
            index = mantissa.indexOf(RealRepresentation.POINT_S);
            if (index == -1) {
                throw new IllegalStateException("Unlike specified for Double.toString(double) found no decimal point in \"" + mantissa + "\". ");
            }
            this.integer = mantissa.substring(0, index);
            this.fraction = mantissa.substring(index + 1, mantissa.length());
        }

        DoubleRep(String dStr) {
            this(Double.parseDouble(dStr));
        }

        DoubleRep(Double dbl) {
            this((double)dbl);
        }
    }

    private static final class BigDecimalRep
    extends RealRepresentation {
        private static final int MAX_FRAC_DIGITS_NO_EXP = -3;
        private static final int MAX_INT_DIGITS_NO_EXP = 7;

        BigDecimalRep(BigDecimal dec) {
            switch (dec.signum()) {
                case -1: {
                    this.sign = RealRepresentation.SIGN_MINUS;
                    dec = dec.abs();
                    break;
                }
                case 0: {
                    this.sign = RealRepresentation.SIGN_PLUS;
                    this.integer = "0";
                    this.fraction = "0";
                    this.exponent = "";
                    return;
                }
                case 1: {
                    this.sign = RealRepresentation.SIGN_PLUS;
                    break;
                }
                default: {
                    throw new IllegalStateException("Found unexpected sign " + dec.signum() + ". ");
                }
            }
            int exp = -dec.scale();
            String mantissa = dec.unscaledValue().toString();
            int lenMant = mantissa.length();
            if (new BigDecimal("1.0e-3").compareTo(dec) <= 0 && new BigDecimal("1.0e7").compareTo(dec) > 0) {
                this.exponent = "";
                if (BigDecimal.valueOf(1L).compareTo(dec) > 0) {
                    mantissa = BigDecimalRep.alignRight(mantissa, 1 - exp, '0', ALIGN_EXCEPTION);
                }
                this.integer = mantissa.substring(0, lenMant + exp);
                this.fraction = mantissa.substring(lenMant + exp, lenMant);
            } else {
                this.exponent = Integer.toString(exp + lenMant - 1);
                this.integer = mantissa.substring(0, 1);
                this.fraction = mantissa.substring(1, lenMant);
            }
            this.fraction = this.fraction.replaceFirst("0*$", "");
            if (this.fraction.length() == 0) {
                this.fraction = "0";
            }
        }

        BigDecimalRep(String dStr) {
            this(new BigDecimal(dStr));
        }
    }
}

