/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

import eu.simuline.util.BasicTypesCompatibilityChecker;
import eu.simuline.util.Caster;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class ArraysExt<E> {
    public static final Object[] EMPTY = new Object[0];

    private ArraysExt() {
    }

    public static void reverse(Object[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            Object tmp = array[i];
            array[i] = array[array.length - 1 - i];
            array[array.length - 1 - i] = tmp;
        }
    }

    public static void fill(Object[] array, Object obj) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = obj;
        }
    }

    public static Object[] nCopies(int num, Object obj) {
        if (num < 0) {
            throw new IllegalArgumentException("Requested negative number of copies: " + num + ". ");
        }
        Object[] result = new Object[num];
        ArraysExt.fill(result, obj);
        return result;
    }

    public static List<Object> recAsList(Object[] array) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object obj : array) {
            if (obj instanceof Object[]) {
                result.add(ArraysExt.recAsList((Object[])obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public static Object recAsList(Object source, Class<?> cls) {
        return ArraysExt.recAsList(source, cls, Caster.BASIC_TYPES);
    }

    public static Object recAsList(Object source, Class<?> cls, Caster caster) {
        if (caster.areCompatible(cls, source)) {
            return caster.cast(source);
        }
        if (!source.getClass().isArray()) {
            throw new IllegalArgumentException("Found incompatible types: " + source + " is no array. ");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < Array.getLength(source); ++i) {
            result.add(ArraysExt.recAsList(Array.get(source, i), cls, caster));
        }
        return result;
    }

    private static Object[] createWrappedEmptyArray(Object elemArray) {
        int counter = 0;
        Class<?> type = elemArray.getClass();
        assert (type != null);
        while (type.isArray()) {
            ++counter;
            type = type.getComponentType();
        }
        assert (!type.isArray());
        assert (counter > 0);
        Class<?> wrapperCls = BasicTypesCompatibilityChecker.getWrapperCls(type, false);
        assert (wrapperCls != null && wrapperCls != Void.TYPE);
        Object result = Array.newInstance(wrapperCls, 0);
        while (counter > 1) {
            --counter;
            result = Array.newInstance(result.getClass(), 0);
        }
        return (Object[])result;
    }

    private static Object createUnWrappedEmptyArray(Object[] wrappedArray) {
        int counter = 0;
        Class<?> type = wrappedArray.getClass();
        assert (type != null);
        while (type.isArray()) {
            ++counter;
            type = type.getComponentType();
        }
        assert (!type.isArray());
        assert (counter > 0);
        Class<?> wrappedCls = BasicTypesCompatibilityChecker.getWrappedCls(type, false);
        assert (wrappedCls != null && wrappedCls != Void.TYPE);
        Object result = Array.newInstance(wrappedCls, 0);
        while (counter > 1) {
            --counter;
            result = Array.newInstance(result.getClass(), 0);
        }
        return result;
    }

    public static Object[] wrapArray(Object elemArray) {
        if (elemArray == null) {
            return null;
        }
        assert (elemArray != null);
        Class<?> arrCls = elemArray.getClass();
        if (!arrCls.isArray()) {
            throw new IllegalArgumentException("Required an array; found " + elemArray + ". ");
        }
        assert (arrCls.isArray());
        int len = Array.getLength(elemArray);
        Class<?> compType = arrCls.getComponentType();
        if (compType.isPrimitive()) {
            Class<?> compWrapperType = BasicTypesCompatibilityChecker.getWrapperCls(compType, false);
            Object[] result = (Object[])Array.newInstance(compWrapperType, len);
            for (int i = 0; i < len; ++i) {
                result[i] = Array.get(elemArray, i);
            }
            return result;
        }
        if (len == 0) {
            return ArraysExt.createWrappedEmptyArray(elemArray);
        }
        Object[] wrap0th = ArraysExt.wrapArray(Array.get(elemArray, 0));
        Object[] result = (Object[])Array.newInstance(wrap0th.getClass(), len);
        result[0] = wrap0th;
        for (int i = 1; i < len; ++i) {
            result[i] = ArraysExt.wrapArray(Array.get(elemArray, i));
        }
        return result;
    }

    public static double[] toPrimitive(Double[] arr) {
        double[] res = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = arr[i];
        }
        return res;
    }

    public static float[] toPrimitive(Float[] arr) {
        float[] res = new float[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = arr[i].floatValue();
        }
        return res;
    }

    public static long[] toPrimitive(Long[] arr) {
        long[] res = new long[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = arr[i];
        }
        return res;
    }

    public static int[] toPrimitive(Integer[] arr) {
        int[] res = new int[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = arr[i];
        }
        return res;
    }

    public static short[] toPrimitive(Short[] arr) {
        short[] res = new short[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = arr[i];
        }
        return res;
    }

    public static byte[] toPrimitive(Byte[] arr) {
        byte[] res = new byte[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = arr[i];
        }
        return res;
    }

    public static boolean[] toPrimitive(Boolean[] arr) {
        boolean[] res = new boolean[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = arr[i];
        }
        return res;
    }

    public static char[] toPrimitive(Character[] arr) {
        char[] res = new char[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = arr[i].charValue();
        }
        return res;
    }

    public static Object unWrapArray(Object[] wrappedArray) {
        if (wrappedArray == null) {
            return null;
        }
        int len = wrappedArray.length;
        Class<?> compType = wrappedArray.getClass().getComponentType();
        if (BasicTypesCompatibilityChecker.wrapsPrimitive(compType)) {
            Class<?> compWrappedType = BasicTypesCompatibilityChecker.getWrappedCls(compType, false);
            Object result = Array.newInstance(compWrappedType, len);
            for (int i = 0; i < len; ++i) {
                Array.set(result, i, wrappedArray[i]);
            }
            return result;
        }
        if (len == 0) {
            return ArraysExt.createUnWrappedEmptyArray(wrappedArray);
        }
        if (!compType.isArray()) {
            throw new IllegalArgumentException("Expected array with wrapper type entries; found " + Arrays.asList(wrappedArray) + ". ");
        }
        Object unWrap0th = ArraysExt.unWrapArray((Object[])wrappedArray[0]);
        Object[] result = (Object[])Array.newInstance(unWrap0th.getClass(), len);
        result[0] = unWrap0th;
        for (int i = 1; i < len; ++i) {
            result[i] = ArraysExt.unWrapArray((Object[])wrappedArray[i]);
        }
        return result;
    }

    public static Comparator<Object[]> getComparator(Comparator<Object> atomic) {
        return new ArrayComparator(atomic);
    }

    static class ArrayComparator<O>
    implements Comparator<O[]> {
        private final Comparator<Object> atomic;

        ArrayComparator(Comparator<Object> atomic) {
            this.atomic = atomic;
        }

        @Override
        public int compare(Object[] arr1, Object[] arr2) {
            int minLen = Math.min(arr1.length, arr2.length);
            for (int i = 0; i < minLen; ++i) {
                int result = this.atomic.compare(arr1[i], arr2[i]);
                if (result == 0) continue;
                return result;
            }
            return arr1.length - arr2.length;
        }
    }
}

