/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public abstract class Comparators<E> {
    @SuppressWarnings(value={"IL_INFINITE_RECURSIVE_LOOP"}, justification="bug in findbugs")
    public static <E> Comparator<E> getNegative(final Comparator<E> cmp) {
        return new Comparator<E>(){

            @Override
            public int compare(E obj1, E obj2) {
                return cmp.compare(obj2, obj1);
            }
        };
    }

    public static <E> Comparator<E> getInv(final Comparator<E> cmp) {
        return new Comparator<E>(){

            @Override
            public int compare(E obj1, E obj2) {
                return cmp.compare(obj2, obj1);
            }
        };
    }

    public static <E> Comparator<E> getCascade(Collection<Comparator<E>> seq) {
        return new Cascade<E>(seq);
    }

    public static <E> Comparator<E> getAsListed(List<E> seq) {
        return new AsListed<E>(seq);
    }

    private static class AsListed<E>
    implements Comparator<E>,
    Serializable {
        private static final long serialVersionUID = -2479143000061671589L;
        private final List<E> seq;

        AsListed(List<E> seq) {
            if (seq == null) {
                throw new NullPointerException();
            }
            this.seq = seq;
            assert (this.seq != null);
        }

        @Override
        public int compare(E obj1, E obj2) {
            int idx1 = this.seq.indexOf(obj1);
            int idx2 = this.seq.indexOf(obj2);
            if (idx1 == -1 || idx2 == -1) {
                return this.seq.indexOf(obj2) - this.seq.indexOf(obj1);
            }
            return this.seq.indexOf(obj1) - this.seq.indexOf(obj2);
        }
    }

    private static class Cascade<E>
    implements Comparator<E>,
    Serializable {
        private static final long serialVersionUID = -2479143000061671589L;
        private final Collection<Comparator<E>> seq;

        Cascade(Collection<Comparator<E>> seq) {
            this.seq = seq;
        }

        @Override
        public int compare(E obj1, E obj2) {
            for (Comparator<E> cmp : this.seq) {
                int res = cmp.compare(obj1, obj2);
                if (res == 0) continue;
                return res;
            }
            return 0;
        }
    }
}

