/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.util;

import eu.simuline.util.CyclicIterator;
import eu.simuline.util.CyclicList;
import eu.simuline.util.EmptyCyclicListException;
import eu.simuline.util.NotYetImplementedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class CyclicArrayList<E>
implements CyclicList<E>,
Cloneable {
    private final List<E> list;

    public CyclicArrayList() {
        this(new ArrayList());
    }

    public CyclicArrayList(E[] list) {
        this(Arrays.asList(list));
    }

    public CyclicArrayList(List<? extends E> list) {
        this.list = new ArrayList<E>(list);
    }

    public CyclicArrayList(CyclicList<? extends E> other) {
        this(other.asList());
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public CyclicList<E> getInverse() {
        CyclicArrayList<E> result = new CyclicArrayList<E>();
        for (int i = this.size() - 1; i >= 0; --i) {
            result.add(this.get(i));
        }
        return result;
    }

    @Override
    public boolean contains(Object obj) {
        return this.list.contains(obj);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.list.containsAll(coll);
    }

    @Override
    public CyclicIterator<E> cyclicIterator(int index) {
        return new CyclicArrayIterator(this, index);
    }

    @Override
    public Iterator<E> iterator() {
        return this.cyclicIterator(0);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(0);
    }

    @Override
    public <E> E[] toArray(E[] ret) {
        return this.toArray(0, ret);
    }

    @Override
    public Object[] toArray(int index) {
        return this.toArray(index, new Object[this.list.size()]);
    }

    @Override
    public <E> E[] toArray(int index, E[] ret) {
        return ((CyclicArrayList)this.cycle((int)index)).list.toArray(ret);
    }

    @Override
    public List<E> asList(int index) {
        return ((CyclicArrayList)this.cycle(index)).asList();
    }

    @Override
    public List<E> asList() {
        return new ArrayList<E>(this.list);
    }

    @Override
    public CyclicArrayList<E> cycle(int index) {
        if (this.size() == 0) {
            return new CyclicArrayList<E>(this);
        }
        index = this.shiftIndex(index);
        ArrayList<E> ret = new ArrayList<E>(this.size());
        ret.addAll(this.list.subList(index, this.size()));
        ret.addAll(this.list.subList(0, index));
        return new CyclicArrayList(ret);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CyclicList)) {
            return false;
        }
        CyclicList other = (CyclicList)obj;
        return this.asList().equals(other.asList());
    }

    @Override
    public boolean equalsCyclic(Object obj) {
        if (!(obj instanceof CyclicList)) {
            return false;
        }
        CyclicList other = (CyclicList)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.size(); ++i) {
            CyclicIterator otherIt;
            CyclicIterator<E> thisIt = this.cyclicIterator(i);
            if (!thisIt.retEquals(otherIt = other.cyclicIterator(0))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E obj : this) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    @Override
    public int hashCodeCyclic() {
        int hashCode = 0;
        for (E element : this.list) {
            hashCode += element == null ? 0 : element.hashCode();
        }
        return hashCode;
    }

    @Override
    public int shiftIndex(int index) throws EmptyCyclicListException {
        return this.shiftIndex(index, this.size());
    }

    public int shiftIndex(int index, int size) throws EmptyCyclicListException {
        if (size == 0) {
            throw new EmptyCyclicListException();
        }
        if ((index %= size) < 0) {
            index += size;
        }
        assert (0 <= index && index < size);
        return index;
    }

    @Override
    public E get(int index) throws EmptyCyclicListException {
        return this.list.get(this.shiftIndex(index));
    }

    @Override
    public E set(int index, E element) throws EmptyCyclicListException {
        index = this.shiftIndex(index);
        return this.list.set(index, element);
    }

    @Override
    public void replace(int index, Iterator<E> iter) {
        if (!iter.hasNext()) {
            throw new IllegalArgumentException("Could not replace " + index + "th element because of void iterator " + iter + ". ");
        }
        this.set(index++, iter.next());
        this.addAll(index, iter);
    }

    @Override
    public void replace(int index, List<E> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Could not replace " + index + "th element with empty list. ");
        }
        this.set(index++, list.get(0));
        this.addAll(index, list.subList(1, list.size()));
    }

    @Override
    public void addAll(int index, Iterator<E> iter) {
        while (iter.hasNext()) {
            this.add(index++, iter.next());
        }
    }

    @Override
    public void addAll(int index, List<? extends E> addList) {
        if (addList.isEmpty()) {
            return;
        }
        ArrayList<E> oldList = new ArrayList<E>(this.list);
        this.list.clear();
        int newSize = oldList.size() + addList.size();
        index = this.shiftIndex(index, newSize);
        System.out.println("newSize: " + newSize);
        System.out.println("index: " + index);
        if (index + addList.size() <= newSize) {
            this.list.addAll(oldList.subList(0, index));
            this.list.addAll(addList);
            this.list.addAll(oldList.subList(index, newSize - addList.size()));
        } else {
            int ind1 = (index + addList.size()) % newSize;
            int addLen1 = addList.size() - ind1;
            assert (ind1 <= index);
            this.list.addAll(addList.subList(addLen1, addLen1 + ind1));
            this.list.addAll(oldList);
            this.list.addAll(addList.subList(0, addLen1));
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        this.list.add(this.shiftIndex(index, this.size() + 1), element);
    }

    @Override
    public boolean add(E element) {
        return this.list.add(element);
    }

    @Override
    public E remove(int index) throws EmptyCyclicListException {
        return this.list.remove(this.shiftIndex(index));
    }

    @Override
    public boolean remove(Object obj) {
        return this.list.remove(obj);
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        boolean result = false;
        Iterator<?> iter = coll.iterator();
        while (iter.hasNext()) {
            result |= this.remove(iter.next());
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        boolean result = false;
        for (E cand : this) {
            if (coll.contains(cand)) continue;
            this.remove(cand);
            result = true;
        }
        return result;
    }

    @Override
    public int getIndexOf(int idx, Object obj) {
        for (int i = idx; i < this.list.size() + idx; ++i) {
            if (!Objects.equals(this.list.get(i), obj)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public CyclicList<E> getCopy(int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Positive length expected; found: " + len + ". ");
        }
        if (this.isEmpty()) {
            if (len == 0) {
                return new CyclicArrayList<E>();
            }
            throw new EmptyCyclicListException();
        }
        ArrayList<E> newList = new ArrayList<E>(len);
        for (int i = 0; i < len / this.size(); ++i) {
            newList.addAll(this.list);
        }
        newList.addAll(this.list.subList(0, len % this.size()));
        return new CyclicArrayList(newList);
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("<CyclicList>\n");
        for (int i = 0; i < this.size(); ++i) {
            res.append("" + this.get(i) + " ");
        }
        res.append("</CyclicList>\n");
        return res.toString();
    }

    public CyclicArrayList<E> clone() throws CloneNotSupportedException {
        return new CyclicArrayList<E>((List)((ArrayList)this.list).clone());
    }

    public static final class CyclicArrayIterator<E>
    implements CyclicIterator<E> {
        private StateIter calledLast;
        private int index;
        private int startIndex;
        private CyclicArrayList<E> cal;

        public CyclicArrayIterator(CyclicArrayList<E> cal, int index) {
            this.cal = cal;
            this.startIndex = this.index = this.cal.isEmpty() ? -1 : this.cal.shiftIndex(index);
            this.calledLast = StateIter.CALLED_NOTHING;
        }

        public CyclicArrayIterator(CyclicArrayList<E> cal, CyclicArrayIterator<E> iter) {
            this(cal, iter.index);
        }

        @Override
        public int getFirstIndex() {
            return this.startIndex;
        }

        @Override
        public void refresh() {
            if (this.cal.isEmpty()) {
                return;
            }
            this.startIndex = this.index = this.cal.shiftIndex(this.index);
            this.calledLast = StateIter.CALLED_NOTHING;
        }

        @Override
        public void setIndex(int index) {
            if (this.cal.isEmpty()) {
                return;
            }
            this.index = this.cal.shiftIndex(index);
            while (this.index < this.startIndex) {
                this.index += this.cal.size();
            }
        }

        @Override
        public int getIndex() {
            return this.cal.size() == 0 ? this.index : this.index % this.cal.size();
        }

        @Override
        public CyclicList<E> getCyclicList() {
            return this.cal;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.startIndex + this.cal.size();
        }

        @Override
        public E next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.calledLast = StateIter.CALLED_NEXT;
            return this.cal.get(this.index++);
        }

        @Override
        public boolean hasPrev() {
            return this.index > this.startIndex;
        }

        @Override
        public E previous() throws NoSuchElementException {
            if (!this.hasPrev()) {
                throw new NoSuchElementException();
            }
            this.calledLast = StateIter.CALLED_PREVIOUS;
            return this.cal.get(--this.index);
        }

        @Override
        public int getNextIndexOf(E obj) {
            if (this.cal.isEmpty()) {
                return -1;
            }
            int oldPointer = this.getIndex();
            if (obj == null) {
                while (this.hasNext()) {
                    if (this.next() != null) continue;
                    this.previous();
                    return this.getIndex();
                }
            } else {
                while (this.hasNext()) {
                    if (!obj.equals(this.next())) continue;
                    this.previous();
                    return this.getIndex();
                }
            }
            this.setIndex(oldPointer);
            return -1;
        }

        @Override
        public void add(E obj) {
            this.cal.add(this.index, obj);
            if (this.index % this.cal.size() < this.startIndex % this.cal.size()) {
                ++this.startIndex;
            }
            ++this.index;
            this.calledLast = StateIter.CALLED_ADD;
        }

        @Override
        public void addAll(List<? extends E> addList) {
            this.cal.addAll(this.index, addList);
            if (this.cal.isEmpty()) {
                this.index = -1;
                this.startIndex = -1;
                return;
            }
            if (this.index % this.cal.size() < this.startIndex % this.cal.size()) {
                this.startIndex += addList.size();
            }
            this.index += addList.size();
            this.calledLast = StateIter.CALLED_ADD;
        }

        @Override
        public void set(E obj) {
            switch (this.calledLast) {
                case CALLED_ADD: 
                case CALLED_REMOVE: 
                case CALLED_NOTHING: {
                    throw new IllegalStateException("No pointer to set object <" + obj + ">. ");
                }
                case CALLED_NEXT: {
                    this.cal.set(this.index - 1, obj);
                    break;
                }
                case CALLED_PREVIOUS: {
                    this.cal.set(this.index, obj);
                    break;
                }
                default: {
                    throw new IllegalStateException("****");
                }
            }
        }

        @Override
        public void remove() {
            switch (this.calledLast) {
                case CALLED_ADD: 
                case CALLED_REMOVE: 
                case CALLED_NOTHING: {
                    throw new IllegalStateException("No pointer to remove object. ");
                }
                case CALLED_NEXT: {
                    --this.index;
                    this.cal.remove(this.index);
                    if (this.index > this.startIndex % this.cal.size()) break;
                    --this.startIndex;
                    break;
                }
                case CALLED_PREVIOUS: {
                    this.cal.remove(this.index);
                    break;
                }
                default: {
                    throw new IllegalStateException("****");
                }
            }
            this.calledLast = StateIter.CALLED_REMOVE;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof CyclicIterator)) {
                return false;
            }
            CyclicIterator otherIter = (CyclicIterator)other;
            return this.cal.equals(otherIter.getCyclicList()) && this.getFirstIndex() == otherIter.getFirstIndex() && this.getIndex() == otherIter.getIndex();
        }

        public int hashCode() {
            return this.cal.hashCode() + this.getIndex() + this.getFirstIndex();
        }

        @Override
        public boolean retEquals(CyclicIterator<?> other) {
            while (this.hasNext() && other.hasNext()) {
                E thi = this.next();
                Object obj = other.next();
                if (!(thi == null ? obj != null : !thi.equals(obj))) continue;
                return false;
            }
            return !(this.hasNext() ^ other.hasNext());
        }

        @Override
        public double dist(CyclicIterator<E> other) {
            throw new NotYetImplementedException();
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append("<CyclicIterator firstIndex=\"");
            ret.append(Integer.toString(this.startIndex));
            ret.append("\" index=\"");
            ret.append(Integer.toString(this.index));
            ret.append("\">\n");
            ret.append(this.getCyclicList().toString());
            ret.append("</CyclicIterator>\n");
            return ret.toString();
        }
    }

    static enum StateIter {
        CALLED_NOTHING,
        CALLED_PREVIOUS,
        CALLED_NEXT,
        CALLED_ADD,
        CALLED_REMOVE;

    }
}

