/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.relana.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Package {
    public static final Package BUILD_IN = new Package("_BuiltInPackage", null);
    static final Package ROOT = new Package("", null);
    private final String name;
    private final Package superPackage;
    private final Map<String, Package> subPackages;

    private Package(String name, Package superPackage) {
        this.name = name;
        this.superPackage = superPackage;
        this.subPackages = new HashMap<String, Package>();
    }

    String getName() {
        return this.name;
    }

    public String getPathName() {
        return this.getSuperPackage() == null ? "" : this.getSuperPackage().getPathName() + this.getName() + ".";
    }

    public List<String> getPath() {
        ArrayList<String> path = new ArrayList<String>();
        this.addName(path);
        return path;
    }

    private void addName(List<String> path) {
        if (this.getSuperPackage() != null) {
            this.getSuperPackage().addName(path);
            path.add(this.getName());
        }
    }

    Package getSuperPackage() {
        return this.superPackage;
    }

    Package addSubPackage(String name) {
        return this.subPackages.put(name, new Package(name, this));
    }

    Package subPackage(String name) {
        return this.subPackages.get(name);
    }

    public static Package getPackage(List<String> path) {
        Package knot = ROOT;
        for (int i = 0; i < path.size(); ++i) {
            Package cand = knot.subPackage(path.get(i));
            if (cand != null) {
                knot = cand;
                continue;
            }
            cand = knot.addSubPackage(path.get(i));
            assert (cand == null);
            knot = knot.subPackage(path.get(i));
            assert (knot != null);
        }
        return knot;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("package ");
        res.append(this.getPath().toString());
        return res.toString();
    }
}

