/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.relana.expressions;

import eu.simuline.relana.expressions.FormulaDecl;
import eu.simuline.relana.expressions.Type;
import eu.simuline.relana.model.Deficiency;
import eu.simuline.relana.model.DeficiencyMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class Operation {
    abstract boolean arity1();

    abstract boolean isIsoAntitone();

    public abstract Type retType(Set<FormulaDecl> var1);

    public abstract Eval getEval(Type var1);

    public static Operation getOperation(BaseOps baseOps) {
        return baseOps.getOperation();
    }

    public static Operation getOperation(String funName, boolean isInverted, DeficiencyMap map, Functor funct) {
        return new Maps(funName, isInverted, map, funct);
    }

    public static interface Eval {
        public Set<Deficiency> eval(Set<Set<Deficiency>> var1);

        public Operation getOperation();
    }

    public static final class Maps
    extends Operation
    implements Eval {
        private final String funName;
        private final boolean isInverted;
        private final DeficiencyMap map;
        private final Functor funct;

        public Maps(String funName, boolean isInverted, DeficiencyMap map, Functor funct) {
            this.funName = funName;
            this.isInverted = isInverted;
            this.map = map;
            this.funct = funct;
            if (!funct.isAllowed(map)) {
                throw new IllegalArgumentException("Map \"" + this.funName + "\" is not " + funct.twistIsotone() + " and so corresponding functor \"" + this + "\" is not defined. ");
            }
        }

        private DeficiencyMap getMap() {
            return this.map;
        }

        @Override
        boolean arity1() {
            return true;
        }

        @Override
        public Type retType(Set<FormulaDecl> args) {
            return this.funct.retType(args, this);
        }

        @Override
        public Set<Deficiency> eval(Set<Set<Deficiency>> param) {
            return this.funct.eval(param, this.map);
        }

        @Override
        public Eval getEval(Type type) {
            return this;
        }

        @Override
        public Operation getOperation() {
            return this;
        }

        @Override
        public boolean isIsoAntitone() {
            return true;
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            res.append(this.funName);
            if (this.isInverted) {
                res.append('!');
            }
            res.append(this.funct.getSymbol());
            return res.toString();
        }
    }

    public static abstract class Functor
    extends Enum<Functor> {
        public static final /* enum */ Functor Covariant = new Functor(){

            @Override
            public boolean isAllowed(DeficiencyMap map) {
                return map.isTwistIsotone();
            }

            @Override
            public String twistIsotone() {
                return "twist-isotone";
            }

            @Override
            Set<Deficiency> eval(DeficiencyMap map, Set<Deficiency> defs) {
                return map.cov(defs);
            }

            @Override
            Type source(DeficiencyMap map) {
                return map.getSource().getType();
            }

            @Override
            Type target(DeficiencyMap map) {
                return map.getTarget().getType();
            }

            @Override
            String getSymbol() {
                return ",";
            }
        };
        public static final /* enum */ Functor Contravariant = new Functor(){

            @Override
            public boolean isAllowed(DeficiencyMap map) {
                return map.isIsotone();
            }

            @Override
            public String twistIsotone() {
                return "isotone";
            }

            @Override
            Set<Deficiency> eval(DeficiencyMap map, Set<Deficiency> defs) {
                return map.cont(defs);
            }

            @Override
            Type source(DeficiencyMap map) {
                return map.getTarget().getType();
            }

            @Override
            Type target(DeficiencyMap map) {
                return map.getSource().getType();
            }

            @Override
            String getSymbol() {
                return "'";
            }
        };
        private static final Map<String, Functor> ACC2FUNCT;
        private static final /* synthetic */ Functor[] $VALUES;

        public static Functor[] values() {
            return (Functor[])$VALUES.clone();
        }

        public static Functor valueOf(String name) {
            return Enum.valueOf(Functor.class, name);
        }

        public abstract boolean isAllowed(DeficiencyMap var1);

        public abstract String twistIsotone();

        abstract Type source(DeficiencyMap var1);

        abstract Type target(DeficiencyMap var1);

        Set<Deficiency> eval(Set<Set<Deficiency>> param, DeficiencyMap map) {
            assert (param.size() == 1);
            return this.eval(map, param.iterator().next());
        }

        abstract Set<Deficiency> eval(DeficiencyMap var1, Set<Deficiency> var2);

        Type retType(Set<FormulaDecl> args, Maps mapOper) {
            Type retType = args.iterator().next().retType();
            if (!this.source(mapOper.getMap()).equals(retType)) {
                throw new IllegalArgumentException("Cannot apply \"" + mapOper + "\" to formula \"" + args.iterator().next() + "\" with return type " + retType + ". ");
            }
            return this.target(mapOper.getMap());
        }

        abstract String getSymbol();

        public static Functor covCont(String acc) {
            return ACC2FUNCT.get(acc);
        }

        static {
            $VALUES = new Functor[]{Covariant, Contravariant};
            ACC2FUNCT = new HashMap<String, Functor>();
            ACC2FUNCT.put(Covariant.getSymbol(), Covariant);
            ACC2FUNCT.put(Contravariant.getSymbol(), Contravariant);
        }
    }

    static final class CompOp
    extends Operation {
        CompOp() {
        }

        @Override
        boolean arity1() {
            return true;
        }

        @Override
        public Type retType(Set<FormulaDecl> args) {
            Iterator<FormulaDecl> iter = args.iterator();
            if (!iter.hasNext()) {
                throw new IllegalArgumentException("Expected at least one argument. ");
            }
            Type proto = iter.next().retType();
            if (iter.hasNext()) {
                throw new IllegalArgumentException("Expected no more than one argument. ");
            }
            return proto.getInverse();
        }

        @Override
        public Eval getEval(final Type type) {
            return new Eval(){

                @Override
                public Set<Deficiency> eval(Set<Set<Deficiency>> param) {
                    Set<Deficiency> result = type.asSet();
                    Iterator<Set<Deficiency>> iter = param.iterator();
                    result.removeAll((Collection)iter.next());
                    assert (!iter.hasNext());
                    return result;
                }

                @Override
                public Operation getOperation() {
                    return this;
                }
            };
        }

        @Override
        boolean isIsoAntitone() {
            return false;
        }

        public String toString() {
            return "~";
        }
    }

    static final class UnionOp
    extends Operation
    implements Eval {
        UnionOp() {
        }

        @Override
        boolean arity1() {
            return false;
        }

        @Override
        public Type retType(Set<FormulaDecl> args) {
            Iterator<FormulaDecl> iter = args.iterator();
            if (!iter.hasNext()) {
                throw new IllegalArgumentException("Expected at least one argument. ");
            }
            Type proto = iter.next().retType();
            while (iter.hasNext()) {
                if (proto.equals(iter.next().retType())) continue;
                ArrayList<Type> argTypes = new ArrayList<Type>();
                for (FormulaDecl form : args) {
                    argTypes.add(form.retType());
                }
                throw new IllegalArgumentException("Expected all the same types; found " + args + " with types " + argTypes + ". ");
            }
            return proto;
        }

        @Override
        public Set<Deficiency> eval(Set<Set<Deficiency>> param) {
            HashSet<Deficiency> result = new HashSet<Deficiency>();
            for (Set<Deficiency> set : param) {
                result.addAll(set);
            }
            return result;
        }

        @Override
        public Eval getEval(Type type) {
            return this;
        }

        @Override
        public Operation getOperation() {
            return this;
        }

        @Override
        boolean isIsoAntitone() {
            return true;
        }

        public String toString() {
            return "|";
        }
    }

    static final class IntsOp
    extends Operation
    implements Eval {
        IntsOp() {
        }

        @Override
        boolean arity1() {
            return false;
        }

        @Override
        public Type retType(Set<FormulaDecl> args) {
            Iterator<FormulaDecl> iter = args.iterator();
            if (!iter.hasNext()) {
                throw new IllegalArgumentException("Expected at least one argument. ");
            }
            Type proto = iter.next().retType();
            while (iter.hasNext()) {
                if (proto.equals(iter.next().retType())) continue;
                ArrayList<Type> argTypes = new ArrayList<Type>();
                for (FormulaDecl form : args) {
                    argTypes.add(form.retType());
                }
                throw new IllegalArgumentException("Expected all the same types; found " + args + " with types " + argTypes + ". ");
            }
            return proto;
        }

        @Override
        public Set<Deficiency> eval(Set<Set<Deficiency>> param) {
            Iterator<Set<Deficiency>> iter = param.iterator();
            assert (iter.hasNext());
            HashSet<Deficiency> result = new HashSet<Deficiency>((Collection)iter.next());
            while (iter.hasNext()) {
                result.retainAll((Collection)iter.next());
            }
            return result;
        }

        @Override
        public Eval getEval(Type type) {
            return this;
        }

        @Override
        public Operation getOperation() {
            return this;
        }

        @Override
        boolean isIsoAntitone() {
            return true;
        }

        public String toString() {
            return "&";
        }
    }

    public static enum BaseOps {
        Intersection(new IntsOp()){

            public String toString() {
                return "&";
            }
        }
        ,
        Union(new UnionOp()){

            public String toString() {
                return "|";
            }
        }
        ,
        Complement(new CompOp()){

            public String toString() {
                return "~";
            }
        };

        private static final Map<String, BaseOps> KEY2OP;
        private Operation oper;

        private BaseOps(Operation oper) {
            this.oper = oper;
        }

        Operation getOperation() {
            return this.oper;
        }

        public static Operation getOperation(String str) {
            BaseOps oper = KEY2OP.get(str);
            if (oper == null) {
                throw new IllegalStateException("Unknown operation \"" + str + "\". ");
            }
            return oper.getOperation();
        }

        static {
            KEY2OP = new HashMap<String, BaseOps>();
            KEY2OP.put(Intersection.toString(), Intersection);
            KEY2OP.put(Union.toString(), Union);
            KEY2OP.put(Complement.toString(), Complement);
        }
    }
}

