/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.relana.sys;

import eu.simuline.relana.model.CClass;
import eu.simuline.relana.model.CClassLoader;
import eu.simuline.relana.model.FlatCInstance;
import eu.simuline.relana.model.InstanceLocator;
import eu.simuline.relana.model.SInstance;
import eu.simuline.relana.sys.Project;
import eu.simuline.util.sgml.ParseExceptionHandler;
import eu.simuline.util.sgml.SGMLParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.RecognitionException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class Relana {
    public static void main(String[] args) throws MalformedURLException, IOException, SAXException, RecognitionException {
        if (args.length != 1) {
            throw new IllegalArgumentException("Expected a single argument: the project file but found " + Arrays.asList(args) + ". ");
        }
        URL proj = new URL(args[0]);
        InputStreamReader projectStr = new InputStreamReader(proj.openStream(), "UTF-8");
        SGMLParser projectParser = new SGMLParser();
        projectParser.parseXML(true);
        Project project = new Project();
        projectParser.setContentHandler((ContentHandler)project);
        projectParser.setExceptionHandler((ParseExceptionHandler)project);
        projectParser.parse((Reader)new BufferedReader(projectStr));
        System.out.println("project: " + project);
        CClassLoader loader = new CClassLoader(project.getLibrary());
        CClass cClass = loader.loadCClass(project.getBaseClass());
        System.out.println("cClass: " + cClass);
        Set<CClass.SClassDecl> decls = cClass.getEffectsRec();
        for (CClass.SClassDecl decl : decls) {
            if (!decl.isInput()) continue;
            throw new IllegalArgumentException("Found declaration of input variable " + decl + ". ");
        }
        FlatCInstance flatCInstance = cClass.getInstance().flatten();
        System.out.println("cInstance: " + flatCInstance);
        Set<InstanceLocator> outServ = project.getOutputEffects();
        System.out.println("outServ: " + outServ);
        HashMap<List<String>, SInstance> observables = new HashMap<List<String>, SInstance>();
        for (InstanceLocator loc : outServ) {
            SInstance serv = flatCInstance.getEffect(loc);
            CClass.SClassDecl decl = cClass.getEffectDecl(loc.getPath());
            if (!decl.isOutput()) {
                throw new IllegalArgumentException("Found non-output variable " + loc + ". ");
            }
            observables.put(loc.getPath(), serv);
        }
        System.out.println("observables: " + observables);
        System.out.println("\nprobabilities: ");
        for (List obs : observables.keySet()) {
            System.out.println("\nobs : " + obs + " has prob " + flatCInstance.getProb(obs));
        }
    }
}

