/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.relana.model;

import eu.simuline.relana.expressions.Type;
import eu.simuline.relana.model.Deficiency;
import eu.simuline.relana.model.DeficiencyNode;
import eu.simuline.relana.model.DeficiencySetNode;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;

public final class ProbDistr {
    private Type type;
    private Map<Deficiency, BigDecimal> def2prob;
    private Map<Inverter, Validator> validators;

    public ProbDistr(Type type, Map<Deficiency, BigDecimal> def2prob) {
        ProbDistr.checkIn01(def2prob);
        this.type = type;
        this.def2prob = def2prob;
    }

    public ProbDistr(Type type, Map<Deficiency, ProbDistr> old2ProbDistr, Map<Deficiency, BigDecimal> def2prob) {
        this(type, def2prob);
        for (ProbDistr distr : old2ProbDistr.values()) {
            this.def2prob.putAll(distr.def2prob);
        }
    }

    private static void checkIn01(Map<Deficiency, BigDecimal> def2prob) {
        for (BigDecimal prob : def2prob.values()) {
            if (prob.compareTo(BigDecimal.ONE) < 0 && prob.compareTo(BigDecimal.ZERO) > 0) continue;
            throw new IllegalArgumentException("Expected probability in (0, 1) but found " + prob + ". ");
        }
    }

    private Validator init(Inverter inv, Stack<Deficiency> minDefs, Set<DeficiencyNode> nMinNodes) {
        for (DeficiencyNode node : this.getType().getDeficiency2ordering().values()) {
            if (inv.getSuccsPreds(node).isEmpty()) {
                minDefs.push(node.getDeficiency());
                continue;
            }
            DeficiencyNode cpNode = new DeficiencyNode(node.getDeficiency());
            inv.addSuccsPreds(node, cpNode);
            nMinNodes.add(cpNode);
        }
        HashMap<Deficiency, BigDecimal> minDef2prob = new HashMap<Deficiency, BigDecimal>();
        for (Deficiency minDef : minDefs) {
            minDef2prob.put(minDef, inv.filterProb(this.getProb(minDef)));
        }
        return new Validator(minDef2prob);
    }

    Validator getValidator(Inverter inv) {
        Stack<Deficiency> minDefs = new Stack<Deficiency>();
        HashSet<DeficiencyNode> nMinNodes = new HashSet<DeficiencyNode>();
        Validator val = this.init(inv, minDefs, nMinNodes);
        while (!minDefs.isEmpty()) {
            DeficiencyNode node = this.getType().getDeficiency2ordering().get(minDefs.pop());
            Set<Deficiency> predDefs = DeficiencyNode.unwrap(inv.getSuccsPreds(node));
            TreeSet<String> namesBelow = new TreeSet<String>();
            HashSet<Deficiency> subseqDefs = new HashSet<Deficiency>();
            for (Deficiency def : predDefs) {
                namesBelow.add(inv.neg() + def.getName());
                subseqDefs.addAll(val.get(def).getDeficiencySet());
            }
            DeficiencySetNode andDefN = new DeficiencySetNode(new Deficiency(inv.andOr() + namesBelow), subseqDefs);
            BigDecimal andProb = andDefN.getProb(val.def2prob);
            String name = inv.condEventName(node.getDeficiency().getName(), namesBelow);
            Deficiency condDef = new Deficiency(name);
            BigDecimal condProb = inv.filterProb(this.getProb(node.getDeficiency())).divide(andProb, MathContext.DECIMAL128);
            val.put(condDef, condProb);
            HashSet<Deficiency> subseqCondDefs = new HashSet<Deficiency>(subseqDefs);
            subseqCondDefs.add(condDef);
            DeficiencySetNode condDefN = new DeficiencySetNode(node.getDeficiency(), subseqCondDefs);
            val.put(node.getDeficiency(), condDefN);
            Iterator iter = nMinNodes.iterator();
            while (iter.hasNext()) {
                DeficiencyNode nMinNode = (DeficiencyNode)iter.next();
                Set<DeficiencyNode> succs = inv.getSuccsPreds(nMinNode);
                if (!succs.remove(node) || !succs.isEmpty()) continue;
                iter.remove();
                minDefs.add(nMinNode.getDeficiency());
            }
        }
        return val;
    }

    private Type getType() {
        return this.type;
    }

    public BigDecimal getProb(Deficiency def) {
        BigDecimal res = this.def2prob.get(def);
        if (res == null) {
            throw new IllegalArgumentException("Deficiency \"" + def + "\" is unknown. ");
        }
        return res;
    }

    public void validate() {
        this.validators = new EnumMap<Inverter, Validator>(Inverter.class);
        this.validateUp(Inverter.Identity);
        this.validateUp(Inverter.Invert);
    }

    private void validateUp(Inverter inv) {
        Validator val = this.getValidator(inv);
        this.validators.put(inv, this.getValidator(inv));
        if (!val.isValid()) {
            throw new IllegalStateException("invalid: " + val.error());
        }
        if (val.isDegenerate()) {
            System.out.println("degenerate: " + val.warning());
        }
    }

    ProbDistr remove(Deficiency def) {
        return this;
    }

    ProbDistr add(Deficiency def) {
        return this;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("\n<ProbDistr>");
        res.append(this.def2prob);
        res.append("\n</ProbDistr>");
        return res.toString();
    }

    static class Validator {
        private final Map<Deficiency, DeficiencySetNode> extOrdering = new HashMap<Deficiency, DeficiencySetNode>();
        private final Map<Deficiency, BigDecimal> def2prob;
        private final Set<Deficiency> invalids;
        private final Set<Deficiency> degenerates;

        Validator(Map<Deficiency, BigDecimal> def2prob) {
            this.def2prob = new HashMap<Deficiency, BigDecimal>(def2prob);
            this.invalids = new HashSet<Deficiency>();
            this.degenerates = new HashSet<Deficiency>();
        }

        void put(Deficiency def, BigDecimal prob) {
            this.def2prob.put(def, prob);
            int cmp = prob.compareTo(BigDecimal.ONE);
            if (cmp == 0) {
                this.degenerates.add(def);
            }
            if (cmp > 0) {
                this.invalids.add(def);
            }
        }

        void put(Deficiency def, DeficiencySetNode dsn) {
            this.extOrdering.put(def, dsn);
        }

        DeficiencySetNode get(Deficiency def) {
            return this.extOrdering.get(def);
        }

        boolean isValid() {
            return this.invalids.isEmpty();
        }

        boolean isDegenerate() {
            return !this.degenerates.isEmpty();
        }

        Map<Deficiency, BigDecimal> error() {
            return this.warningError(this.invalids);
        }

        Map<Deficiency, BigDecimal> warning() {
            return this.warningError(this.degenerates);
        }

        Map<Deficiency, BigDecimal> warningError(Set<Deficiency> invOrDeg) {
            HashMap<Deficiency, BigDecimal> def2prob = new HashMap<Deficiency, BigDecimal>();
            for (Deficiency def : invOrDeg) {
                def2prob.put(def, this.def2prob.get(def));
            }
            return def2prob;
        }

        BigDecimal getProb(Set<Deficiency> defs) {
            HashSet<Deficiency> elDefs = new HashSet<Deficiency>();
            for (Deficiency def : defs) {
                elDefs.addAll(this.extOrdering.get(def).getDeficiencySet());
            }
            BigDecimal result = BigDecimal.ONE;
            for (Deficiency def : elDefs) {
                result = result.multiply(this.def2prob.get(def));
            }
            return result;
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            res.append("<Validator>\nextOrdering: ");
            res.append(this.extOrdering);
            res.append("\ndef2prob: ");
            res.append(this.def2prob);
            res.append("\ninvalids: ");
            res.append(this.invalids);
            res.append("\ndegenerates: ");
            res.append(this.degenerates);
            res.append("</Validator>");
            return res.toString();
        }
    }

    static enum Inverter {
        Identity{

            @Override
            BigDecimal filterProb(BigDecimal prob) {
                return prob;
            }

            @Override
            Set<DeficiencyNode> getSuccsPreds(DeficiencyNode node) {
                return node.getSuccessors();
            }

            @Override
            void addSuccsPreds(DeficiencyNode source, DeficiencyNode target) {
                target.addSuccessors(source.getSuccessors());
            }

            @Override
            String andOr() {
                return "AND";
            }

            @Override
            String condEventName(String event, SortedSet<String> conds) {
                return this.neg() + event + "|" + this.andOr() + conds;
            }

            @Override
            String neg() {
                return "";
            }
        }
        ,
        Invert{

            @Override
            BigDecimal filterProb(BigDecimal prob) {
                return BigDecimal.ONE.subtract(prob);
            }

            @Override
            Set<DeficiencyNode> getSuccsPreds(DeficiencyNode node) {
                return node.getPredecessors();
            }

            @Override
            void addSuccsPreds(DeficiencyNode source, DeficiencyNode target) {
                target.addPredecessors(source.getPredecessors());
            }

            @Override
            String andOr() {
                return "OR";
            }

            @Override
            String condEventName(String event, SortedSet<String> conds) {
                return this.andOr() + conds + "|" + this.neg() + event;
            }

            @Override
            String neg() {
                return "~";
            }
        };


        abstract BigDecimal filterProb(BigDecimal var1);

        abstract Set<DeficiencyNode> getSuccsPreds(DeficiencyNode var1);

        abstract void addSuccsPreds(DeficiencyNode var1, DeficiencyNode var2);

        abstract String andOr();

        abstract String condEventName(String var1, SortedSet<String> var2);

        abstract String neg();
    }
}

