/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.relana.model;

import eu.simuline.relana.model.Package;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ClassLocator {
    private final String name;
    private Package pkg;

    public ClassLocator(String name, Package pkg) {
        this.name = name;
        this.pkg = pkg;
    }

    public ClassLocator(ClassLocator other) {
        this(other.name, other.pkg);
    }

    public static ClassLocator getLocator(List<String> path) {
        int idxLast = path.size() - 1;
        String name = path.get(idxLast);
        return new ClassLocator(name, Package.getPackage(path.subList(0, idxLast)));
    }

    public static ClassLocator getLocator(String path) {
        return ClassLocator.getLocator(new ArrayList<String>(Arrays.asList(path.split("[.]", -1))));
    }

    public String getName() {
        return this.name;
    }

    public Package getPackage() {
        return this.pkg;
    }

    public List<String> getPath() {
        List<String> path = this.getPackage().getPath();
        path.add(this.getName());
        return path;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ClassLocator)) {
            return false;
        }
        return this.getName().equals(((ClassLocator)other).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return "<ClassLocator name=\"" + this.name + "\" package=\"" + this.pkg + "\"/>";
    }
}

