/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.relana.model;

import eu.simuline.relana.model.FlatCInstance;
import eu.simuline.relana.model.SInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class CInstance {
    private final Map<String, SInstance> effects = new TreeMap<String, SInstance>();
    private final Map<String, CInstance> components = new TreeMap<String, CInstance>();

    void addEffect(String name, SInstance sInst) {
        this.effects.put(name, sInst);
    }

    void addComponent(String name, CInstance cInst) {
        this.components.put(name, cInst);
    }

    Map<String, SInstance> getEffects() {
        return this.effects;
    }

    public SInstance getEffect(List<String> path) {
        CInstance comp = this;
        for (int i = 0; i < path.size() - 1; ++i) {
            comp = comp.components.get(path.get(i));
        }
        return comp.effects.get(path.get(path.size() - 1));
    }

    public FlatCInstance flatten() {
        ArrayList<String> longName;
        TreeMap<List<String>, SInstance> longName2effect = new TreeMap<List<String>, SInstance>(FlatCInstance.PATH_CMP);
        for (Map.Entry<String, CInstance> entry : this.components.entrySet()) {
            Map<List<String>, SInstance> effects = entry.getValue().flatten().getEffects();
            String prefix = entry.getKey();
            for (Map.Entry<List<String>, SInstance> sEntry : effects.entrySet()) {
                longName = new ArrayList(sEntry.getKey());
                longName.add(0, prefix);
                longName2effect.put(longName, sEntry.getValue());
            }
        }
        for (Map.Entry<String, Object> entry : this.effects.entrySet()) {
            longName = new ArrayList<String>();
            longName.add(entry.getKey());
            longName2effect.put(longName, (SInstance)entry.getValue());
        }
        return new FlatCInstance(longName2effect);
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("\n<CInstance><Effects>");
        res.append(this.effects);
        res.append("</Effects>\n</CInstance>\n");
        return res.toString();
    }
}

