/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.relana.expressions;

import eu.simuline.relana.model.Deficiency;
import eu.simuline.relana.model.DeficiencyNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public final class Type {
    public static final Type EMPTY = new Type();
    public static final Type BOOLEAN;
    private Map<Deficiency, DeficiencyNode> deficiency2ordering;
    private Set<Deficiency> minDefs;
    private Set<Deficiency> maxDefs;

    public Type(Map<Deficiency, DeficiencyNode> deficiency2ordering) {
        this.deficiency2ordering = deficiency2ordering;
        assert (this.consistency());
        this.initMMDefics();
    }

    public Type(Type other) {
        this(other.copy());
    }

    public Type() {
        this(new HashMap<Deficiency, DeficiencyNode>());
    }

    private boolean consistency() {
        for (DeficiencyNode node : this.deficiency2ordering.values()) {
            for (DeficiencyNode succ : node.getSuccessors()) {
                if (this.deficiency2ordering.get(succ.getDeficiency()) == succ) continue;
                return false;
            }
            for (DeficiencyNode pred : node.getPredecessors()) {
                if (this.deficiency2ordering.get(pred.getDeficiency()) == pred) continue;
                return false;
            }
        }
        return true;
    }

    public Map<Deficiency, DeficiencyNode> getDeficiency2ordering() {
        return this.deficiency2ordering;
    }

    protected void initMMDefics() {
        this.minDefs = new HashSet<Deficiency>();
        this.maxDefs = new HashSet<Deficiency>();
        for (DeficiencyNode node : this.deficiency2ordering.values()) {
            if (node.getSuccessors().isEmpty()) {
                this.minDefs.add(node.getDeficiency());
            }
            if (!node.getPredecessors().isEmpty()) continue;
            this.maxDefs.add(node.getDeficiency());
        }
    }

    public static Type getEmpty() {
        return new Type();
    }

    protected Map<Deficiency, DeficiencyNode> copy() {
        HashMap<Deficiency, DeficiencyNode> newDeficiency2ordering = new HashMap<Deficiency, DeficiencyNode>();
        for (Map.Entry<Deficiency, DeficiencyNode> entry : this.deficiency2ordering.entrySet()) {
            newDeficiency2ordering.put(entry.getKey(), new DeficiencyNode(entry.getValue()));
            assert (((DeficiencyNode)newDeficiency2ordering.get(entry.getKey())).equals(this.deficiency2ordering.get(entry.getKey())));
        }
        for (Map.Entry entry : newDeficiency2ordering.entrySet()) {
            DeficiencyNode node = (DeficiencyNode)entry.getValue();
            Set<DeficiencyNode> predSuccs = node.getPredecessors();
            HashSet predSuccsNew = new HashSet();
            for (DeficiencyNode pred : predSuccs) {
                predSuccsNew.add(newDeficiency2ordering.get(pred.getDeficiency()));
            }
            predSuccs.clear();
            predSuccs.addAll(predSuccsNew);
            predSuccs = node.getSuccessors();
            predSuccsNew = new HashSet();
            for (DeficiencyNode succ : predSuccs) {
                predSuccsNew.add(newDeficiency2ordering.get(succ.getDeficiency()));
            }
            predSuccs.clear();
            predSuccs.addAll(predSuccsNew);
        }
        return newDeficiency2ordering;
    }

    protected DeficiencyNode remove(Map<Deficiency, DeficiencyNode> def2ord, Deficiency def) {
        DeficiencyNode node = def2ord.remove(def);
        if (node == null) {
            throw new IllegalArgumentException("Tried to remove deficiency \"" + def + "\" which is not present in type " + this + ". ");
        }
        if (!node.getSuccessors().isEmpty()) {
            throw new IllegalArgumentException("Tried to remove deficiency which is not minimal: " + node.getSuccessors() + " are below. ");
        }
        for (DeficiencyNode pred : node.getPredecessors()) {
            pred.getSuccessors().remove(node);
        }
        return node;
    }

    public boolean isValid(Set<Deficiency> set) {
        for (Deficiency definSet : set) {
            DeficiencyNode node = this.deficiency2ordering.get(definSet);
            if (node == null) {
                return false;
            }
            for (DeficiencyNode succ : node.getSuccessors()) {
                if (set.contains(succ.getDeficiency())) continue;
                return false;
            }
        }
        return true;
    }

    public Set<Deficiency> asSet() {
        return this.deficiency2ordering.keySet();
    }

    public Type getInverse() {
        HashMap<Deficiency, DeficiencyNode> invDeficiency2ordering = new HashMap<Deficiency, DeficiencyNode>();
        for (Map.Entry<Deficiency, DeficiencyNode> entry : this.deficiency2ordering.entrySet()) {
            invDeficiency2ordering.put(entry.getKey(), entry.getValue().getInverse());
        }
        return new Type(invDeficiency2ordering);
    }

    public Set<Deficiency> getMin() {
        return this.minDefs;
    }

    public Set<Deficiency> getMax() {
        return this.maxDefs;
    }

    public void addAll(Map<Deficiency, DeficiencyNode> deficiency2ordering) {
        for (Map.Entry<Deficiency, DeficiencyNode> entry : deficiency2ordering.entrySet()) {
            DeficiencyNode node = this.deficiency2ordering.get(entry.getKey());
            node = node == null ? new DeficiencyNode(entry.getKey()) : new DeficiencyNode(node);
            node.addAll(entry.getValue());
            this.deficiency2ordering.put(entry.getKey(), node);
        }
        this.initMMDefics();
    }

    public void replace(Deficiency oldDef, Deficiency newDefMin, Deficiency newDefMax, Type type) {
        DeficiencyNode nodeMin = type.getDeficiency2ordering().get(newDefMin);
        DeficiencyNode nodeMax = type.getDeficiency2ordering().get(newDefMax);
        boolean assertn = true;
        assertn &= nodeMin.getSuccessors().isEmpty();
        assertn &= nodeMax.getPredecessors().isEmpty();
        DeficiencyNode node = this.deficiency2ordering.remove(oldDef);
        for (DeficiencyNode pred : node.getPredecessors()) {
            assertn &= pred.getSuccessors().remove(node);
            assertn &= pred.getSuccessors().add(nodeMax);
        }
        nodeMax.addPredecessors(node.getPredecessors());
        for (DeficiencyNode pred : node.getSuccessors()) {
            assertn &= pred.getPredecessors().remove(node);
            assertn &= pred.getPredecessors().add(nodeMin);
        }
        nodeMin.addSuccessors(node.getSuccessors());
        assert (assertn);
        this.deficiency2ordering.putAll(type.getDeficiency2ordering());
        this.initMMDefics();
    }

    public Type remove(Deficiency def) {
        Map<Deficiency, DeficiencyNode> newDef2ord = this.copy();
        this.remove(newDef2ord, def);
        return new Type(newDef2ord);
    }

    public Type removeAndAbove(Deficiency def) {
        Map<Deficiency, DeficiencyNode> newDef2ord = this.copy();
        Stack<Deficiency> defsToBeRemoved = new Stack<Deficiency>();
        defsToBeRemoved.push(def);
        while (!defsToBeRemoved.empty()) {
            def = (Deficiency)defsToBeRemoved.pop();
            DeficiencyNode node = this.remove(newDef2ord, def);
            for (DeficiencyNode pred : node.getPredecessors()) {
                defsToBeRemoved.push(pred.getDeficiency());
            }
        }
        return new Type(newDef2ord);
    }

    public boolean implies(Deficiency def1, Deficiency def2) {
        DeficiencyNode node = this.deficiency2ordering.get(def1);
        if (node == null) {
            throw new IllegalArgumentException("Deficiency \"" + def1 + "\" does not occur within type " + this + ". ");
        }
        Stack<DeficiencyNode> search = new Stack<DeficiencyNode>();
        search.push(node);
        while (!search.empty()) {
            node = (DeficiencyNode)search.pop();
            if (node.getDeficiency().equals(def2)) {
                return true;
            }
            search.addAll(node.getSuccessors());
        }
        return false;
    }

    public Set<Deficiency> getCone(Deficiency def) {
        HashSet<Deficiency> result = new HashSet<Deficiency>();
        Stack<DeficiencyNode> toBeAdded = new Stack<DeficiencyNode>();
        toBeAdded.push(this.deficiency2ordering.get(def));
        while (!toBeAdded.empty()) {
            DeficiencyNode node = (DeficiencyNode)toBeAdded.pop();
            result.add(node.getDeficiency());
            toBeAdded.addAll(node.getSuccessors());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Type)) {
            return false;
        }
        Type other = (Type)obj;
        if (!this.asSet().equals(other.asSet())) {
            return false;
        }
        for (Map.Entry<Deficiency, DeficiencyNode> entry : this.deficiency2ordering.entrySet()) {
            if (other.deficiency2ordering.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.deficiency2ordering.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\n<Type>");
        buf.append(this.deficiency2ordering);
        buf.append("</Type>");
        return buf.toString();
    }

    static {
        HashMap<Deficiency, DeficiencyNode> deficiency2ordering = new HashMap<Deficiency, DeficiencyNode>();
        deficiency2ordering.put(Deficiency.UNDET, new DeficiencyNode(Deficiency.UNDET));
        BOOLEAN = new Type(deficiency2ordering);
    }
}

