/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.relana.expressions;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import eu.simuline.relana.expressions.Operation;
import eu.simuline.relana.expressions.Type;
import eu.simuline.relana.model.Deficiency;
import eu.simuline.relana.model.SInstance;
import eu.simuline.util.NotYetImplementedException;
import java.util.HashSet;
import java.util.Set;

public abstract class Formula {
    @SuppressWarnings(value={"IC_SUPERCLASS_USES_SUBCLASS_DURING_INITIALIZATION"}, justification="check in main method: field correctly initialized ")
    public static final Formula EMPTY_EXPRESSION = Const.access$000(new HashSet(), Type.getEmpty());

    private Formula() {
    }

    public static Formula getFormula(Operation.Eval oper, Set<Formula> args) {
        Comp res = Comp.create(oper, args);
        return ((Formula)res).getMin().size() == ((Formula)res).getMax().size() ? Const.create(((Formula)res).getMin(), null) : res;
    }

    public abstract Formula remove(SInstance var1, Deficiency var2);

    public abstract Formula add(SInstance var1, Deficiency var2);

    public abstract Formula substitute(SInstance var1, Formula var2);

    public abstract Set<SInstance> getVars();

    public abstract Set<Deficiency> getConst();

    public abstract Set<Deficiency> getMin();

    public abstract Set<Deficiency> getMax();

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public static final void main(String[] args) {
        System.out.println("EE: " + EMPTY_EXPRESSION);
    }

    public static final class Comp
    extends Formula {
        private Set<Deficiency> min;
        private Set<Deficiency> max;
        private final Operation.Eval oper;
        private final Set<Formula> args;

        private Comp(Operation.Eval oper, Set<Formula> args) {
            this.oper = oper;
            this.args = args;
            HashSet<Set<Deficiency>> param = new HashSet<Set<Deficiency>>();
            for (Formula arg : args) {
                param.add(arg.getMin());
            }
            this.min = oper.eval(param);
            param = new HashSet();
            for (Formula arg : args) {
                param.add(arg.getMax());
            }
            this.max = this.oper.eval(param);
            if (!this.oper.getOperation().isIsoAntitone()) {
                Set<Deficiency> inter = this.max;
                this.max = this.min;
                this.min = inter;
            }
        }

        private static Comp create(Operation.Eval oper, Set<Formula> args) {
            return new Comp(oper, args);
        }

        @Override
        public Formula remove(SInstance serv, Deficiency def) {
            HashSet<Formula> newArgs = new HashSet<Formula>();
            for (Formula form : this.args) {
                newArgs.add(form.remove(serv, def));
            }
            return Comp.getFormula(this.oper, newArgs);
        }

        @Override
        public Formula add(SInstance serv, Deficiency def) {
            HashSet<Formula> newArgs = new HashSet<Formula>();
            for (Formula form : this.args) {
                newArgs.add(form.add(serv, def));
            }
            return Comp.getFormula(this.oper, newArgs);
        }

        @Override
        public Formula substitute(SInstance serv, Formula form) {
            HashSet<Formula> newArgs = new HashSet<Formula>();
            for (Formula arg : this.args) {
                newArgs.add(arg.substitute(serv, form));
            }
            return Comp.getFormula(this.oper, newArgs);
        }

        @Override
        public Set<SInstance> getVars() {
            HashSet<SInstance> res = new HashSet<SInstance>();
            for (Formula arg : this.args) {
                res.addAll(arg.getVars());
            }
            return res;
        }

        @Override
        public Set<Deficiency> getConst() {
            return null;
        }

        @Override
        public Set<Deficiency> getMax() {
            return this.max;
        }

        @Override
        public Set<Deficiency> getMin() {
            return this.min;
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            res.append(this.oper);
            res.append('(');
            res.append(this.args);
            res.append(')');
            return res.toString();
        }
    }

    public static final class Var
    extends Formula {
        private final SInstance varS;
        private final String name;

        public Var(SInstance varS, String name) {
            this.varS = varS;
            this.name = name;
        }

        @Override
        public Formula remove(SInstance serv, Deficiency def) {
            throw new NotYetImplementedException();
        }

        @Override
        public Formula add(SInstance serv, Deficiency def) {
            throw new NotYetImplementedException();
        }

        @Override
        public Formula substitute(SInstance serv, Formula form) {
            return serv == this.varS ? form : this;
        }

        @Override
        public Set<SInstance> getVars() {
            HashSet<SInstance> res = new HashSet<SInstance>();
            res.add(this.varS);
            return res;
        }

        @Override
        public Set<Deficiency> getConst() {
            return null;
        }

        @Override
        public Set<Deficiency> getMax() {
            return this.varS.getType().asSet();
        }

        @Override
        public Set<Deficiency> getMin() {
            return new HashSet<Deficiency>();
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            res.append("$" + this.name + "$");
            return res.toString();
        }
    }

    public static final class Const
    extends Formula {
        private final Set<Deficiency> val;
        private final Type type;

        public Const(Set<Deficiency> val, Type type) {
            this.val = val;
            this.type = type;
            if (this.type != null && !this.type.isValid(val)) {
                throw new IllegalArgumentException("invalid set " + this.val + " for type " + this.type + ". ");
            }
        }

        private static Const create(Set<Deficiency> val, Type type) {
            return new Const(val, type);
        }

        @Override
        public Formula remove(SInstance serv, Deficiency def) {
            return this;
        }

        @Override
        public Formula add(SInstance serv, Deficiency def) {
            return this;
        }

        @Override
        public Formula substitute(SInstance serv, Formula form) {
            return this;
        }

        @Override
        public Set<SInstance> getVars() {
            return new HashSet<SInstance>();
        }

        @Override
        public Set<Deficiency> getConst() {
            return this.val;
        }

        @Override
        public Set<Deficiency> getMax() {
            return this.val;
        }

        @Override
        public Set<Deficiency> getMin() {
            return this.val;
        }

        public String toString() {
            return "<>{" + this.val + "}";
        }
    }
}

