/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.relana.model;

import eu.simuline.relana.expressions.Formula;
import eu.simuline.relana.expressions.Type;
import eu.simuline.relana.model.Deficiency;
import eu.simuline.relana.model.ProbDistr;
import java.util.Set;

public final class SInstance {
    private final Type type;
    private final ProbDistr distr;
    private Formula form;
    private final String name;

    String getName() {
        return this.name;
    }

    public SInstance(Type type, ProbDistr distr, String name) {
        this.type = type;
        this.distr = distr;
        this.name = name;
        assert (!type.equals(Type.getEmpty()));
    }

    public void setFormula(Formula form) {
        this.form = form;
    }

    public SInstance(SInstance other) {
        this.type = other.type;
        this.distr = other.distr;
        this.form = other.form;
        this.name = other.name;
    }

    public Type getType() {
        return this.type;
    }

    public ProbDistr getDistr() {
        return this.distr;
    }

    public Formula getFormula() {
        return this.form;
    }

    public Set<Deficiency> getMin() {
        return this.getType().getMin();
    }

    SInstance remove(Deficiency def) {
        if (this.distr == null && this.form != null) {
            throw new IllegalArgumentException("****");
        }
        Type newType = this.getType().removeAndAbove(def);
        if (newType.equals(Type.getEmpty())) {
            return null;
        }
        return new SInstance(newType, this.distr.add(def), this.name);
    }

    SInstance add(Deficiency def) {
        if (this.distr == null && this.form != null) {
            throw new IllegalArgumentException("****");
        }
        return new SInstance(this.getType().remove(def), this.distr == null ? null : this.distr.remove(def), this.name);
    }

    SInstance substitute(SInstance serv, Formula form) {
        SInstance res = new SInstance(this);
        if (this.form != null) {
            Formula newForm = res.form.substitute(serv, form);
            res.setFormula(newForm);
        }
        return res;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("\n<SInstance name=\"");
        res.append(this.name);
        res.append("\">\nformula: ");
        res.append(this.form == null ? "null" : this.form);
        res.append("\n</SInstance>");
        return res.toString();
    }
}

