/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.relana.model;

import eu.simuline.relana.model.ClassLocator;
import eu.simuline.relana.model.Package;
import eu.simuline.relana.model.SClass;
import eu.simuline.relana.parser.SClassParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.RecognitionException;

public final class SClassLoader {
    private final URL library;
    private final Map<ClassLocator, SClass> name2class;

    public SClassLoader(URL library) {
        this.library = library;
        this.name2class = new HashMap<ClassLocator, SClass>();
        this.name2class.put(new ClassLocator("B", Package.BUILD_IN), SClass.BOOLEAN);
    }

    public SClass loadSClass(ClassLocator loc, Package pkg, Map<ClassLocator, ClassLocator> subclassDep) throws IOException, RecognitionException {
        URL url = null;
        List<String> pkgPath = pkg.getPath();
        ArrayList<String> path = new ArrayList<String>(pkgPath);
        path.add("_");
        path.addAll(loc.getPath());
        for (int i = pkgPath.size(); i >= 0; --i) {
            path.remove(i);
            ClassLocator currLoc = ClassLocator.getLocator(path);
            SClass sClass = this.name2class.get(currLoc);
            if (sClass != null) {
                return sClass;
            }
            try {
                url = new URL(this.library + currLoc.getPackage().getPathName().replace('.', '/') + currLoc.getName() + ".scl");
                File clsDoc = new File(url.toURI());
                if (!clsDoc.exists()) continue;
                return this.resolveSClass(currLoc, subclassDep);
            }
            catch (URISyntaxException e) {
                throw new IOException("Could not locate file because no uri: " + url + ". ");
            }
        }
        throw new IOException("Found no class file for " + loc + " in " + pkg + ". ");
    }

    public SClass loadSClass(ClassLocator loc, Package pkg) throws IOException, RecognitionException {
        return this.loadSClass(loc, pkg, new HashMap<ClassLocator, ClassLocator>());
    }

    private SClass resolveSClass(ClassLocator loc, Map<ClassLocator, ClassLocator> subclassDep) throws IOException, RecognitionException {
        InputStream str = new URL(this.library + loc.getPackage().getPathName().replace('.', '/') + loc.getName() + ".scl").openStream();
        SClassParser scParser = new SClassParser(str);
        scParser.setClassLoader(this);
        SClass sClass = scParser.getSClass(loc, subclassDep);
        sClass.verify();
        this.name2class.put(loc, sClass);
        return sClass;
    }
}

