/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.relana.model;

import eu.simuline.relana.expressions.Type;
import eu.simuline.relana.model.Deficiency;
import eu.simuline.relana.model.DeficiencyMap;
import eu.simuline.relana.model.DeficiencyNode;
import eu.simuline.relana.model.Package;
import eu.simuline.relana.model.VerifyException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class SClass {
    public static final String BOOL_S_CLASS_NAME = "B";
    public static final SClass BOOLEAN = new SClass();
    private final String sName;
    private final Package pkg;
    private final SClass superClass;
    private final Map<Deficiency, SClass> oldDef2innerClasses;
    private final DeficiencyMap map;
    private final Map<Deficiency, DeficiencyNode> deficiency2ordering;
    private final Type type;
    private Deficiency minDef;
    private Deficiency maxDef;

    private SClass() {
        this.sName = BOOL_S_CLASS_NAME;
        this.pkg = Package.BUILD_IN;
        this.superClass = null;
        this.oldDef2innerClasses = new HashMap<Deficiency, SClass>();
        this.deficiency2ordering = new HashMap<Deficiency, DeficiencyNode>();
        DeficiencyNode node = new DeficiencyNode(Deficiency.UNDET);
        this.deficiency2ordering.put(Deficiency.UNDET, node);
        this.type = Type.BOOLEAN;
        this.verifyMMDefics();
        this.map = null;
    }

    private SClass(String sName, Package pkg, SClass superClass, Map<Deficiency, SClass> oldDef2innerClasses, Map<Deficiency, DeficiencyNode> deficiency2ordering) {
        this.sName = sName;
        this.pkg = pkg;
        this.superClass = superClass;
        this.oldDef2innerClasses = oldDef2innerClasses;
        this.deficiency2ordering = deficiency2ordering;
        this.type = this.createType();
        this.verifyMMDefics();
        if (this.isInner()) {
            HashMap<Set<Deficiency>, Deficiency> mapAll2Undet = new HashMap<Set<Deficiency>, Deficiency>();
            mapAll2Undet.put(deficiency2ordering.keySet(), Deficiency.UNDET);
            this.map = DeficiencyMap.getSubclassMap(mapAll2Undet, this, this.getSuperClass());
        } else {
            this.map = DeficiencyMap.getSubclassMap(SClass.getMap(oldDef2innerClasses), this, this.getSuperClass());
        }
    }

    private static Map<Set<Deficiency>, Deficiency> getMap(Map<Deficiency, SClass> oldDef2intCls) {
        HashMap<Set<Deficiency>, Deficiency> setOfNew2old = new HashMap<Set<Deficiency>, Deficiency>();
        for (Map.Entry<Deficiency, SClass> entry : oldDef2intCls.entrySet()) {
            Deficiency oldDef = entry.getKey();
            Set<Deficiency> newDefs = entry.getValue().getDeclaredDeficiency2ordering().keySet();
            setOfNew2old.put(newDefs, oldDef);
        }
        return setOfNew2old;
    }

    public String getName() {
        return this.sName;
    }

    public Package getPackage() {
        return this.pkg;
    }

    public Package asPackage() {
        List<String> path = this.getPackage().getPath();
        path.add(this.getName());
        return Package.getPackage(path);
    }

    public String getPathName() {
        String res = this.getPackage().getPathName();
        return res + this.getName();
    }

    public boolean isInner() {
        return this.getSuperClass().equals(BOOLEAN) && this.getDeclaredInnerClasses().keySet().isEmpty();
    }

    public Type getType() {
        return this.type;
    }

    private Type createType() {
        if (this.getSuperClass() == null) {
            return new Type(Type.BOOLEAN);
        }
        Type result = this.isInner() ? new Type() : new Type(this.getSuperClass().getType());
        for (Map.Entry<Deficiency, SClass> entry : this.getDeclaredInnerClasses().entrySet()) {
            SClass innerCls = entry.getValue();
            Type innerType = new Type(innerCls.getType());
            HashSet<Deficiency> inter = new HashSet<Deficiency>(result.asSet());
            inter.retainAll(innerType.asSet());
            if (!inter.isEmpty()) {
                throw new IllegalArgumentException("Found duplicate property \"" + inter + "\" in enclosing class \"" + this.getPathName() + "\" overwritten by inner class. ");
            }
            result.replace(entry.getKey(), innerCls.getMinDefic(), innerCls.getMaxDefic(), innerType);
        }
        result.addAll(this.getDeclaredDeficiency2ordering());
        return result;
    }

    public SClass getSuperClass() {
        return this.superClass;
    }

    public Map<Deficiency, SClass> getDeclaredInnerClasses() {
        return this.oldDef2innerClasses;
    }

    public SClass getDeclaredInnerClass(Deficiency def) {
        SClass res = this.oldDef2innerClasses.get(def);
        if (res == null) {
            throw new IllegalArgumentException("Found no inner class for key \"" + def.getName() + "\". ");
        }
        return res;
    }

    public DeficiencyMap getDeficiencyMap() {
        return this.map;
    }

    Map<Deficiency, DeficiencyNode> getDeclaredDeficiency2ordering() {
        return this.deficiency2ordering;
    }

    private void verifyMMDefics() {
        Set<Deficiency> minDefs = this.getType().getMin();
        Set<Deficiency> maxDefs = this.getType().getMax();
        if (minDefs.size() != 1) {
            throw new VerifyException("Expected unique minimal element in class \"" + this.getPathName() + "\" but found " + minDefs + ". ");
        }
        if (maxDefs.size() != 1) {
            throw new VerifyException("Expected unique maximal element in class \"" + this.getPathName() + "\" but found " + maxDefs + ". ");
        }
        this.minDef = minDefs.toArray(new Deficiency[1])[0];
        this.maxDef = maxDefs.toArray(new Deficiency[1])[0];
    }

    public Deficiency getMinDefic() {
        return this.minDef;
    }

    public Deficiency getMaxDefic() {
        return this.maxDef;
    }

    Set<DeficiencyNode> getMinDeficN() {
        HashSet<DeficiencyNode> minDefs = new HashSet<DeficiencyNode>();
        for (DeficiencyNode node : this.deficiency2ordering.values()) {
            if (!node.getPredecessors().isEmpty()) continue;
            minDefs.add(node);
        }
        return minDefs;
    }

    public static SClass getSClass(String sName, Package pkg, SClass superClass, Map<Deficiency, SClass> oldDef2innerClasses, Map<Deficiency, DeficiencyNode> def2ord) {
        return new SClass(sName, pkg, superClass, oldDef2innerClasses, def2ord);
    }

    void verify() throws VerifyException {
        for (DeficiencyNode node1 : this.deficiency2ordering.values()) {
            Deficiency def1 = node1.getDeficiency();
            for (DeficiencyNode node2 : node1.getSuccessors()) {
                Deficiency def2super;
                Deficiency def2 = node2.getDeficiency();
                Deficiency def1super = this.getDeficiencyMap().map(def1);
                if (def1super.equals(def2super = this.getDeficiencyMap().map(def2))) {
                    throw new VerifyException("Relation \"" + def1 + "==>" + def2 + "\" should be specified in inner class because " + this.getSuperClass() + " maps both to " + def1super + ". ");
                }
                if (this.getSuperClass().getType().implies(def1super, def2super)) continue;
                throw new VerifyException("Relation \"" + def1 + "==>" + def2 + "\" not reflected by superclass " + this.getSuperClass() + ": " + def1super + "=/=>" + def2super + ". ");
            }
        }
    }

    private void verifyNoShortcut() throws VerifyException {
        for (DeficiencyNode node : this.deficiency2ordering.values()) {
            if (!DeficiencyNode.unwrap(node.getPredecessors()).contains(node.getDeficiency()) && !DeficiencyNode.unwrap(node.getSuccessors()).contains(node.getDeficiency())) continue;
            throw new VerifyException("Deficiency " + node.getDeficiency() + " is cyclically related with itself. ");
        }
    }

    public void verifyInner() throws VerifyException {
        if (this.deficiency2ordering.keySet().isEmpty()) {
            throw new VerifyException("No deficiencies found. ");
        }
        this.verifyNoShortcut();
        Set<DeficiencyNode> minDeficN = this.getMinDeficN();
        if (minDeficN.isEmpty()) {
            throw new VerifyException("Relation has no minimal elements and is hence cyclic. ");
        }
        HashSet<DeficiencyNode> occured = new HashSet<DeficiencyNode>(minDeficN);
        HashSet<DeficiencyNode> maximal = new HashSet<DeficiencyNode>(minDeficN);
        HashSet<DeficiencyNode> newMaximal = new HashSet<DeficiencyNode>();
        Iterator iter = maximal.iterator();
        while (true) {
            if (iter.hasNext()) {
                DeficiencyNode node = (DeficiencyNode)iter.next();
                newMaximal.addAll(node.getSuccessors());
                continue;
            }
            HashSet<DeficiencyNode> intersection = new HashSet<DeficiencyNode>(occured);
            intersection.retainAll(newMaximal);
            if (!intersection.isEmpty()) {
                throw new VerifyException("Relation is cyclic: consider " + intersection + ". ");
            }
            occured.addAll(newMaximal);
            maximal = newMaximal;
            newMaximal = new HashSet();
            if (maximal.isEmpty()) break;
        }
        this.verifyMMDefics();
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("<SClass name=\"");
        res.append(this.getName());
        res.append("\" \npackage=\"");
        res.append(this.getPackage().getPathName());
        if (this.getSuperClass() != null) {
            res.append("\" \nsuperClass=\"");
            res.append(this.getSuperClass().getPathName());
        }
        res.append("\">\n<Deficiencies>\n");
        res.append(this.deficiency2ordering.keySet().toString());
        res.append("\n</Deficiencies>\n\n<InnerClasses>\n");
        for (Map.Entry<Deficiency, SClass> entry : this.oldDef2innerClasses.entrySet()) {
            res.append("<InnerClass name=\"");
            res.append(entry.getKey().getName());
            res.append("\">");
            res.append(entry.getValue());
            res.append("</InnerClass>\n");
        }
        res.append("</InnerClasses>\n\n<Map>\n");
        res.append(this.map);
        res.append("</Map>\n\n<Relations>");
        for (DeficiencyNode node : this.deficiency2ordering.values()) {
            Deficiency def = node.getDeficiency();
            Iterator<DeficiencyNode> iterD = node.getSuccessors().iterator();
            while (iterD.hasNext()) {
                res.append(def);
                res.append("\n==>");
                res.append(iterD.next().getDeficiency());
                res.append('\n');
            }
        }
        res.append("</Relations>\n</SClass>\n");
        return res.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SClass)) {
            return false;
        }
        return this.getPathName().equals(((SClass)obj).getPathName());
    }

    public int hashCode() {
        return this.getPathName().hashCode();
    }
}

