/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.relana.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class InstanceLocator {
    private final List<String> path;

    public InstanceLocator(List<String> path) {
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Found empty location: []. ");
        }
        for (String name : path) {
            if (name.length() != 0) continue;
            throw new IllegalArgumentException("Found empty name in locator: " + path + ". ");
        }
        this.path = Collections.unmodifiableList(path);
    }

    public static InstanceLocator getLocator(List<String> path) {
        return new InstanceLocator(path);
    }

    public static InstanceLocator getLocator(String path) {
        return InstanceLocator.getLocator(new ArrayList<String>(Arrays.asList(path.split("[.]", -1))));
    }

    public List<String> getPath() {
        return this.path;
    }

    public boolean equals(Object other) {
        if (!(other instanceof InstanceLocator)) {
            return false;
        }
        return this.path.equals(((InstanceLocator)other).getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public String toString() {
        return "<InstanceLocator path=\"" + this.path + "\"/>";
    }
}

